---
name: quiz-writer
description: 技術研修理解度確認テストを執筆。:::quiz、:::question、:::select、:::correctディレクティブで問題構造を記述。理解度テスト、確認問題作成時に使用。
---

# 理解度確認テスト執筆 Skill

技術研修用理解度確認問題の作成基準を定義します。

## 理解度確認問題作成の情報源

**理解度確認問題作成のする上での情報源はテキスト教材（各研修コースのtextフォルダ）の内容から作成します。**
理解度確認問題のファイル名から、同じ章番号ののテキスト教材の内容を確認し、その内容に合わせて理解度確認問題を作成します。
（理解度確認問題のファイル名が`quiz/chapter-02.md`なら、`text/chapter-02.md`の内容を基に理解度確認問題を作成します。）

## 参照ルール

以下のルールファイルも参照してください：

- @rules/common/writing-style.md - 文章作成の基本方針

## 基本構造

### Frontmatter設定（必須）

各章ごとに独立したMarkdownファイルとし、frontmatterでメタデータを設定：

```yaml
---
title: [その章のタイトル]
draft: false
---
```

### ページ構成要素

- `{{ toc }}` - 目次プレースホルダー
- `:::quiz` 〜 `:::` で囲った範囲で一つの問題を定義
- `:::quiz` 〜 `:::` で囲った中にさらに次の内容を定義
  - `:::question` 〜 `:::` 問題文
  - `:::select` 〜 `:::` 解答の選択肢
  - `:::correct [正解番号]` 〜 `:::` 正解の番号と解説文

### 問題の基本構造

```markdown
:::quiz [問題のタイトル]

:::question

[問題文]

:::

:::select

1. [選択肢1]
2. [選択肢2]
3. [選択肢3]
4. [選択肢4]

:::

:::correct [正解番号]

[解説文]

:::

:::
```

## 具体例

### 基本的な4択問題

```markdown
---
title: ソースコード管理
draft: false
---

{{ toc }}

:::quiz 問題1 ソースコード管理の目的に関する問題

:::question

ソースコード管理の主な目的は何ですか？（一つ選んでください）

:::

:::select

1. ソフトウェアの性能を向上させる
2. ソースコードの変更履歴を管理する
3. 開発者のコーディングスキルを評価する
4. プロジェクト管理におけるスケジュールの管理

:::

:::correct 2

ソースコード管理の主な目的は、ソースコードの変更履歴を管理することです。これにより、過去の状態や変更内容を確認したり、競合を解決したりすることができます。

:::

:::

:::quiz 問題2 ソースコード管理のメリットに関する問題

:::question

ソースコード管理のメリットではないものはどれですか？（一つ選んでください）

:::

:::select

1. チーム開発の効率化
2. ソースコードの変更履歴の喪失
3. ソースコードのバックアップが可能
4. バージョン管理による競合の解決

:::

:::correct 2

ソースコード管理のメリットには、チーム開発の効率化、ソースコードのバックアップ、バージョン管理による競合の解決などがあります。ソースコードの変更履歴の喪失は、ソースコード管理のデメリットです。

:::

:::
```

### 空欄埋め問題パターン

```markdown
:::quiz 問題1 Gitに関する問題

:::question

Gitに関する以下の文章を読んで、後の問いに答えなさい。
- Gitは、プログラムコードの編集履歴や古いバージョンのデータを管理できる、【 A 】型のバージョン管理システムです。
- Gitの開発者は【 B 】氏です。
- Gitでバージョン管理された場所（フォルダ・ディレクトリ）を【 C 】と呼びます。
- リポジトリに対して変更履歴を記録する操作を【 D 】と呼びます。

:::

:::select

1. A: 分散型、B: Linus Torvalds、C: リポジトリ、D: コミット
2. A: 集中型、B: Richard Stallman、C: ブランチ、D: プッシュ
3. A: 集中型、B: Linus Torvalds、C: リポジトリ、D: プル
4. A: 分散型、B: Richard Stallman、C: ブランチ、D: コミット

:::

:::correct 1

Gitは分散型のバージョン管理システムであり、プログラムコードの編集履歴や古いバージョンのデータを管理できます。Gitの開発者はLinus Torvalds氏であり、リポジトリに対して変更履歴を記録する操作をコミットと呼びます。Gitで管理されたフォルダ・ディレクトリをリポジトリと呼びます。

:::

:::
```

### 複数選択問題パターン

```markdown
:::quiz 問題7 バージョン管理システムの機能に関する問題

:::question

バージョン管理システムが提供する基本的な機能はどれですか？（複数選択可）

:::

:::select

1. ファイルの変更点の履歴を管理
2. ソフトウェアの自動デプロイ
3. 過去の状態や変更内容を確認
4. 変更前の状態を復元

:::

:::correct 1,3,4

バージョン管理システムが提供する基本的な機能には、ファイルの変更点の履歴を管理、過去の状態や変更内容を確認、変更前の状態を復元する機能が含まれます。これにより、開発者は過去の状態に戻したり、変更内容を確認したりすることができます。

:::

:::
```

## 問題設計原則

### 難易度設定

1. **基礎知識問題**: 用語・概念の理解
2. **応用問題**: 実際の使用シナリオでの判断
3. **総合問題**: 複数概念の統合理解

### 問題品質

- 明確で曖昧さのない問題文
- 適切な選択肢の数と内容
- 正解が一意に決まる構成
- ひっかけ問題ではなく理解度を測る問題

### 評価バランス

- 章の重要ポイントを網羅
- 理論と実践のバランス
- 暗記ではなく理解を問う内容
