# 実行ワークフロー

## 入力の受け取り

以下のいずれか、または組み合わせを受け取り：

1. **元ポストのURL**: XのポストURLを受け取る
2. **元ポストの本文**: コピペされたポスト内容
3. **リンク先記事のURL**: ポストに含まれるリンク先のURL

## 実行手順

### 1. 情報の収集

- **ポストURLが提供された場合**: URLから投稿者・内容を把握
- **記事URLが提供された場合**: WebFetchで記事内容を取得し要約
- **本文のみの場合**: 提供された内容を分析

### 2. コンテンツの分析

- **核となるトピック**: 何についての話題か
- **主張・ポイント**: 元ポストが伝えたいこと
- **ターゲット層**: エンジニア向け？一般向け？
- **感情トーン**: ポジティブ／ネガティブ／ニュートラル
- **議論の余地**: 賛否が分かれるか、補足できるか

### 3. 5パターンの生成

PATTERNS.mdの5つのパターンに基づいて生成：

1. 共感・同意パターン
2. 補足・追加情報パターン
3. 自分の経験パターン
4. 問いかけ・議論パターン
5. 要約・ハイライトパターン

### 4. 文体の確認

- 超カジュアルな口語調
- 「まじで」「めっちゃ」「〜すぎる」などの表現
- 「です・ます調」も「だ・である調」も使わない
- 適度な絵文字使用（1投稿2-3個）

### 5. 出力の提示

- 各パターンの目的を説明
- 生成したコメント内容を表示
- おすすめ度や使い分けのヒントを追加

### 6. クリップボードへのコピー

ユーザーが選択したパターンをクリップボードにコピー

## 注意事項

- 元ポストの投稿者を尊重する（否定的すぎる内容は避ける）
- 自分のアカウントの専門性と関連づける
- 「引用リポストは交流」という意識で、対話を促す内容にする
- 炎上リスクのある内容は避ける
