# Expo SDK 52+ Breaking Changes

**Last Updated:** 2025-11-22
**Expo SDK Version:** 52.0.0+
**React Native Version:** 0.76+ (SDK 52), 0.77 (opt-in)
**Source:** [Expo SDK 52 Release Notes](https://expo.dev/changelog/2024/11-12-sdk-52)

---

## Major Breaking Changes

### 1. JSC Removed from Expo Go

**What Changed:**
JavaScriptCore (JSC) completely removed from Expo Go. Hermes is the only supported engine.

**Before (SDK 51):**
```json
// app.json
{
  "expo": {
    "jsEngine": "jsc"  // ✅ Worked in Expo Go
  }
}
```

**After (SDK 52+):**
```json
// app.json
{
  "expo": {
    "jsEngine": "hermes"  // ✅ Only option in Expo Go
  }
}
```

**Impact:**
- Cannot test JSC-specific code in Expo Go
- Must use custom dev client if JSC is required
- Most apps won't notice (Hermes is faster anyway)

**Migration:**
```bash
# If you need JSC for testing (rare):
npx expo install expo-dev-client
npm run ios  # Uses custom dev client, not Expo Go
```

---

### 2. New Architecture Required in Expo Go

**What Changed:**
Expo Go now requires New Architecture - legacy architecture unsupported.

**Impact:**
- All libraries in Expo Go must support New Architecture
- Cannot test legacy-only libraries in Expo Go
- Build-time errors if libraries aren't compatible

**Migration:**
```bash
# Check if libraries support New Architecture:
# Search: "[library name] new architecture"

# If library doesn't support, use custom dev client:
npx expo install expo-dev-client
npm run ios
```

**Common Incompatibilities:**
- Old Redux (`redux` + `redux-thunk`) → Use Redux Toolkit
- `i18n-js` → Use `react-i18next`
- CodePush → Not yet supported
- Some community navigation libraries → Check compatibility

---

### 3. Google Maps Removed from Expo Go Android (SDK 53+)

**What Changed:**
`react-native-maps` with Google Maps removed from Expo Go on Android (SDK 53+).

**Note:** Not in SDK 52, but announced for SDK 53 (Spring 2025)

**Why:**
Google Maps requires API key configuration, causing confusion in Expo Go.

**Alternative:**
Use custom dev client:

```bash
# Install dev client
npx expo install expo-dev-client react-native-maps

# Add Google Maps API key to app.json
{
  "expo": {
    "android": {
      "config": {
        "googleMaps": {
          "apiKey": "YOUR_API_KEY"
        }
      }
    },
    "ios": {
      "config": {
        "googleMapsApiKey": "YOUR_API_KEY"
      }
    }
  }
}

# Run custom dev client
npm run android
```

---

### 4. Push Notifications Warning in Expo Go

**What Changed:**
Expo Go shows warnings when using push notifications.

**Warning Message:**
```
⚠️ Push notifications are not fully supported in Expo Go.
Use a custom dev client for production testing.
```

**Why:**
Push notification configuration varies by app, requiring custom native builds.

**Fix:**
Use custom dev client for push notification testing:

```bash
npx expo install expo-dev-client expo-notifications
npm run ios
```

---

## New Features

### 1. expo/fetch (WinterCG-compliant)

**What's New:**
Standards-compliant `fetch` API for edge runtimes.

```typescript
import { fetch } from 'expo/fetch';

// Works in Workers, Edge Functions, etc.
const response = await fetch('https://api.example.com/data');
const data = await response.json();
```

**Use case:** Building apps that also run as web workers or edge functions.

---

### 2. React Navigation v7

**What's New:**
Expo SDK 52 ships with React Navigation v7 by default.

**Breaking Changes:**
- Type safety improvements (may require updates)
- New `useNavigationContainerRef` hook
- Stricter TypeScript types

**Migration:**
```bash
npm install @react-navigation/native@^7.0.0
```

See: https://reactnavigation.org/docs/7.x/upgrading-from-6.x

---

### 3. React Native 0.77 Opt-in

**What's New:**
Can use React Native 0.77 (Swift iOS template, new CSS) by opting in.

```bash
# Install RN 0.77
npx expo install react-native@0.77

# Update dependencies
npx expo install --fix
```

**New in 0.77:**
- Swift iOS template (default for new projects)
- CSS properties: `display: contents`, `mixBlendMode`, `outline`
- Metro log forwarding removed

---

## Expo Go Limitations (SDK 52+)

| Feature | Expo Go | Custom Dev Client |
|---------|---------|-------------------|
| JSC Engine | ❌ No | ✅ Yes |
| Legacy Architecture | ❌ No | ✅ Yes (0.76-0.81) |
| Google Maps | ❌ No (SDK 53+) | ✅ Yes |
| Push Notifications | ⚠️ Limited | ✅ Full support |
| Custom Native Code | ❌ No | ✅ Yes |
| CodePush | ❌ No | ⚠️ Limited (New Arch issues) |

**Recommendation:** Use custom dev client for serious development.

---

## Migration from SDK 51 → SDK 52

### Step 1: Update Expo CLI

```bash
npm install -g expo-cli@latest
npx expo-doctor  # Check for issues
```

### Step 2: Update Dependencies

```bash
# Update to SDK 52
npm install expo@~52.0.0

# Update all Expo packages
npx expo install --fix

# Update React Native (if needed)
npx expo install react-native@latest
```

### Step 3: Update app.json

```json
{
  "expo": {
    "sdkVersion": "52.0.0",
    "jsEngine": "hermes",  // Remove "jsc" if present
    "newArchEnabled": true  // Required for Expo Go
  }
}
```

### Step 4: Check Library Compatibility

```bash
# Check for New Architecture compatibility
# Search: "[library] new architecture"

# Common replacements:
npm uninstall redux redux-thunk
npm install @reduxjs/toolkit

npm uninstall i18n-js
npm install react-i18next i18next
```

### Step 5: Test in Expo Go

```bash
npx expo start

# Press 'i' for iOS
# Press 'a' for Android
```

**If you get errors:**
- Check library compatibility
- Consider using custom dev client

### Step 6: (Optional) Switch to Custom Dev Client

If you need features not in Expo Go:

```bash
npx expo install expo-dev-client
npx expo prebuild
npm run ios
npm run android
```

---

## Common Migration Errors

### Error: "JSC not supported"

**Message:**
```
JavaScript engine 'jsc' is not supported in Expo Go
```

**Fix:**
Remove `jsEngine` from app.json or set to "hermes":

```json
{
  "expo": {
    "jsEngine": "hermes"
  }
}
```

---

### Error: "Library requires legacy architecture"

**Message:**
```
This library is not compatible with the New Architecture
```

**Fix:**

**Option A:** Update library:
```bash
npm update <library>@latest
```

**Option B:** Use custom dev client (supports interop in RN 0.76-0.81):
```bash
npx expo install expo-dev-client
npm run ios
```

**Option C:** Find alternative library that supports New Architecture

---

### Error: "Google Maps not found"

**Message:**
```
react-native-maps: Google Maps not available in Expo Go (SDK 53+)
```

**Fix:**
Use custom dev client:

```bash
npx expo install expo-dev-client react-native-maps
npx expo prebuild

# Add API key to app.json (see above)
npm run android
```

---

## Recommended Setup (SDK 52)

For best experience, use this configuration:

```json
// app.json
{
  "expo": {
    "sdkVersion": "52.0.0",
    "jsEngine": "hermes",
    "newArchEnabled": true,
    "plugins": [
      "expo-router"  // Recommended for navigation
    ],
    "android": {
      "minSdkVersion": 21,
      "targetSdkVersion": 35  // Android 15
    },
    "ios": {
      "minimumOsVersion": "13.4",
      "requireFullScreen": false
    }
  }
}
```

```json
// package.json (recommended versions)
{
  "dependencies": {
    "expo": "~52.0.0",
    "react": "^19.1.0",
    "react-native": "^0.76.0",
    "@react-navigation/native": "^7.0.0",
    "@reduxjs/toolkit": "^2.0.0",
    "react-i18next": "^15.0.0"
  }
}
```

---

## Resources

- **Expo SDK 52 Changelog**: https://expo.dev/changelog/2024/11-12-sdk-52
- **Expo Go Limitations**: https://docs.expo.dev/workflow/expo-go/
- **Custom Dev Client**: https://docs.expo.dev/develop/development-builds/introduction/
- **New Architecture**: https://reactnative.dev/docs/new-architecture-intro
- **React Navigation v7**: https://reactnavigation.org/docs/7.x/getting-started

---

**Bottom Line:** Expo SDK 52+ requires Hermes and New Architecture in Expo Go. For full control (JSC, legacy libraries, custom native code), use a custom development build with `expo-dev-client`.
