---
name: Reading List Manager
slug: reading-list-manager
description: Track books, articles, and reading progress with curation and note-taking
category: personal
complexity: simple
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "add to reading list"
  - "track my reading"
  - "reading list"
  - "book notes"
  - "what should I read"
tags:
  - productivity
  - reading
  - learning
  - knowledge-management
  - tracking
---

# Reading List Manager

The Reading List Manager skill helps you curate, track, and extract value from your reading across books, articles, essays, and research papers. Rather than letting reading materials pile up in browser tabs and forgotten bookmarks, this skill provides a structured system for managing your reading pipeline and capturing key insights.

This skill applies principles from "How to Read a Book" by Mortimer Adler, Zettelkasten note-taking methods, and spaced repetition learning to help you not just read more, but retain and apply what you read. It helps you prioritize what to read next, track progress, capture highlights, and synthesize insights across multiple sources.

The system distinguishes between different reading types—deep reading for understanding, scanning for information, and recreational reading for pleasure—and provides appropriate tracking and note-taking frameworks for each.

## Core Workflows

### Workflow 1: Add to Reading List
Capture new reading materials:
1. **Source Capture**: Title, author, type (book/article/paper)
2. **Context Recording**: Why you want to read this, who recommended it
3. **Priority Assessment**: How urgent/important is this?
4. **Category Tagging**: Topic area, reading type
5. **Time Estimation**: Approximate reading time
6. **List Placement**: Add to appropriate queue

### Workflow 2: Choose Next Read
Smart reading queue management:
1. **Context Check**: What do you have time for?
2. **Priority Review**: What's most urgent or relevant?
3. **Variety Balance**: Mix deep/light, fiction/non-fiction
4. **Goal Alignment**: What serves your current learning goals?
5. **Recommendation**: Suggests specific next read with rationale

### Workflow 3: Reading Progress Tracking
Monitor ongoing reading:
1. **Check-In**: Update page/chapter/percentage complete
2. **Time Logging**: How long are you spending?
3. **Difficulty Assessment**: Is this easier/harder than expected?
4. **Retention Check**: Can you summarize what you've read so far?
5. **Adjust Pace**: Speed up, slow down, or abandon?

### Workflow 4: Reading Notes & Highlights
Capture key insights:
1. **Highlight Capture**: Note key quotes or passages
2. **Personal Reflection**: Why does this matter to you?
3. **Connection Making**: How does this relate to other reading?
4. **Action Items**: What will you do with this information?
5. **Synthesis**: Main takeaways in your own words

### Workflow 5: Reading Review
Consolidate learning after finishing:
1. **Summary**: Main ideas in 3-5 bullet points
2. **Best Insights**: Top 3 takeaways
3. **Actionable Ideas**: What will you implement?
4. **Connections**: Related books, concepts, or experiences
5. **Recommendation**: Would you recommend? To whom?
6. **Rating**: How valuable was this?

## Reading Frameworks

### The Reading Pipeline

**QUEUE**
New additions, not yet started
- Prioritized by urgency/relevance
- Categorized by type and topic

**IN PROGRESS**
Currently reading
- Limit work-in-progress (3-5 books max)
- Mix of deep and light reading
- Active note-taking

**COMPLETED**
Finished with notes captured
- Summary and key takeaways recorded
- Insights extracted and filed
- Recommended or archived

**ABANDONED**
Started but not worth finishing
- Brief note on why abandoned
- No guilt—life's too short for bad books

### Reading Types & Approaches

**Deep Reading** (Books, long-form)
- Read for comprehension and retention
- Active note-taking
- Multiple passes if needed
- Time required: Hours to weeks

**Scanning** (Articles, reports)
- Read for specific information
- Skim for relevant sections
- Capture key facts or data
- Time required: 15-30 minutes

**Recreational** (Fiction, light non-fiction)
- Read for enjoyment
- Minimal note-taking
- Focus on experience, not extraction
- Time required: Hours to days

**Research** (Academic papers, technical docs)
- Read with specific question in mind
- Critical evaluation
- Detailed notes and citations
- Time required: 1-3 hours per paper

### Progressive Summarization Method

**Layer 1: Capture**
Highlight passages as you read

**Layer 2: Bold**
Bold the most important parts of highlights

**Layer 3: Summarize**
Write key ideas in your own words

**Layer 4: Remix**
Connect ideas across sources into original thinking

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Add new reading | "add to reading list" |
| Get recommendation | "what should I read next" |
| Update progress | "reading progress update" |
| Capture notes | "reading notes for [title]" |
| Review finished book | "review [title]" |
| View reading list | "show my reading list" |
| Search reading history | "find books about [topic]" |
| Reading stats | "reading statistics" |

## Reading Categories

### Professional Development
- Business & management
- Technical skills
- Industry trends
- Leadership
- Communication

### Personal Growth
- Psychology
- Philosophy
- Health & wellness
- Productivity
- Relationships

### Creative & Arts
- Fiction
- Poetry
- Design
- Writing craft
- Creative thinking

### Science & Technology
- Popular science
- Research papers
- Technology trends
- Innovation

### History & Current Events
- Biography
- Historical analysis
- Journalism
- Cultural commentary

## Tracking Templates

### Reading List Entry Template
```
TITLE: [Book/Article Title]
AUTHOR: [Author Name]
TYPE: [ ] Book [ ] Article [ ] Paper [ ] Essay
STATUS: [ ] Queue [ ] In Progress [ ] Completed [ ] Abandoned

ADDED: [Date]
SOURCE: [Where you found this / Who recommended]
WHY: [Why you want to read this]

PRIORITY: [ ] High [ ] Medium [ ] Low
ESTIMATED TIME: [Hours or pages]
CATEGORY: [Topic/Genre]
TAGS: [Keywords for searching]

STARTED: [Date]
COMPLETED: [Date]
ACTUAL TIME: [How long it took]

RATING: [1-5 stars]
WOULD RECOMMEND: [ ] Yes [ ] No [ ] Maybe
```

### Reading Notes Template
```
TITLE: [Book Title]
AUTHOR: [Author]
COMPLETED: [Date]

MAIN THESIS:
[Core argument or purpose of the book in 1-2 sentences]

KEY TAKEAWAYS:
1. [First major insight]
2. [Second major insight]
3. [Third major insight]

FAVORITE QUOTES:
- "[Quote 1]" (Page X)
- "[Quote 2]" (Page Y)

ACTIONABLE IDEAS:
- [ ] [Something to do/try/implement]
- [ ] [Another action item]

CONNECTIONS:
Related to: [Other books, concepts, experiences]
Contradicts: [If applicable]
Expands on: [If applicable]

PERSONAL REFLECTION:
[How this changed your thinking, what surprised you, what you disagree with]

RECOMMENDATION:
Best for: [Type of reader who would benefit]
Skip if: [Who might not find value]
```

### Quick Article Capture Template
```
TITLE: [Article Title]
SOURCE: [Publication/Website]
URL: [Link]
READ: [Date]

KEY INSIGHT: [Main point in one sentence]

USEFUL FACTS/DATA:
-
-

ACTION ITEMS:
-

SAVED FOR: [Why you saved this—project, interest area, etc.]
```

### Weekly Reading Review
```
WEEK OF: [Date Range]

BOOKS IN PROGRESS:
- [Title 1] - [% complete]
- [Title 2] - [% complete]

ARTICLES READ: [Number]
Best article: [Title and why]

TOTAL READING TIME: [Hours]

BEST INSIGHT THIS WEEK:
[What idea or concept stood out most]

COMPLETED:
- [Title] - [Rating]

ADDED TO LIST:
- [New additions]

NEXT WEEK'S READING GOAL:
[What you plan to read or finish]
```

## Best Practices

- **Curate ruthlessly** - Not everything deserves your time
- **Abandon freely** - If it's not valuable after 50 pages, move on
- **Read with purpose** - Know why you're reading before you start
- **Take notes in your own words** - Summarizing aids retention
- **Review highlights regularly** - Spaced repetition solidifies learning
- **Connect ideas across books** - The value is in the synthesis
- **Vary your reading** - Mix heavy and light, old and new
- **Schedule reading time** - It won't happen without dedicated blocks
- **Track completion** - Finishing builds momentum
- **Share insights** - Teaching others deepens your understanding
- **Limit work-in-progress** - Focus beats fragmentation
- **Use the right medium** - Physical books for deep reading, digital for scanning
- **Read before bed** - Better than screens for sleep
- **Follow your curiosity** - Reading should feel engaging, not obligatory
- **Build a reading habit** - Small daily reading beats sporadic binges

## Reading Strategies

### The Skimming Strategy
When to use: Articles, reports, books you're unsure about

1. Read title, subtitle, intro, conclusion
2. Scan headings and subheadings
3. Read first/last sentence of paragraphs
4. Look for bolded terms, lists, summaries
5. Decide: deep read, light read, or skip?

### The Deep Reading Strategy
When to use: Important books, complex ideas

1. **Pre-read**: Scan structure, read intro/conclusion
2. **Read actively**: Highlight, annotate, question
3. **Pause and reflect**: Stop every chapter to summarize
4. **Review highlights**: Second pass to consolidate
5. **Synthesize**: Write summary in your own words
6. **Apply**: Use insights in real work/life

### The Research Reading Strategy
When to use: Academic papers, technical documentation

1. **Question first**: What do you need to know?
2. **Abstract/Summary**: Does this answer your question?
3. **Scan methodology**: Is approach sound?
4. **Results/Conclusion**: What did they find?
5. **Skim details**: Read relevant sections thoroughly
6. **Cite and file**: Save with proper attribution

### The Fiction Reading Strategy
When to use: Novels, narrative non-fiction

1. **Immerse fully**: Minimize distractions
2. **Don't force notes**: Mark favorite passages if you want
3. **Reflect after**: What moved you? What did you notice?
4. **Discuss**: Talk with others who've read it
5. **Let it marinate**: Insights emerge over time

## Integration Points

This skill works well with:
- **Learning Path Creator**: Align reading with learning goals
- **Goal Setter**: Track reading-related goals
- **Journal Prompter**: Reflect on reading insights
- **Idea Capturer**: Capture ideas sparked by reading
- **Decision Helper**: Use reading insights for decision-making

## Example Reading List Session

**User**: "add to reading list"

**Skill Response**:
"Let's add that to your reading queue. A few details will help us prioritize and track it.

**What are you adding?**
- Book title & author?
- Article title & publication?
- Research paper?
- Essay or blog post?

Give me the title and type."

**User**: "Atomic Habits by James Clear, book"

**Skill Response**:
"Excellent choice—Atomic Habits is a highly actionable book on behavior change.

**A few more questions to properly queue this:**

1. **Why are you reading this?** (Helps with prioritization)
   - Recommended by someone?
   - Relevant to current project/goal?
   - General interest?

2. **How urgent is it?**
   - Need it soon for something specific?
   - On your list for when you have time?

3. **What format?**
   - Physical book, ebook, audiobook?
   (This affects when/where you can read it)

Take your time—good metadata makes your reading list actually useful."

**User**: "Recommended by my manager, want to improve my habits, have physical copy, not urgent but want to start soon"

**Skill Response**:
"Perfect. Here's what I'm adding:

**TITLE**: Atomic Habits
**AUTHOR**: James Clear
**TYPE**: Book (Physical)
**PRIORITY**: Medium (want to start soon)
**WHY**: Manager recommendation, habit improvement
**ESTIMATED TIME**: ~6-8 hours (it's ~320 pages, very readable)
**CATEGORY**: Personal Development / Productivity

**SUGGESTED READING APPROACH**:
This is a highly practical book—I'd recommend:
- Read with a notebook handy
- Identify 1-2 habits to work on as you read
- Apply concepts immediately rather than waiting to finish
- Reading time: 30-45 min sessions work well

**ADD TO QUEUE?** [Yes/No]

Want me to suggest when to start this based on your current reading progress?"
