---
name: referral
description: Referral systems - referral programs, viral loops. Use for referrals.
---

# Referral Guideline

## Tech Stack

* **Analytics**: PostHog
* **Database**: Neon (Postgres)
* **ORM**: Drizzle

## Non-Negotiables

* Referral attribution must be accurate and auditable
* Rewards must be fraud-resistant (no self-referral, duplicate abuse)
* Terms must be clear and enforced consistently

## Context

Referrals turn happy users into growth engines. But poorly designed referral programs create fraud opportunities and erode trust. The best referral programs feel generous, not gameable.

## Driving Questions

* What would make users genuinely want to refer others?
* How do we prevent referral fraud without punishing legitimate users?
* Is referral attribution working correctly across all channels?
* What's the referral conversion rate and what affects it?
* Are referral rewards actually motivating behavior?
