# Feedback Examples

This document provides examples of appropriate feedback tone and style. All feedback must be written in Swedish using "du/din" (you/your) to address the student directly.

## Fundamental Rule

**All feedback must be framed positively.** Never use negative critique. Never mention what's missing, lacking, or could be improved. Focus only on what the student actually did.

The feedback should feel like something you'd **actually say to the student face-to-face**. If it sounds like a template or bureaucratic report, rewrite it until it sounds like a real person talking.

## Core Principles

### DO
- Speak like a teacher talking face-to-face
- Be warm, encouraging, and genuine
- Use natural conversational Swedish
- Be specific about what impressed you
- Use exclamation marks for enthusiasm
- Start with strengths

### DON'T
- Use bureaucratic or stiff language
- Sound like a template
- Use formal academic phrases
- Be generic or vague
- Focus on weaknesses
- Use third-person references
- Use superlatives like "imponerande" (impressive) - too much praise
- Use unnecessary capital letters (only for abbreviations like NSG, VNet, SSH)
- Tell students what they need to do to get a different grade
- Use "men" statements ("men beskrivningen...", "men endast") - no "but" clauses
- Use contrast words like "dock", "emellertid", "å andra sidan"
- Use "saknar", "saknas" or describe what's missing/lacking
- Describe what the student DIDN'T do - focus ONLY on what they DID

## Distinction (VG) Examples

### Example 1: Strong Security Focus
> "Riktigt snyggt jobbat med C4-modellen och verifieringstesterna - särskilt bra att du testade både vad som fungerar och vad som blockeras. Din riskmatris är genomtänkt och visar att du förstår helheten. Roligt att läsa en rapport med personlig touch som ändå håller tekniskt!"

### Example 2: Excellent Documentation
> "Vilken genomarbetad rapport! Du har verkligen förstått hur alla delar hänger ihop och förklarar det på ett sätt som är lätt att följa. Säkerhetsdelen är extra stark med bra motiveringar till varje NSG-regel."

### Example 3: Thorough Testing
> "Kul att se så noggranna tester av hela flödet - från formulär till databas och tillbaka. Din dokumentation av säkerhetskonfigurationen är riktigt bra och visar att du tänkt igenom attackvektorer. Bra jobbat!"

### Example 4: Automation Excellence
> "Snyggt hur du automatiserat deployment med scripts och cloud-init - det gör lösningen reproducerbar och professionell. Säkerhetsavsnittet är välmotiverat med tydliga förklaringar till varje val. Kul att se ett så genomtänkt upplägg!"

## Pass (G) Examples - Solid Work

### Example 1: Complete Solution
> "Bra jobbat! Du har fått ihop alla delar och visar tydligt hur allt hänger ihop med bra skärmbilder. Speciellt kul att se hur du verifierade att formuläret sparar data hela vägen till databasen."

### Example 2: Good Foundation
> "Fin rapport som visar en fungerande lösning! Arkitekturen är tydligt beskriven och skärmbilderna bekräftar att systemet fungerar. Bra jobbat med att få ihop helheten!"

### Example 3: Clear Explanation
> "Du förklarar flödet på ett begripligt sätt och det är tydligt att du förstår hur komponenterna samarbetar. Skärmbilderna visar att allt fungerar som det ska. Bra jobbat med att få ihop allt!"

## Pass (G) Examples - Minimum Level

### Example 1: Basic Requirements Met
> "Du har fått med det som behövs och visar en fungerande lösning. Skärmbilderna bekräftar att systemet fungerar som det ska. Bra jobbat!"

### Example 2: Functional Demonstration
> "Bra att du visar att alla delar fungerar med skärmbilder. Rapporten täcker de viktigaste punkterna och visar att du fått systemet att fungera. Tydligt och strukturerat!"

### Example 3: Honest Effort
> "Du har lagt ner jobb på att få systemet att fungera och det syns i rapporten. Grunderna är på plats med fungerande formulär och databas. Bra jobbat!"

## Phrases to USE

| Swedish | Context |
|---------|---------|
| "Riktigt snyggt!" | Outstanding work |
| "Bra jobbat!" | Good work overall |
| "Kul att se..." | Something that stood out |
| "Snyggt hur du..." | Particularly strong element |
| "Vilken genomarbetad..." | Thorough work |
| "Du förklarar på ett begripligt sätt" | Clear explanation |
| "Det är tydligt att du förstår..." | Shows understanding |
| "Fin rapport!" | General positive acknowledgment |

## Phrases to AVOID

| Avoid | Why | Better Alternative |
|-------|-----|-------------------|
| "visar på mogen förståelse" | Too formal/academic | "visar att du förstår" |
| "den tekniska substansen är solid" | Bureaucratic | "tekniken sitter" |
| "uppfyller kraven väl" | Template-like | "du har fått med det som behövs" |
| "rapporten demonstrerar" | Third-person | "du visar" |
| "det kan konstateras att" | Formal Swedish | Drop it entirely |
| "således" | Old-fashioned formal | Skip |
| "imponerande" / "imponerad" | Too much praise | "snyggt", "kul att se" |
| "För VG hade det behövts..." | Tells what to do for other grade | Skip - focus on what they did |
| "Nästa steg vore att..." | Implies incomplete work | Skip - acknowledge what's there |
| Unnecessary CAPITALS | Looks like shouting | Only use for abbreviations (NSG, SSH) |
| "men beskrivningen..." | Creates negative contrast | Skip the "but" clause entirely |
| "dock", "emellertid" | Formal contrast words | Skip - don't contrast |
| "saknar", "saknas" | Describes what's missing | Focus on what IS there |
| "VG kräver...", "VG-nivå" | Mentions other grades | Never mention VG in feedback |

## Sentence Structure

### Sentence 1: Strength
What did the student do well? Be specific.

❌ "Du har skrivit en bra rapport."
✓ "Riktigt snyggt jobbat med säkerhetsverifieringen - du testade både vad som tillåts och vad som blockeras."

### Sentence 2: Achievement
What stood out? What was particularly impressive?

❌ "Rapporten visar god förståelse."
✓ "Din C4-modell är tydlig och visar hur alla komponenter hänger ihop."

### Sentence 3: Recognition
Warm closing that acknowledges effort.

❌ "Sammantaget uppfyller rapporten kraven för VG."
✓ "Roligt att läsa en rapport med personlig touch som ändå håller tekniskt!"

## Grade-Specific Guidance

### VG Feedback Should:
- Mention specific technical achievements
- Reference security depth or automation
- Show genuine enthusiasm
- Acknowledge going beyond requirements

### G Feedback Should:
- Acknowledge completed work
- Be encouraging and positive
- Focus on what the student actually did well
- **Never** mention what would be needed for VG
- **Never** suggest "next steps" or improvements
- Avoid sounding like "almost VG" or "not quite there"

## Testing Your Feedback

Ask yourself:
1. Would I say this to a student face-to-face?
2. Does it mention something specific from THIS report?
3. Does it sound genuine, not templated?
4. Is it in natural Swedish?
5. Does it use "du/din"?

If any answer is "no", revise the feedback.
