---
name: Report Generation
description: This skill should be used when the user asks to "generate a report", "compile report", "create final report", "export to PDF", "make a PDF report", "combine all documents", "create deliverable", or wants to compile planning outputs into a professional document. Handles IEEE citations, table of contents, cover pages, and multi-format export (PDF/DOCX/Markdown).
version: 1.0.0
---

# Report Generation

Compile project planning outputs into professional, well-formatted reports with optional IEEE-style citations, AI-generated visuals, and multiple output formats.

## Overview

This skill transforms the markdown files generated by project planning skills into cohesive, professionally formatted deliverables. It supports:

- **Multi-format output**: PDF (via Pandoc/LaTeX), Word (.docx), compiled Markdown
- **IEEE citations**: Square bracket `[1]` inline citations with numbered reference list
- **Professional formatting**: Cover page, table of contents, section numbering
- **Interactive selection**: User chooses which sections to include
- **AI-generated visuals**: Cover images and diagrams via Gemini 3 Pro (Nano Banana)

## Workflow

### Step 1: Locate Planning Outputs

Identify the project's planning output folder. Look for:

```
planning_outputs/
└── YYYYMMDD_HHMMSS_<project_name>/
```

If multiple folders exist, present the most recent or ask user to specify.

### Step 2: Scan Available Content

Read the folder structure to identify available sections:

| Folder | Content Type | Default Include |
|--------|--------------|-----------------|
| `SUMMARY.md` | Executive summary | Yes |
| `specifications/` | Project & technical specs | Yes |
| `research/` | Market & technology research | Yes |
| `analysis/` | Feasibility, costs, risks | Yes |
| `components/` | Building blocks (YAML) | Yes |
| `planning/` | Sprint plans, timeline | Yes |
| `diagrams/` | Architecture diagrams | Yes |
| `marketing/` | Campaign plans, calendars | If exists |

Also check for citation files: `*.citations.json` sidecar files alongside markdown.

### Step 3: Present Interactive Menu

Use `AskUserQuestion` to gather user preferences. Present questions based on what content exists:

**Question 1: Content Selection** (multiSelect: true)
```
"Which sections should be included in the report?"
Options (based on what exists):
- Research & Market Analysis (research/, specifications/)
- Architecture & Components (components/, diagrams/)
- Planning & Analysis (planning/, analysis/)
- Marketing & Go-to-Market (marketing/)
```
User can also provide custom input via "Other" to exclude specific files, add external content, or specify ordering preferences.

**Question 2: Citations** (multiSelect: false)
```
"Include citations and references?"
- Yes - IEEE style [1] citations with numbered reference list (Recommended if research content included)
- No - Plain report without citations
```

**Question 3: Output Format** (multiSelect: false)
```
"Output format?"
- PDF (Recommended) - Professional formatting via LaTeX
- Word Document (.docx) - Editable format
- Markdown - Single compiled .md file
```

### Step 4: Compile Report

Based on user selections, compile the report using `scripts/compile_report.py`:

```bash
python "${CLAUDE_PLUGIN_ROOT}/skills/report-generation/scripts/compile_report.py" \
  --input-dir "<planning_outputs_folder>" \
  --output "<output_file>" \
  --format pdf \
  --sections "research,architecture,planning,analysis" \
  --citations \
  --toc
```

#### Compilation Process

1. **Generate cover page** from `assets/cover_page.md` template
2. **Build table of contents** from section headings
3. **Merge markdown files** in logical order (see Section Ordering below)
4. **Process citations** (if enabled):
   - Read `*.citations.json` files
   - Assign IEEE numbers `[1]`, `[2]` in order of appearance
   - Generate references section
5. **Convert to output format** via Pandoc

### Step 5: Handle Custom Requests

If user provided custom input in "Other":

- **Exclude files**: Remove specified files from compilation
- **Add external content**: Include additional markdown files user points to
- **Custom ordering**: Adjust section order as requested
- **Special formatting**: Apply any formatting preferences

## Section Ordering

Default section order for compiled report:

1. **Cover Page** - Title, date, project name
2. **Table of Contents** - Auto-generated
3. **Executive Summary** - From `SUMMARY.md`
4. **Market Research** - `research/market_research.md`, `research/competitive_analysis.md`
5. **Technical Specifications** - `specifications/project_spec.md`, `specifications/technical_spec.md`
6. **Architecture** - `diagrams/`, architecture documents
7. **Components** - `components/building_blocks.yaml` (rendered as markdown)
8. **Implementation Plan** - `planning/sprint_plan.md`, `planning/timeline.md`
9. **Analysis** - `analysis/feasibility.md`, `analysis/cost_analysis.md`, `analysis/risk_assessment.md`
10. **Marketing** - `marketing/` (if included)
11. **References** - IEEE numbered list (if citations enabled)

## IEEE Citation Format

When citations are enabled:

### Inline Citations
- Format: `[1]`, `[2]`, `[1, 2]`, `[1]-[3]`
- Numbered in order of first appearance
- Placed before punctuation: `text [1].`

### Reference List Entry Format
```
[1] Author, "Title," Source, Date. [Online]. Available: URL
```

Example:
```
[1] M. Smith, "Cloud Architecture Patterns," AWS Blog, 15-Mar.-2024.
    [Online]. Available: https://aws.amazon.com/blogs/architecture/patterns
```

### Citation Source Files

Citations are stored in sidecar JSON files alongside research markdown:

```
research/
├── market_research.md
├── market_research.citations.json    # Citation data
├── technology_research.md
└── technology_research.citations.json
```

JSON structure:
```json
{
  "citations": [
    {
      "id": "cite-1",
      "title": "Article Title",
      "author": "A. Smith",
      "url": "https://example.com",
      "date": "2024-03-15",
      "accessed": "2024-06-01"
    }
  ],
  "inline_refs": [
    {"text": "market growth [cite-1]", "line": 45}
  ]
}
```

## Visual Generation (Nano Banana Integration)

Generate professional visuals for reports using AI image generation (Gemini 3 Pro via OpenRouter).

### Cover Image Generation

Create cover images matching report style:

```bash
python "${CLAUDE_PLUGIN_ROOT}/../generate-image/scripts/generate_image.py" \
  "Professional report cover, modern tech aesthetic, abstract geometric patterns,
   blue gradients, clean minimalist design, corporate document style" \
  --output "<planning_folder>/diagrams/cover_image.png"
```

### Style Prompts

| Style | Prompt Elements |
|-------|-----------------|
| **Modern Tech** | "abstract geometric patterns, blue gradients, circuit elements, minimalist" |
| **Corporate** | "clean minimal, subtle gradient, executive style, muted blue/gray tones" |
| **Healthcare** | "medical imagery, DNA helix, health tech, clinical aesthetic" |
| **Finance** | "financial charts, secure vault imagery, fintech, data visualization" |
| **SaaS** | "cloud computing, dashboard interface, software visualization" |

### Diagram Generation

Generate technical diagrams based on project content:

```bash
# Architecture diagram
python generate_image.py "System architecture diagram for [project],
  showing [components], clean technical illustration, labeled boxes and arrows"

# Component diagram
python generate_image.py "Software component diagram showing [building_blocks],
  with connections and dependencies, UML-style, clean technical style"

# Data flow diagram
python generate_image.py "Data flow diagram showing data moving from
  [source] through [processing] to [destination], arrows indicating flow"
```

### Requirements

- `OPENROUTER_API_KEY` environment variable
- Uses `generate-image` skill's `scripts/generate_image.py`
- Default model: `google/gemini-3-pro-image-preview`

## Scripts Reference

### compile_report.py

Main compilation script. Merges markdown, processes citations, generates output.

```bash
python compile_report.py --help

Arguments:
  --input-dir DIR       Planning outputs folder
  --output FILE         Output file path
  --format FORMAT       pdf|docx|md (default: pdf)
  --sections LIST       Comma-separated sections to include
  --citations           Enable IEEE citation processing
  --no-toc              Disable table of contents
  --cover-title TITLE   Custom cover page title
  --template FILE       Custom Pandoc template
```

### citation_formatter.py

Processes citation JSON files and formats to IEEE style.

```bash
python citation_formatter.py --help

Arguments:
  --input-dir DIR       Directory with .citations.json files
  --output FILE         Output references.md file
  --style ieee          Citation style (only ieee supported)
```

## Assets Reference

| File | Purpose |
|------|---------|
| `assets/ieee.csl` | Pandoc CSL file for IEEE citation formatting |
| `assets/report_template.tex` | LaTeX template for professional PDF output |
| `assets/cover_page.md` | Cover page markdown template |

## Dependencies

**Required:**
- Python 3.10+
- Pandoc (for PDF/DOCX conversion)

**For PDF output:**
- LaTeX distribution (xelatex) - `brew install --cask mactex` or `apt install texlive-xetex`

**Check dependencies:**
```bash
python compile_report.py --check-deps
```

## Error Handling

| Error | Resolution |
|-------|------------|
| "Pandoc not found" | Install: `brew install pandoc` |
| "xelatex not found" | Install LaTeX: `brew install --cask mactex` |
| "No planning outputs found" | Specify folder path or run planning first |
| "No citations found" | Citations require research skills to have been run |

## Additional Resources

### Reference Files

- **`references/ieee_format.md`** - Detailed IEEE citation format rules and examples
- **`references/pandoc_options.md`** - Advanced Pandoc configuration options

### Example Output

See `references/example_report.md` for a sample compiled report structure.
