# 优先级功能需求澄清提示词

## 适用场景

用户提出"添加优先级"或类似需求时使用。

适用于：任务管理、工单系统、项目管理、邮件客户端等任何需要优先级管理的系统。

## 核心问题（3个）

### 问题 1：数据结构
**优先级分几个等级？**

**建议选项**：
- 简单场景：3级（高/中/低）
- 复杂场景：5级（紧急/高/中/低/无）
- 自定义：用户自己定义

**追问**：
- 默认优先级是什么？（新创建项目的默认值）
- 是否允许无优先级状态？

### 问题 2：UI 设计
**优先级如何在界面上展示？**

**选项**：
- [ ] 颜色标识（如：红=高，黄=中，灰=低）
- [ ] 图标（如：⚠️/⭐/📌）
- [ ] 文字标签
- [ ] 数字（1-5）
- [ ] 组合（颜色+图标）

**追问**：
- 展示位置？（列表项左侧/右侧/背景色）
- 是否需要优先级图例说明？

### 问题 3：功能范围
**需要哪些关联功能？**

**选项**：
- [ ] 按优先级排序
- [ ] 按优先级筛选
- [ ] 优先级快速切换（点击切换）
- [ ] 批量修改优先级
- [ ] 优先级变更历史
- [ ] 优先级到期提醒

## 常见陷阱

⚠️ **陷阱 1**：忘记考虑默认优先级
- 问题：导致大量"无优先级"的脏数据
- 解决：必须明确新项目的默认优先级

⚠️ **陷阱 2**：UI 过度设计
- 问题：颜色+图标+文字+数字，界面太乱
- 解决：选择1-2种展示方式即可

⚠️ **陷阱 3**：忘记数据迁移
- 问题：现有数据没有优先级字段
- 解决：必须考虑旧数据的迁移方案

⚠️ **陷阱 4**：忽略批量操作
- 问题：一个个改优先级很麻烦
- 解决：询问是否需要批量修改功能

## 输出模板

基于用户回答，生成需求概要：

```markdown
## 优先级功能需求

### 核心信息
- **等级数量**：[3级 / 5级 / 自定义]
- **等级定义**：[高/中/低] 或 [自定义]
- **默认值**：[medium / high / 用户选择]

### UI 设计
- **展示方式**：[颜色 / 图标 / 标签 / 组合]
- **颜色方案**：
  - 高优先级：#FF3B30（红色）
  - 中优先级：#FFCC00（黄色）
  - 低优先级：#8E8E93（灰色）
- **展示位置**：[左侧指示条 / 右侧标签 / 背景色]

### 功能范围
- [x] 优先级排序
- [x] 优先级筛选
- [ ] 快速切换
- [ ] 批量修改
- [ ] 变更历史
- [ ] 到期提醒

### 数据迁移
- 现有数据默认优先级：[medium]
- 迁移策略：[一次性迁移 / 渐进式迁移]

### 边界条件
- 是否允许无优先级：[否]
- 权限控制：[所有人可修改 / 仅创建者可修改]
```

## 相关资源

- 架构设计：→ 2-architecture/patterns/mvc.md
- UI 模式：→ 3-design/ui-patterns/list.md
- 代码实现：→ 4-development/code-patterns/state-management.md
- 检查清单：→ 5-review/checklists/requirement-checklist.md

## 成功案例

参考：1-requirement/examples/priority-case.md

---

**使用方法**：
```
使用 requirement-optimizer 帮我澄清需求：给任务列表加优先级
```
