# 搜索功能需求澄清提示词

## 适用场景

用户提出"添加搜索"或类似需求时使用。

适用于：任务管理、文档系统、电商平台、内容管理等任何需要查找功能的系统。

## 核心问题（3个）

### 问题 1：搜索范围
**搜索哪些字段/内容？**

**建议选项**：
- 标题搜索（最常见）
- 标题 + 内容搜索
- 标题 + 内容 + 标签搜索
- 全字段搜索（包括备注、创建人等）

**追问**：
- 是否区分大小写？
- 是否支持模糊搜索？（如：搜"任务"能匹配"任务管理"）
- 是否支持拼音搜索？（中文场景）

### 问题 2：搜索方式
**用户如何进行搜索？**

**选项**：
- [ ] 实时搜索（输入即搜索）
- [ ] 按钮触发（输入后点击搜索按钮）
- [ ] 快捷键触发（如 Ctrl+F）
- [ ] 组合方式

**追问**：
- 搜索框放在哪里？（顶部/侧边/悬浮）
- 搜索结果如何展示？（高亮/列表/弹窗）
- 是否需要搜索历史记录？

### 问题 3：高级功能
**是否需要高级搜索？**

**选项**：
- [ ] 多条件组合（标题+标签+日期范围）
- [ ] 搜索过滤器（按类型/状态筛选）
- [ ] 搜索排序（相关度/时间）
- [ ] 保存搜索条件
- [ ] 搜索建议/自动完成

**追问**：
- 搜索性能要求？（数据量大时如何优化）
- 是否需要搜索统计？（显示"找到 X 个结果"）

## 常见陷阱

⚠️ **陷阱 1**：搜索范围过大导致性能问题
- 问题：搜索全部字段，数据量大时很慢
- 解决：明确核心搜索字段，其他字段作为高级选项

⚠️ **陷阱 2**：实时搜索频繁触发
- 问题：每输入一个字就搜索，性能差
- 解决：添加防抖（debounce），输入停顿 300ms 后再搜索

⚠️ **陷阱 3**：忘记空结果处理
- 问题：搜索无结果时界面空白
- 解决：提供友好提示 + 搜索建议

⚠️ **陷阱 4**：搜索结果没有上下文
- 问题：只显示标题，用户不知道匹配的是什么
- 解决：高亮匹配文本 + 显示上下文片段

## 输出模板

基于用户回答，生成需求概要：

```markdown
## 搜索功能需求

### 核心信息
- **搜索范围**：[标题 / 标题+内容 / 全字段]
- **匹配方式**：[精确匹配 / 模糊匹配 / 正则]
- **大小写**：[区分 / 不区分]

### UI 设计
- **搜索框位置**：[顶部导航栏 / 页面顶部 / 悬浮搜索]
- **触发方式**：[实时搜索 / 按钮 / 快捷键 Ctrl+F]
- **结果展示**：
  - 高亮匹配文本
  - 显示上下文片段（前后各 20 字）
  - 结果计数："找到 X 个结果"
- **空结果处理**：[提示语 + 搜索建议]

### 功能范围
- [x] 基础搜索
- [ ] 搜索历史
- [ ] 高级筛选（日期/标签/状态）
- [ ] 搜索建议
- [ ] 保存搜索条件

### 性能优化
- 防抖延迟：[300ms]
- 最小搜索长度：[2个字符]
- 结果限制：[显示前 50 条]
- 索引策略：[前端/后端]

### 边界条件
- 特殊字符处理：[转义 / 忽略]
- 空格处理：[作为分隔符 / 精确匹配]
- 搜索权限：[所有人 / 仅限自己创建的内容]
```

## 技术建议

### 前端实现
```javascript
// 防抖搜索
const searchDebounced = debounce((keyword) => {
  if (keyword.length < 2) return; // 最少2个字符
  performSearch(keyword);
}, 300);

// 高亮匹配
function highlightMatch(text, keyword) {
  const regex = new RegExp(`(${keyword})`, 'gi');
  return text.replace(regex, '<mark>$1</mark>');
}
```

### 后端优化
- 使用全文索引（如 Elasticsearch）
- 数据库模糊查询优化（LIKE '%keyword%' 改为 LIKE 'keyword%'）
- 缓存热门搜索结果

## 相关资源

- 架构设计：→ 2-architecture/patterns/search-optimization.md
- UI 模式：→ 3-design/ui-patterns/search-input.md
- 代码实现：→ 4-development/code-patterns/debounce.md
- 检查清单：→ 5-review/checklists/requirement-checklist.md

## 成功案例

参考：1-requirement/examples/search-case.md

---

**使用方法**：
```
使用 requirement-optimizer 帮我澄清需求：添加搜索功能
```
