# 研究分析檢查清單 Checklists

## 研究倫理清單

### 必須遵守

- [ ] 獲得知情同意
- [ ] 保護受訪者隱私
- [ ] 如實呈現數據
- [ ] 標註資料來源
- [ ] 說明研究限制

### 避免

- 操縱數據以符合預期結論
- 選擇性呈現有利結果
- 未經同意使用個人資料
- 誇大研究發現的普適性

## 研究品質評估

### 質性研究品質標準

| 標準 | 說明 | 達成方法 |
|------|------|----------|
| **可信性** | 研究發現是否可信 | 三角驗證、成員查核 |
| **可轉移性** | 結果是否可應用於其他情境 | 厚描述、清楚脈絡 |
| **可靠性** | 過程是否可追溯、重現 | 詳細記錄、審計軌跡 |
| **可確認性** | 研究者偏見是否被控制 | 反思日誌、同儕檢核 |

### 量化研究品質標準

| 標準 | 說明 | 評估方式 |
|------|------|----------|
| **內部效度** | 因果關係是否成立 | 控制變項、隨機分配 |
| **外部效度** | 結果是否可推論 | 樣本代表性 |
| **信度** | 測量是否一致 | Cronbach's alpha |
| **構念效度** | 測量的是否是想測的 | 因素分析 |

## AI 輔助研究

### AI 在研究中的應用

| 階段 | AI 應用 | 工具 |
|------|---------|------|
| **文獻回顧** | 論文摘要、主題聚類 | Elicit, Semantic Scholar |
| **訪談分析** | 轉錄、編碼建議 | Otter.ai, Claude |
| **問卷分析** | 開放題分類 | Claude, GPT |
| **報告撰寫** | 初稿、摘要生成 | Claude, GPT |

### AI 使用原則

**Do's**
- 使用 AI 加速初步分析
- 讓 AI 提供編碼建議，人工確認
- 使用 AI 生成初稿，人工修改
- 標註 AI 輔助的部分

**Don'ts**
- 完全依賴 AI 做最終判斷
- 未經驗證直接採用 AI 分析結果
- 使用 AI 生成虛假數據
- 隱瞞 AI 在研究中的角色

## 研究前檢查清單

- [ ] 研究問題是否明確且可回答？
- [ ] 研究方法是否適合回答研究問題？
- [ ] 樣本大小是否足夠？
- [ ] 是否取得必要的倫理審查？
- [ ] 是否準備好資料收集工具？
- [ ] 時程是否合理？

## 研究後檢查清單

- [ ] 數據收集過程是否完整記錄？
- [ ] 分析方法是否正確應用？
- [ ] 研究限制是否誠實揭露？
- [ ] 結論是否基於數據支持？
- [ ] 建議是否具體可行？
- [ ] 報告是否清楚易讀？
