# 研究分析範例 Examples

## 假說驅動分析

### 假說公式

```
IF [我們做 X 行動]
THEN [會產生 Y 結果]
BECAUSE [基於 Z 理由/數據]
```

### 假說範例

```
IF 我們縮短結帳流程到 3 步
THEN 購物車轉換率會提升 20%
BECAUSE 目前 60% 的棄單發生在步驟 4-5
```

### 假說驗證流程

1. **建立假說** - 基於初步觀察提出可驗證的假說
2. **設計驗證方法** - 決定需要什麼數據、如何收集
3. **收集證據** - 收集支持或反駁假說的數據
4. **分析結果** - 證據是否支持假說？
5. **修正或確認**
   - 假說成立 → 進入建議階段
   - 假說不成立 → 修正假說，重複驗證

## 三角驗證範例

### 定義

使用多種數據來源或方法驗證同一結論，提高研究可信度

### 三角驗證類型

| 類型 | 說明 | 範例 |
|------|------|------|
| **數據三角** | 多種數據來源 | 訪談 + 問卷 + 行為數據 |
| **方法三角** | 多種研究方法 | 質性 + 量化 |
| **研究者三角** | 多人獨立分析 | 兩位分析師編碼 |
| **理論三角** | 多種理論框架 | 行為經濟學 + 心理學 |

### 應用範例

研究發現：「用戶不使用搜尋功能」

- 驗證 1 (行為數據): 只有 5% 用戶使用搜尋
- 驗證 2 (訪談): 用戶表示「不知道有搜尋」
- 驗證 3 (眼動追蹤): 搜尋框無人注視

→ 三角驗證支持：搜尋功能可見度不足

## 問卷設計詳細指南

### 問卷結構原則

**結構安排：**
1. 開頭：簡單、有趣的問題（建立信任）
2. 中間：核心問題（最重要的調查內容）
3. 結尾：人口統計學問題（敏感性較低）

**問題設計原則：**
- 一題只問一件事
- 避免引導性問題
- 提供「不適用/無意見」選項
- 保持選項互斥且窮盡

**長度控制：**
- 5-10 分鐘最佳（約 15-25 題）
- 超過 15 分鐘，完成率顯著下降

### 問題類型選擇

| 類型 | 適用場景 | 範例 |
|------|----------|------|
| **單選** | 互斥選項 | 性別、年齡範圍 |
| **多選** | 可複選 | 使用過的功能 |
| **量表** | 態度/滿意度 | 1-5 分滿意度 |
| **矩陣** | 多項目同量表 | 多功能評分 |
| **開放式** | 深入了解 | 改進建議 |
| **排序** | 優先級 | 功能重要性排序 |

### 常見問卷錯誤

| 錯誤 | 範例 | 改進 |
|------|------|------|
| **雙重問題** | 您對價格和品質滿意嗎？ | 分成兩題 |
| **引導性** | 您同意這是最好的選擇嗎？ | 您對這個選擇的看法？ |
| **假設前提** | 您每天使用幾次？ | 先問是否使用 |
| **選項不全** | 年齡：18-25, 26-35 | 加上 <18, 35+ |
| **專業術語** | 您的 NPS 分數？ | 用白話解釋 |

## 數據視覺化指南

### 根據目的選擇圖表

**比較**
- 類別比較 → 長條圖
- 時間比較 → 折線圖
- 佔比比較 → 堆疊長條圖

**分布**
- 單變數分布 → 直方圖、盒鬚圖
- 雙變數關係 → 散點圖
- 多變數關係 → 熱力圖

**組成**
- 佔比組成 → 圓餅圖（< 6 類）、樹狀圖
- 時間組成變化 → 面積圖

**趨勢**
- 時間趨勢 → 折線圖
- 多指標趨勢 → 多軸折線圖

### 視覺化原則

**Do:**
- 標題說明圖表要傳達的訊息
- Y 軸從 0 開始（除非有正當理由）
- 使用一致的顏色編碼
- 標註數據來源和時間範圍
- 移除不必要的裝飾（3D、漸層）

**Don't:**
- 截斷 Y 軸誇大差異
- 使用太多顏色（超過 6 種）
- 圓餅圖超過 6 個類別
- 使用 3D 效果扭曲比例
- 忽略圖例和標籤
