---
schema: "1.0"
name: research-analysis
version: "1.0.0"
description: 研究分析：文獻回顧、競品分析、市場調研、數據分析方法論
domain: professional
triggers:
  keywords:
    primary: [研究, research, 分析, analysis, 調研, 文獻回顧, literature review, 競品分析, competitor analysis, 市場調查]
    secondary: [報告, report, 調查, survey, 洞察, insight, 問卷, questionnaire, 訪談, interview, 數據分析, data analysis]
  context_boost: [方法論, methodology, 質性, quantitative, 量化, qualitative, 框架, framework]
  context_penalty: [code, 程式, api, frontend, backend]
  priority: high
dependencies:
  software-skills: [documentation]
author: claude-domain-skills
---

# 研究分析 Research Analysis

> 系統化的研究方法與分析框架

## 適用場景

- 市場調研與競品分析
- 文獻回顧與研究綜述
- 用戶研究與需求分析
- 數據分析與洞察報告

## 研究流程框架

```
1. 定義問題 → 2. 資料收集 → 3. 分析整理 → 4. 洞察提煉 → 5. 建議行動
```

| 階段 | 關鍵活動 |
|------|----------|
| **定義** | 研究目的、關鍵問題、成功標準 |
| **收集** | 一手資料（訪談、問卷）、二手資料（文獻、數據庫） |
| **分析** | 定性（編碼、主題歸納）、定量（統計、視覺化） |
| **提煉** | 關鍵發現、模式識別、因果推論 |
| **建議** | 策略建議、行動方案、風險評估 |

## 競品分析框架

### 分析維度

| 維度 | 分析要點 |
|------|----------|
| **產品功能** | 核心功能、差異化特點、功能完整度 |
| **用戶體驗** | 介面設計、使用流程、學習曲線 |
| **商業模式** | 定價策略、收入來源、獲客方式 |
| **市場定位** | 目標客群、價值主張、品牌形象 |
| **技術架構** | 技術棧、擴展性、安全性 |

### 競品矩陣模板

```markdown
| 維度 | 我們 | 競品A | 競品B | 競品C |
|------|------|-------|-------|-------|
| 核心功能 | ★★★ | ★★★★ | ★★ | ★★★ |
| 定價 | $99 | $149 | $49 | $79 |
| 目標客群 | SMB | Enterprise | Startup | SMB |
| 差異化 | 簡單易用 | 功能完整 | 價格低 | 整合多 |
```

## 市場調研方法

### 定性研究

| 方法 | 適用場景 | 樣本量 |
|------|----------|--------|
| **深度訪談** | 探索動機、理解脈絡 | 8-15 人 |
| **焦點小組** | 收集多元觀點、激發討論 | 6-10 人/組 |
| **觀察法** | 了解實際行為、發現痛點 | 視情況 |
| **日誌研究** | 追蹤長期行為變化 | 10-20 人 |

### 定量研究

| 方法 | 適用場景 | 樣本量 |
|------|----------|--------|
| **問卷調查** | 驗證假設、量化趨勢 | 100+ |
| **A/B 測試** | 比較方案效果 | 視流量 |
| **數據分析** | 發現模式、預測趨勢 | 大數據 |

## 常見分析框架

| 框架 | 用途 | 適用場景 |
|------|------|----------|
| **SWOT** | 優劣勢機會威脅 | 策略規劃 |
| **PEST** | 政經社技環境 | 宏觀分析 |
| **Porter's 5 Forces** | 產業競爭力 | 產業分析 |
| **Jobs-to-be-Done** | 用戶任務動機 | 產品創新 |
| **Affinity Diagram** | 歸納整理資訊 | 質性分析 |

## 假說驅動分析

### 假說公式

```
IF [做 X 行動] → THEN [產生 Y 結果] → BECAUSE [基於 Z 理由]
```

### 驗證流程

1. **建立假說** - 基於觀察提出可驗證假說
2. **設計驗證** - 決定數據需求與收集方式
3. **收集證據** - 收集支持或反駁的數據
4. **分析結果** - 判斷證據是否支持假說
5. **修正確認** - 成立則進入建議，否則修正重驗

## 三角驗證法

使用多種來源驗證同一結論，提高可信度：

| 類型 | 說明 | 範例 |
|------|------|------|
| **數據三角** | 多種數據來源 | 訪談 + 問卷 + 行為數據 |
| **方法三角** | 多種研究方法 | 質性 + 量化 |
| **研究者三角** | 多人獨立分析 | 兩位分析師編碼 |

## 問卷設計要點

**結構**：開頭簡單問題 → 中間核心問題 → 結尾人口統計

**原則**：
- 一題只問一件事
- 避免引導性問題
- 提供「不適用」選項
- 5-10 分鐘最佳（約 15-25 題）

**問題類型**：單選、多選、量表、矩陣、開放式、排序

## 數據視覺化選擇

| 目的 | 推薦圖表 |
|------|----------|
| **比較** | 長條圖、折線圖、堆疊長條圖 |
| **分布** | 直方圖、盒鬚圖、散點圖 |
| **組成** | 圓餅圖（< 6 類）、樹狀圖 |
| **趨勢** | 折線圖、面積圖 |

**原則**：標題說明訊息、Y軸從0開始、一致顏色編碼、標註來源

## 研究品質標準

### 質性研究

| 標準 | 達成方法 |
|------|----------|
| **可信性** | 三角驗證、成員查核 |
| **可轉移性** | 厚描述、清楚脈絡 |
| **可靠性** | 詳細記錄、審計軌跡 |
| **可確認性** | 反思日誌、同儕檢核 |

### 量化研究

| 標準 | 評估方式 |
|------|----------|
| **內部效度** | 控制變項、隨機分配 |
| **外部效度** | 樣本代表性 |
| **信度** | Cronbach's alpha |
| **構念效度** | 因素分析 |

## 研究倫理

**必須**：知情同意、保護隱私、如實呈現、標註來源、說明限制

**避免**：操縱數據、選擇性呈現、未授權使用個資、誇大普適性

## 工具推薦

| 用途 | 工具 |
|------|------|
| **文獻管理** | Zotero, Mendeley |
| **質性分析** | NVivo, ATLAS.ti, Dovetail |
| **問卷調查** | Typeform, SurveyMonkey |
| **數據視覺化** | Tableau, Power BI |
| **AI 輔助** | Elicit, Consensus, Claude |

## 延伸資源

詳細模板與指南請參考 `extended/` 目錄：
- `templates.md` - 研究計劃、文獻回顧、報告、訪談指南模板
- `examples.md` - 假說分析、三角驗證、問卷設計範例
- `checklists.md` - 研究倫理、品質評估、AI 使用清單

## 參考資源

- [Research Methods Knowledge Base](https://conjointly.com/kb/)
- [Nielsen Norman Group - UX Research](https://www.nngroup.com/topic/user-research/)
- [IDEO Design Kit](https://www.designkit.org/methods)
