---
name: research-fact-checker
description: Research topics, verify facts, check historical accuracy, and validate technical details. Use when writing non-fiction, historical fiction, or any content requiring factual accuracy.
---

# Research Fact-Checker

This skill helps verify facts, research topics, and ensure accuracy across various subject areas to maintain credibility in your writing.

## Facts to Verify

Identify and verify these categories of information:

### Historical Dates and Events
- Check dates of historical events, births, deaths, and major occurrences
- Verify timeline sequences and causality between events
- Confirm historical figures' actions and relationships

### Scientific Concepts
- Validate scientific theories, laws, and principles
- Check accuracy of technical processes and procedures
- Verify measurements, units, and scientific terminology

### Technical Details
- Confirm accuracy of equipment, tools, and technology
- Validate procedures, protocols, and industry standards
- Check technical specifications and capabilities

### Geographic Information
- Verify location details, distances, and geographical features
- Confirm cultural and demographic information about regions
- Validate climate, time zones, and regional characteristics

### Cultural References
- Check accuracy of customs, traditions, and social norms
- Verify language usage, idioms, and cultural practices
- Confirm historical and contemporary cultural details

## Research Process

### 1. Identify Research Needs
- Ask what specific information needs to be researched
- Determine the scope and depth of research required
- Identify potential problem areas or uncertain facts

### 2. Identify Key Facts to Verify
- List specific claims that need verification
- Prioritize facts based on importance to the narrative
- Separate facts that must be accurate from those that can be fictionalized

### 3. Provide Credible Sources
- Use authoritative, peer-reviewed, or well-established sources
- Cross-reference multiple reliable sources for verification
- Prioritize primary sources when possible
- Document source credibility and publication dates

### 4. Summarize Findings
- Present verified facts clearly and concisely
- Highlight any discrepancies found between sources
- Provide context for how the information applies to the writing

### 5. Flag Uncertain Information
- Identify areas where information is incomplete or contested
- Note where sources disagree or where evidence is weak
- Suggest alternatives for uncertain information

## Fact-Checking Categories

### Historical Accuracy
- Verify dates, events, and figures from history
- Check period-appropriate technology, language, and customs
- Confirm historical context and cause-and-effect relationships

### Scientific Validity
- Validate scientific principles and their applications
- Check accuracy of scientific processes and phenomena
- Verify scientific terminology and concepts

### Technical Correctness
- Confirm accuracy of technical procedures and equipment
- Validate industry standards and best practices
- Check technical terminology and specifications

### Cultural Authenticity
- Verify cultural practices, beliefs, and social norms
- Check accuracy of language, dialects, and communication styles
- Confirm cultural context and appropriate representations

### Timeline Accuracy
- Verify chronological sequences of events
- Check that cause precedes effect in the timeline
- Confirm that concurrent events are properly aligned

## Research Notes Format

Create comprehensive research notes that include:

### Topic Summary
- Brief overview of the subject being researched
- Context for why this information is needed

### Key Facts Verified
- List of verified facts with supporting evidence
- Important details that must be maintained for accuracy

### Sources Referenced
- Credible sources used for verification
- Links or citations for future reference
- Assessment of source reliability

### Confidence Level
- High: Well-verified with multiple reliable sources
- Medium: Supported by some evidence but with some uncertainty
- Low: Limited or conflicting sources, requires further research

### Areas Needing More Research
- Specific questions that remain unanswered
- Aspects that require deeper investigation
- Potential risks of inaccuracy in the current information

## Genre-Specific Considerations

### Historical Fiction Requirements
- Maintain accuracy for real historical events and figures
- Allow creative interpretation for fictional characters and subplots
- Balance historical authenticity with narrative needs
- Research period-specific details (clothing, language, customs)

### Sci-fi World-Building Rules
- Establish consistent scientific principles for the fictional world
- Ensure technological capabilities align with established rules
- Maintain internal consistency for fictional scientific concepts
- Ground speculative elements in real scientific principles when possible

### Fantasy Magic Systems
- Create consistent rules and limitations for magical systems
- Ensure magical abilities align with established world-building
- Maintain logical consequences for magical actions
- Balance fantastical elements with internal consistency

### Contemporary Accuracy
- Verify current technology, procedures, and social norms
- Check for recent changes in laws, regulations, or standards
- Ensure geographic and cultural details are up-to-date
- Validate contemporary professional practices and terminology

## Research Database Maintenance

### Organize Information
- Categorize research by topic, genre, or project
- Maintain searchable database of verified facts
- Update information as new research becomes available

### Reference Management
- Keep detailed records of sources and verification
- Track confidence levels for different pieces of information
- Note when information may become outdated
- Cross-reference related topics for consistency