---
name: "research-verified"
description: "전문 검증 검색 - 신뢰도 라벨, 출처 교차 검증, 한국 맥락 최적화"
---

# Research Verified - 전문 검증 검색 스킬

## 개요

**Research Verified**는 모든 질문에 대해 자동으로 다중 출처 교차 검증을 수행하고, 신뢰도 라벨과 함께 검증된 답변을 제공하는 전문 검증 검색 스킬입니다.

핵심 특징:
- 🟢🟡🟠🔴 **신뢰도 라벨**: 모든 답변에 자동 적용
- 🔍 **다중 출처 교차 검증**: 최소 2개 이상 독립 출처 확인
- 🇰🇷 **한국 맥락 자동 반영**: KRW 환산, 국내 규정/시장 고려
- ⏱️ **투명한 검증 시간**: 소요 시간 명시
- 📊 **구조화된 출력**: CLI에 최적화된 간결한 형식
- 🎯 **적응형 검증**: 질문 복잡도에 따라 Quick/Standard/Academic 자동 선택

## 작동 원칙

### 1. 모든 답변에 신뢰도 라벨 필수

**절대 규칙**: 어떤 질문이든 답변 시작 시 신뢰도 라벨을 반드시 표시합니다.

```
🟢 확인됨 (Verified) - 3개 이상 독립 출처 완전 일치
🟡 부분 검증 (Partial) - 2개 출처 일치 또는 일부 불일치
🟠 제한적 검증 (Limited) - 1개 출처만 확인됨
🔴 검증 불가 (Unverifiable) - 신뢰 가능한 출처 없음
```

**출력 형식**:
```
🟢 **확인됨 (Verified)** | 검증 시간: 6분

## 핵심 답변
[직접적인 답변]

## 📄 출처 상세
[3개 이상 출처]
...
```

### 2. 출처 검증 프로토콜

**출처 우선순위**:
1. 🥇 **공식 문서** - 정부 기관, 공식 웹사이트, 공식 문서
2. 🥈 **학술 논문** - peer-reviewed 저널, arXiv, IEEE
3. 🥉 **공식 저장소** - GitHub 공식 저장소, 공식 릴리즈 노트
4. **검증된 기술 블로그** - 대형 기술 블로그, 공식 개발자 블로그
5. **커뮤니티 합의** - Reddit, Discord (참고용)

**검증 기준**:
- **최소 2개 독립 출처** 확인 필수
- 출처 간 **발행 기관/저자**가 독립적이어야 함
- **발행일** 명시 필수 (최신성 확인)
- **링크** 제공 (가능한 경우)

### 3. 적응형 검증 수준

질문 분석 후 자동으로 최적 수준 선택:

| 수준 | 시간 | 출처 수 | 트리거 |
|------|------|---------|--------|
| **Quick** | 2-3분 | 2-3개 | "빠르게", Yes/No 질문, 긴급 |
| **Standard** | 6-10분 | 3-5개 | 기본 선택 (대부분) |
| **Academic** | 15-20분 | 5-10개 | "학술급", "논문", 심층 분석 |

**자동 선택 로직**:
- "빠르게", "간단히" → Quick
- "논문", "학술", "연구" → Academic
- 기타 모든 경우 → Standard

### 4. 한국 맥락 자동 적용

모든 답변에 한국 사용자 맥락을 자동으로 반영:

**자동 처리 항목**:
- 💰 **KRW 환산**: USD → KRW (최신 환율)
  - 예: "$10/month (약 13,800 KRW)"
- 📋 **국내 규정**: 개인정보보호법, 전자상거래법 등
- 🏢 **시장 맥락**: 한국 시장 특성, 주요 플레이어
- 🌐 **리전 정보**: 서울 리전, 지연 시간
- 📊 **국내 통계**: 한국 사용자 데이터

**예시**:
```
## 가격 (2025-10-26 기준)
- 원가: $10/month
- KRW: 약 13,800 KRW
- VAT 포함 시: 약 15,180 KRW
```

### 5. 표준 출력 구조 (CLI 최적화)

**간결한 형식**으로 핵심 정보 전달:

```
🟢 **확인됨 (Verified)** | 검증 시간: 6분

## 핵심 답변

[200자 이내 직접 답변]

---

## 📄 출처 상세

### 출처 1: [제목/유형]
- **유형**: 공식 문서
- **저자/기관**: Anthropic
- **발행일**: 2024-12-18
- **링크**: https://...
- **핵심 내용**: [요약]
- **검증**: ✅ 확인됨

### 출처 2: [제목/유형]
...

---

## 📊 교차 검증 결과

**일치도 분석**:
- 핵심 정보 일치: 3/3 출처 (100%)
- 부가 정보 일치: 2/3 출처 (67%)
- 불일치 항목: 없음

**신뢰도 평가**: 🟢 높음

---

## 🔍 추가 컨텍스트

[관련 정보, 최신 동향, 실무 팁]

---

## ⚠️ 제한사항

- [제약사항 1]
- [제약사항 2]
- [제약사항 3]
```

## 사용 패턴

### 패턴 1: 일반 질문 (자동 검증)

```
Input: "Claude API의 최대 컨텍스트는?"

Output:
🟢 **확인됨 (Verified)** | 검증 시간: 6분

## 핵심 답변
Claude Sonnet 4: 200,000 토큰 (약 150,000 단어)
- Input: 200K 토큰
- Output: 8K 토큰 (스트리밍 시 16K)

## 📄 출처 상세
[3개 출처 검증 완료]
...
```

### 패턴 2: 빠른 확인

```
Input: "빠르게: Python 최신 버전"

Output:
🟢 **확인됨 (Verified)** | 검증 시간: 2분

## 핵심 답변
Python 3.12.7 (2024-10-01 출시)

## 📄 출처
- Python 공식 다운로드 페이지
- GitHub python/cpython 릴리즈
...
```

### 패턴 3: 비교 분석

```
Input: "Claude Sonnet 4 vs GPT-4o 비교"

Output:
🟢 **확인됨 (Verified)** | 검증 시간: 10분

## 핵심 답변
[비교 요약]

## 📊 교차 검증 비교표
| 항목 | Claude | GPT-4 | 출처 |
|------|--------|-------|------|
| 컨텍스트 | 200K | 128K | 공식 |
| 가격 (Input) | $3/MTok | $2.5/MTok | 공식 |
| KRW (Input) | 약 4,140원 | 약 3,450원 | 환산 |
...
```

### 패턴 4: 학술급 검증

```
Input: "학술급으로: Transformer 아키텍처 발전 (2020-2024)"

Output:
🟢 **확인됨 (Verified)** | 검증 시간: 18분

## 핵심 답변
[체계적 문헌 분석 요약]

## 📚 Literature Review
[1] Vaswani et al. "Attention is All You Need" (2017)
[상세 분석]

[2-8] ...

## References
[IEEE/APA 형식 인용]
...
```

## 실전 활용

### 시나리오 1: 기술 문서 작성

```
Step 1: "Claude API 주요 기능 개요"
Step 2: "위 내용 중 rate limit 정보 검증"
Step 3: "한국 개발자 주의사항 추가"
```

### 시나리오 2: 의사결정 지원

```
Input: "프로젝트에 사용할 LLM API 비교:
- Claude, GPT-4, Gemini
- 코드 생성 정확도, 속도, 가격
- 한국에서 사용 시 고려사항"

Output: [종합 비교표 + 권장사항]
```

### 시나리오 3: 규정 준수 확인

```
Input: "Claude API GDPR 준수 여부와 체크리스트"

Output: [검증 결과 + 사용자 의무사항 + 체크리스트]
```

## 고급 기법

### 기법 1: 반복 검증

```
1차: "빠르게: [주제]" → 기본 정보
2차: "위 내용 표준 수준으로 재검증" → 정확도 향상
3차: "다른 출처로도 확인" → 교차 검증
```

### 기법 2: 출처 계층화

```
Input: "다음 계층으로 구분:
1) 공식 벤치마크
2) 독립 평가
3) 커뮤니티 피드백"

Output: [계층별 분석 + 신뢰도 평가]
```

### 기법 3: 커스텀 출처

```
Input: "다음 출처만 사용:
- anthropic.com
- docs.anthropic.com
- stanford.edu (HELM)

질문: Claude 최신 기능"
```

## 주의사항

### 신뢰도 라벨 규칙

**🟢 확인됨** - 다음을 모두 만족:
- 3개 이상 독립 출처
- 핵심 정보 완전 일치
- 최신 정보 (6개월 이내 또는 최신 버전)

**🟡 부분 검증** - 다음 중 하나:
- 2개 출처만 확인
- 출처 간 일부 불일치
- 정보가 다소 오래됨 (6-12개월)

**🟠 제한적 검증** - 다음 중 하나:
- 1개 출처만 확인
- 출처 신뢰도가 낮음
- 정보가 매우 오래됨 (12개월 이상)

**🔴 검증 불가** - 다음 중 하나:
- 신뢰 가능한 출처 없음
- 출처 간 심각한 불일치
- 최신 정보 부재

### 검증 시간 가이드

**표시 방법**:
```
검증 시간: 6분
검증 시간: 2-3분
검증 시간: 15-20분
```

**실제 소요 시간**:
- Quick: 2-3분
- Standard: 6-10분
- Academic: 15-20분

### 한국 맥락 처리

**필수 반영 항목**:
1. USD → KRW 환산 (모든 가격)
2. VAT 고려 (10%)
3. 국내 규정 (개인정보보호법 등)
4. 리전 정보 (서울 리전 우선)
5. 국내 경쟁사 (네이버, 카카오 등)

## 문제 해결

### 문제 1: 출처 부족

**해결책**:
- 검색어 변경 (한글 → 영문)
- 날짜 범위 확대
- 출처 유형 확대 (커뮤니티 포함)

### 문제 2: 출처 간 불일치

**해결책**:
- 최신 출처 우선
- 공식 출처 우선
- tie-breaker 출처 추가

### 문제 3: 시간 초과

**해결책**:
- 질문 세분화
- 수준 하향 (Academic → Standard)
- 출처 수 제한

## 체크리스트

모든 답변은 다음을 포함해야 합니다:

- [ ] 신뢰도 라벨 (🟢🟡🟠🔴)
- [ ] 검증 시간 명시
- [ ] 핵심 답변 (200자 이내)
- [ ] 최소 2개 독립 출처
- [ ] 출처별 발행일
- [ ] 교차 검증 결과
- [ ] 한국 맥락 (해당 시)
- [ ] 제한사항 명시

---

## 버전 정보

- **Version**: 1.0.0
- **Last Updated**: 2025-10-26
- **Based on**: verified-information-generator v1.0.0
- **Optimized for**: Claude Code CLI

---

**이 스킬은 모든 세션에서 자동으로 활성화되며, 사용자가 명시적으로 비활성화하지 않는 한 모든 질문에 자동 적용됩니다.**
