# REST API Testing Prompt (Project Context)

This file is optional. If present, the `rest-api-testing` skill will read it for project-specific context.

Keep it short, factual, and non-secret (do not paste real tokens, passwords, API keys, or customer data).

## What to test

- Feature(s) / flows:
- Key endpoints:
- Expected behaviors / invariants:

## Environments

- How to start the API locally:
- Notes for `setup/rest/endpoints.env` presets (local/dev/staging):

## Auth

- How to obtain tokens (if any):
- Required roles / permissions:

## DB / data tools (optional)

- DB type (Postgres/MySQL/MSSQL/etc):
- LLM-usable DB tool(s) (e.g., `tun-psql`, `qb-mysql`, `mb-mssql`):
- Key schemas / tables / relations to verify:
- Common verification queries / checks:

## Other test utilities

- GUI clients / saved collections (Insomnia/Postman/Bruno):
- Admin UI (URLs + what to check):
- Logs / tracing (where + what to look for):
- Other scripts / commands:

## Notes

- Known edge cases / flaky areas:
- Any constraints (rate limits, async eventual consistency, etc.):
