---
name: result-check
description: "내가 만든 파일이 제대로 됐는지 확인해주는 도구. 빈 칸, 중복, 오류를 자동으로 찾아줘요!"
---

# 결과 확인 도구 🔍

## 이게 뭐예요?

**내가 만든 파일이 제대로 됐는지 자동으로 확인해주는 도구예요!**

마치 숙제를 선생님이 확인해주는 것처럼, 
파일에 문제가 있으면 알려주고 어떻게 고치는지도 알려줘요.

---

## 언제 사용하나요?

### ✅ 이럴 때 사용하세요

- 📊 CSV 파일을 만들었을 때
- 🔄 데이터를 정리했을 때  
- 📝 파일이 제대로 됐는지 확인하고 싶을 때
- 🤔 "이거 맞나?" 싶을 때

### 🎯 무엇을 확인하나요?

1. **파일이 있나요?** → 파일을 찾을 수 있는지
2. **데이터가 있나요?** → 빈 파일이 아닌지
3. **빈 칸이 있나요?** → 빠진 곳이 없는지
4. **중복이 있나요?** → 똑같은 게 두 번 있는지

---

## 설치하기 (2분)

### 방법 1: Claude Code에 등록하기 (추천)

```bash
# 1. 폴더 만들기
mkdir -p ~/.config/claude-code/skills/result-check

# 2. 파일 넣기
cd ~/.config/claude-code/skills/result-check
# 이 파일(SKILL.md)을 여기에 복사

# 3. 확인하기
claude --list-skills
```

보면 `result-check` 가 나와야 해요!

---

## 사용하기 (10초)

### Claude Code에서 사용

```bash
# 기본 사용법
claude --skill result-check "Check my_data.csv"

# 짧게
claude --skill result-check "my_data.csv 확인"
```

### 그냥 Python으로 사용

```bash
python check_result.py my_data.csv
```

---

## 예시

### 예시 1: 정상인 파일

```bash
$ python check_result.py good_data.csv

==================================================
🔍 파일 확인 시작!
==================================================
📁 파일: good_data.csv

1️⃣  파일이 있는지 확인 중...
   ✅ 파일 찾았어요!

2️⃣  데이터가 있는지 확인 중...
   ✅ 데이터 있어요! (100줄)

3️⃣  빈 칸이 있는지 확인 중...
   ✅ 빈 칸 없어요!

4️⃣  중복된 줄이 있는지 확인 중...
   ✅ 중복 없어요!

==================================================
📊 최종 결과
==================================================

🎉 완벽해요!
점수: 100점

✨ 문제없어요! 완료!
==================================================
```

---

### 예시 2: 문제가 있는 파일

```bash
$ python check_result.py bad_data.csv

==================================================
🔍 파일 확인 시작!
==================================================
📁 파일: bad_data.csv

1️⃣  파일이 있는지 확인 중...
   ✅ 파일 찾았어요!

2️⃣  데이터가 있는지 확인 중...
   ✅ 데이터 있어요! (50줄)

3️⃣  빈 칸이 있는지 확인 중...
   ⚠️  빈 칸이 5개 있어요!

4️⃣  중복된 줄이 있는지 확인 중...
   ⚠️  똑같은 줄이 2개 있어요!

==================================================
📊 최종 결과
==================================================

👍 좋아요!
점수: 85점

🔧 고쳐야 할 것:
   1. 빈 칸 5개
   2. 중복 2개

💡 해결 방법:
   • 빈 칸 지우기: 엑셀에서 빈 칸 찾아서 채우기
   • 중복 지우기: 엑셀에서 '데이터' → '중복 제거'
==================================================
```

---

## 점수 보는 법

| 점수 | 의미 | 해야할 것 |
|-----|------|---------|
| 🎉 90~100점 | 완벽! | 아무것도 안 해도 돼요 |
| 👍 70~89점 | 좋아요 | 작은 문제만 고치면 돼요 |
| ⚠️ 50~69점 | 그냥저냥 | 꼭 고쳐야 해요 |
| ❌ 0~49점 | 안 좋아요 | 다시 해야 해요 |

---

## 자주 묻는 질문

### Q1. "파일을 찾을 수 없어요!" 나와요

**답변**: 파일 이름을 확인해보세요!

```bash
# 현재 폴더에 어떤 파일이 있는지 보기
ls

# 파일 이름이 정확한지 확인
# 대소문자도 정확해야 해요
# My_Data.csv ≠ my_data.csv
```

---

### Q2. 빈 칸을 어떻게 고쳐요?

**답변**: 엑셀이나 메모장으로 열어서 빈 칸을 찾아 채워주세요!

```
방법 1 (엑셀):
1. 파일 열기
2. Ctrl+F (찾기)
3. "빈 셀 찾기"
4. 빈 칸 채우기

방법 2 (Python):
df = df.fillna(0)  # 빈 칸을 0으로 채우기
```

---

### Q3. 중복을 어떻게 지워요?

**답변**: 엑셀에서 쉽게 지울 수 있어요!

```
엑셀 방법:
1. 데이터 전체 선택
2. "데이터" 탭 클릭
3. "중복 제거" 클릭
4. "확인" 클릭

Python 방법:
df = df.drop_duplicates()
```

---

## 고급 사용법 (선택)

### 내가 원하는 것 확인하기

```bash
# 줄 수가 100개인지 확인
claude --skill result-check \
  "Check if my_data.csv has exactly 100 rows"

# 특정 컬럼이 있는지 확인  
claude --skill result-check \
  "Verify my_data.csv has columns: Name, Age, Score"
```

---

## 요약 (가장 중요!)

### 3단계로 끝!

```bash
# 1단계: 폴더 이동
cd /mnt/4tb/km_share

# 2단계: 확인
python check_result.py 내파일.csv

# 3단계: 점수 확인
# - 90점 이상: 완료! ✅
# - 70~89점: 조금만 고치기
# - 70점 미만: 다시 하기
```

### 한 줄 요약

**"파일 만들었으면 → 확인하기 → 문제 있으면 고치기 → 완료!"**

---

## 도움말

문제가 있으면:
1. 파일 이름 다시 확인
2. 파일이 있는 폴더가 맞는지 확인
3. 에러 메시지 읽어보기

**모르면 어른에게 물어보세요!** 👨‍👩‍👧‍👦
