---
name: resume-edit
description: 智能简历编辑器。编辑现有 HTML 简历的内容，保持设计风格一致性。当用户想要修改简历、更新简历内容、添加工作经历或项目时触发此 skill。
---

# Resume Edit - 智能简历编辑

编辑现有 HTML 简历，保持设计风格一致性。

## 工作流程

### 1. 定位简历文件

查找 `html/` 目录下的 HTML 简历文件：
- 默认选择最新修改的文件
- 如有多个文件，询问用户选择

### 2. 分析现有简历

读取并分析简历内容：
- 识别当前的设计风格（色彩、布局）
- 提取现有内容结构
- 向用户展示简历概要

### 3. 确定编辑内容

询问用户要编辑的部分：

**支持的编辑操作**
- 添加/修改工作经历
- 添加/修改项目经历
- 更新技能标签
- 修改个人简介
- 更新教育背景
- 更新联系方式
- 添加/删除区块

### 4. 执行编辑

根据用户需求修改 HTML 文件：
- 保持现有设计风格一致
- 匹配现有的 CSS 类和样式
- 确保内容仍在单页内

### 5. 后续提示

编辑完成后提示用户：
- 使用 `/resume-preview` 预览修改效果
- 使用 `/resume-pdf` 生成新的 PDF

## 编辑原则

### 风格一致性

- 新增内容使用与现有内容相同的 HTML 结构
- 保持相同的字号、颜色、间距
- 使用相同的卡片样式和标签样式

### 内容优化建议

编辑时可主动提供优化建议：
- 使用动词开头描述职责
- 量化成果（数字、百分比）
- 突出与目标职位相关的技能
- 精简冗余内容

### 单页控制

如果新增内容导致超出一页：
- 提醒用户内容可能溢出
- 建议精简其他部分
- 或调整字号/间距

## 示例交互

**用户**: 帮我更新简历的工作经历

**Claude**: 我来帮你更新工作经历。让我先读取你的简历...

[读取 html/ 目录下最新的简历文件]

你的简历目前包含以下工作经历：
1. ABC 公司 - 前端工程师 (2022.06 - 至今)
2. XYZ 公司 - 实习生 (2021.06 - 2021.09)

你想要：
- 修改现有经历的内容？
- 添加新的工作经历？
- 删除某段经历？

**用户**: 添加一段新的工作经历，我在 DEF 公司做后端开发

**Claude**: 好的，请提供这段经历的详细信息：
1. 公司全称
2. 职位名称
3. 工作时间（如 2023.01 - 2023.12）
4. 主要职责和成果（2-4 条）
