---
name: resume-optimizer
description: Optimize engineering resumes using proven STAR/XYZ methodologies, ATS best practices, and hiring manager insights. Use when reviewing resumes, improving bullet points, tailoring to job descriptions, or enhancing professional presentation. Keywords: resume, CV, bullet points, STAR, XYZ, ATS, job description, optimize, tailor, action verbs, quantify, achievements
---

# Resume Optimizer

Comprehensive resume optimization using industry-proven methodologies from hiring managers, recruiters, and FAANG engineers.

## Instructions

When activated, analyze the resume systematically across multiple dimensions and provide actionable, specific recommendations.

### 1. Initial Assessment

First, understand the context:
- **Read the resume source file** (`will_cygan_resume.typ` for this project)
- **Identify the target role** (if user provides job description, analyze it for keywords)
- **Understand career level** (entry-level, mid-level, senior, staff+)
- **Note current structure** (sections, ordering, formatting)

### 2. Core Optimization Areas

Analyze and optimize across these dimensions:

#### A. Formatting & Readability (Critical for 10-second scan)

**Check for common mistakes:**
- ❌ Two-page resumes (unless 10+ YoE for senior/staff roles)
- ❌ Double spacing (wastes space, confuses ATS parsing)
- ❌ 3+ line bullet points (shows poor conciseness)
- ❌ Professional summaries (AI-generated paragraphs waste space)
- ❌ Oversized margins or massive fonts
- ❌ Broken URLs or inconsistent fonts
- ❌ Headers/footers (ATS parsing issues)
- ❌ Two-column layouts with photos
- ❌ Icons, images, graphics
- ❌ Justified text (inconsistent spacing)
- ❌ Excessive bolding, italics, or ALL CAPS

**Enforce best practices:**
- ✅ Single page (max 2 pages for 10+ YoE)
- ✅ Single spacing with sufficient white space
- ✅ 1-2 line bullets maximum
- ✅ Standard margins (0.4-0.5 inches minimum)
- ✅ Consistent formatting throughout
- ✅ Clean, single-column layout
- ✅ Modern readable fonts (Calibri, Arial, Bitstream Charter)
- ✅ Black text, 10.5pt+ font size
- ✅ Clear section separation

#### B. Bullet Point Quality (STAR/XYZ/CAR Methods)

**For each bullet point, verify it follows one of these proven frameworks:**

**STAR Method:**
- **S**ituation: Context/challenge
- **T**ask: Your responsibility
- **A**ction: What you did (specific technical actions)
- **R**esults: Quantifiable impact

**XYZ Formula (Google's method):**
- Accomplished [X] as measured by [Y], by doing [Z]

**CAR Method:**
- **C**hallenge: Problem faced
- **A**ction: Solution implemented
- **R**esult: Outcome achieved

**Bullet point checklist:**
- [ ] Starts with strong past-tense action verb
- [ ] 1-2 lines maximum (use Quillbot/LanguageTool to shorten)
- [ ] Quantifies impact when possible (metrics at start of bullet)
- [ ] Includes technical details and tools/technologies used
- [ ] Avoids personal pronouns (I, we, my, our)
- [ ] No periods at end (bullets aren't full sentences)
- [ ] Doesn't wrap with only 1-4 words on next line
- [ ] Ordered from most relevant/impressive to least

**Good action verbs:**
- analyzed, architected, automated, built, created, decreased, designed, developed, implemented, improved, optimized, published, reduced, refactored

**Avoid weak verbs:**
- aided, assisted, coded, collaborated, communicated, executed, exposed to, gained experience, helped, participated, programmed, ran, used, utilized, worked on

**Avoid superfluous/awkward verbs:**
- amplified, conceptualized, crafted, elevated, employed, engaged, engineered, enhanced, ensured, fostered, headed, honed, innovated, mastered, orchestrated, perfected, pioneered, revolutionized, spearheaded, transformed

**Avoid excessive adjectives/adverbs:**
- excellent, innovative, expert, revolutionary, disruptive, creatively, diligently, meticulously, strategically, successfully, independently

#### C. Content Strategy

**Work Experience:**
- Focus on accomplishments, not job duties
- Highlight technical work and challenges overcome
- Show impact of your work (business value)
- Add context and technical details
- Differentiate yourself - don't be humble
- Order positions by relevance OR impressiveness
- Clearly indicate internships and contract positions
- For sensitive/NDA work: describe technologies without revealing specifics

**Skills Section:**
- Name it "Skills" (not "Technical Skills" or "Relevant Skills")
- 3 lines or less, single column format
- Order skills from most important to least
- Separate into categories: Languages, Technologies, Tools, etc.
- Use commas to separate (not pipes, hyphens, dashes)
- Proper capitalization (SolidWorks, JavaScript, PostgreSQL)
- Include languages you could theoretically interview in
- Repeat skills mentioned in bullet points
- NO soft skills (teamwork, leadership)
- NO assumed skills (Microsoft Word, typing, IDEs, OS, Git hosting sites)
- NO descriptors like "Expert in" or "Professional in"

**Projects Section (if needed):**
- Name it "Projects" (not "Personal/Academic/Technical Projects")
- Don't use word "project" in titles
- Include 2+ meaningful projects
- Link to GitHub/portfolio (only if well-maintained)
- Each project has bullet points (not paragraphs)
- Order by relevance and impressiveness
- Should solve real problems with actual users
- Not just tutorial projects or school assignments

**Education:**
- No coursework unless extremely specialized
- No high school
- Graduation date only (not date range)
- "Expected May 2025" if currently student
- Bachelor's and Master's (note apostrophe placement)
- GPA if >3.75 (2 decimal places max)
- Remove GPA after first full-time job (unless very impressive)

#### D. ATS Optimization

**Critical ATS facts:**
- ATSs are databases run by humans, not AI filters
- 98.4% of Fortune 500 companies use ATS
- Recruiters manually review applications
- Keyword searching is primary qualification method
- Both PDF and Word work fine (recommend PDF for formatting)

**ATS best practices:**
- Use exact job title from posting in resume (10.2x more interview requests)
- Include keywords from job description naturally throughout
- Use both acronyms and full terms (AWS + Amazon Web Services)
- Standard section headers (Experience, Education, Skills)
- Avoid tables, text boxes, headers/footers
- Simple formatting that parses cleanly
- Industry-specific terminology when relevant

#### E. Common Mistakes to Fix

**Content issues:**
- Listing job duties instead of accomplishments
- Including irrelevant personal information
- Unprofessional email addresses
- Outdated or irrelevant skills
- Excessive job hopping without growth pattern (5+ jobs in 4 years)
- Unverified links (broken GitHub/LinkedIn)
- AI-generated content (auto-reject)

**Formatting issues:**
- Words getting hyphenated/wrapped
- Sub-bullet points cluttering resume
- Apostrophes, ampersands, slashes excessively
- Abbreviating months with digits (9/2013)
- Using hyphens instead of en dashes for date ranges
- Bullets extending past right-aligned dates
- Including full URLs (use: github.com/username not https://www.github.com/username)

### 3. Job-Specific Tailoring

When user provides a job description:

**Step 1: Analyze job description**
- Extract required skills (must-haves)
- Extract preferred skills (nice-to-haves)
- Identify key responsibilities
- Note company values/culture signals
- Find repeated keywords and technologies

**Step 2: Resume mapping**
- Match your experience to requirements
- Identify gaps and how to address them
- Reorder bullets to highlight relevant experience first
- Add missing keywords where authentic
- Adjust technical details to match their stack

**Step 3: Keyword integration**
- Include exact job title in resume
- Mirror language from job description
- Use technology names as they appear in posting
- Include industry-specific terminology
- Natural integration (not keyword stuffing)

### 4. Output Format

Present findings organized by priority:

#### 🔴 Critical Issues (Must Fix)
- Formatting problems that hurt readability
- Weak bullet points lacking STAR/XYZ structure
- Missing quantification opportunities
- ATS parsing issues

#### 🟡 Improvement Opportunities
- Stronger action verbs
- Better quantification
- Reordering for impact
- Skills section optimization

#### 🟢 Enhancement Suggestions
- Job-specific tailoring recommendations
- Additional technical details to include
- Portfolio/GitHub improvements
- Strategic positioning

For each recommendation:
- **Location**: Section and specific bullet/line
- **Current**: What it says now
- **Issue**: Why it's suboptimal
- **Improved**: Specific rewrite suggestion
- **Rationale**: Why the change works better

### 5. Special Considerations

**Career Level Adaptations:**

**Entry-level/new grad:**
- Section order: Education → Experience → Projects → Skills
- Focus on projects if limited work experience
- Emphasize fundamental engineering skills first
- Include relevant coursework if truly specialized
- GPA if >3.75

**Mid-level (3-10 YoE):**
- Section order: Skills → Experience → Education OR Experience → Skills → Education
- Focus on technical depth and business impact
- Show progression and increasing responsibility
- Move education to bottom
- Remove GPA

**Senior/Staff (10+ YoE):**
- Can extend to 2 pages maximum
- Include brief summary (2 sentences max)
- Mention "soft" achievements and influence
- Make earlier experiences more concise
- Separate resumes for management vs IC roles

**Career changers:**
- Include brief summary explaining transition
- Link to working projects and source code
- Be concise about past experience
- Keep to 1 page
- Focus on transferable skills

### 6. Typst Resume Context

**IMPORTANT: This project uses Typst, not LaTeX or Markdown**

**Project Structure:**
- Source file: `will_cygan_resume.typ` (Typst markup language)
- Template: `@preview/modern-cv:0.8.0` (imported from Typst package registry)
- PDF output: `will_cygan_resume.pdf`
- Development: `deno task dev` or `typst watch will_cygan_resume.typ`
- Compilation: `deno task compile` or `typst compile will_cygan_resume.typ`
- Testing: `./scripts/run-local-ci.ts` before pushing

**Typst Syntax Reference:**
- Official docs: https://typst.app/docs/reference
- Syntax guide: https://typst.app/docs/reference/syntax/
- Styling: https://typst.app/docs/reference/styling/
- Scripting: https://typst.app/docs/reference/scripting/
- Context: https://typst.app/docs/reference/context/

**modern-cv Template Functions:**

1. **resume-entry** - Job/project/education entries:
```typst
#resume-entry(
  title: "Job Title",
  location: "City, State",
  date: "Month YYYY – Month YYYY",
  description: "Company Name",
  title-link: "https://url",
)
```

2. **resume-item** - Bullet points under entries:
```typst
#resume-item[
  - First bullet point
  - Second bullet point
  - Third bullet point
]
```

3. **resume-skill-item** - Skills section:
```typst
#resume-skill-item(
  "Category Name",
  (
    "Skill 1",
    "Skill 2",
    "Skill 3",
  ),
)
```

4. **github-link** - GitHub repository links:
```typst
#github-link("username/repo")
```

**When Making Recommendations:**

1. **Always use Typst syntax** (not Markdown or LaTeX)
   - Bullets use `-` inside `#resume-item[ ]` blocks
   - Links use `#github-link()` or raw URLs
   - Section headers use `= Header Name`

2. **Reference line numbers** from `will_cygan_resume.typ`
   - Example: "Line 34: Current bullet could be improved..."

3. **Maintain template structure**
   - Don't suggest breaking out of `#resume-entry()` / `#resume-item[]` patterns
   - Keep skills in `#resume-skill-item()` format
   - Preserve section order (Work Experience → Projects → Skills → Education)

4. **Provide complete code blocks** showing exact Typst syntax:
```typst
// ❌ Current (Line 34):
#resume-item[
  - Worked on payment systems using Kafka
]

// ✅ Improved:
#resume-item[
  - Architected payment processing system using Kafka and Samza,
    handling 50K+ QPS with 99.9% reliability for 2M+ daily transactions
]
```

5. **Consider PDF rendering**
   - Bullets should fit cleanly on 1-2 lines when compiled
   - Test changes with `typst watch` to see live preview
   - Ensure text doesn't overflow or create awkward line breaks

**Example Current Resume Structure:**
```typst
#import "@preview/modern-cv:0.8.0": *

#show: resume.with(
  author: (
    firstname: "Will",
    lastname: "Cygan",
    email: "wcygan.io@gmail.com",
    github: "wcygan",
    linkedin: "wcygan",
    positions: ("Senior Software Engineer",),
  ),
)

= Work Experience

#resume-entry(
  title: "Senior Software Engineer",
  location: "Chicago, IL",
  date: "March 2024 – Present",
  description: "LinkedIn",
)

#resume-item[
  - Bullet point 1
  - Bullet point 2
]
```

**Typst-Specific Tips:**
- Use proper en dashes `–` (not hyphens `-`) in date ranges: "March 2024 – Present"
- Escape special characters with backslash: `\$2M+` for dollar signs
- Multi-line bullets are allowed - Typst handles line wrapping automatically
- Comments use `//` for documentation

### 7. Reference Materials

**Typst-Specific Documentation:**
- See `TYPST-REFERENCE.md` in this skill directory for complete Typst syntax guide
- Always consult when making Typst-specific recommendations
- Reference for modern-cv template functions and parameters
- Includes common issues, debugging tips, and best practices

**Available in /advice directory:**
- Engineering resume best practices (r/EngineeringResumes wiki)
- Tech Interview Handbook guidance
- ATS myths and realities
- Direct hiring manager perspectives
- SRE interviewer insights
- What employers look for in candidates

**Use these sources to:**
- Validate recommendations against expert consensus
- Provide authoritative citations for advice
- Understand hiring manager psychology
- Optimize for real-world hiring practices
- Ensure Typst syntax is correct when suggesting changes

## Tools to Use

- **Read**: Read resume source file and reference materials
- **Grep**: Search for specific patterns or keywords
- **Edit**: Make surgical changes to resume content
- **Write**: Create comprehensive analysis reports
- **Bash**: Use jq/yq for structured data analysis if needed

## Example Activation Scenarios

This skill activates when users say:
- "Review my resume"
- "Help me improve my bullet points"
- "Optimize my resume for this job description"
- "Make my resume more ATS-friendly"
- "Improve my action verbs"
- "Tailor my resume for [company/role]"
- "Check my resume formatting"
- "How can I quantify this experience better?"

## Success Metrics

A successful optimization results in:
- ✅ All bullets follow STAR/XYZ/CAR structure
- ✅ Strong action verbs throughout
- ✅ Quantified achievements (when possible)
- ✅ Clean, ATS-friendly formatting
- ✅ Relevant keywords naturally integrated
- ✅ 1-2 line bullets maximum
- ✅ Single page (unless senior with 10+ YoE)
- ✅ Clear technical details and impact
- ✅ Passes 10-second scan test
