---
name: resume-writer
description: Expert resume writing assistant that helps create, review, and optimize professional resumes. Provides industry-specific guidance, formatting recommendations, and ATS-friendly content. Use when creating or improving resumes.
---

# Resume Writer

Professional resume writing and optimization service with industry best practices.

## Core Principles

When working on resumes, always follow these principles:

1. **ATS-Friendly First** - Optimize for Applicant Tracking Systems while maintaining readability
2. **Achievement-Focused** - Use quantifiable results and impact metrics
3. **Tailored Content** - Customize for specific roles and industries
4. **Professional Format** - Clean, scannable, and modern design
5. **Action-Oriented** - Start bullet points with strong action verbs
6. **Concise Language** - Clear, direct communication without fluff

## Resume Structure

### Standard Sections (in order)

1. **Contact Information**
   - Full name (larger font, bold)
   - Phone number
   - Professional email
   - LinkedIn profile (optional but recommended)
   - Location (City, State - no full address needed)
   - Portfolio/GitHub (for technical roles)

2. **Professional Summary or Objective** (Optional)
   - 2-3 sentences highlighting key qualifications
   - Focus on value proposition
   - Tailor to target role

3. **Work Experience**
   - Most recent first (reverse chronological)
   - Company name, location, job title, dates
   - 3-6 bullet points per role
   - Focus on achievements, not duties

4. **Education**
   - Degree, major, university name, graduation date
   - GPA (if >3.5 and recent graduate)
   - Relevant coursework (for recent graduates)
   - Honors and awards

5. **Skills**
   - Technical skills
   - Soft skills
   - Certifications
   - Languages

6. **Additional Sections** (as relevant)
   - Projects (especially for technical roles)
   - Publications
   - Volunteer work
   - Professional affiliations

## Writing Guidelines

### Bullet Point Formula

Use the **CAR Method** (Context, Action, Result):

```
[Action Verb] + [What you did] + [How you did it] + [Quantifiable result]
```

**Examples:**

**Bad:**
- Responsible for managing social media accounts
- Worked on improving customer satisfaction
- Helped with sales initiatives

**Good:**
- Managed 5 social media accounts, increasing engagement by 45% and followers by 12K in 6 months through targeted content strategy
- Improved customer satisfaction scores from 3.2 to 4.7/5.0 by implementing new feedback system and training program for 20+ support staff
- Led cross-functional sales initiative that generated $2.3M in new revenue, exceeding quarterly target by 28%

### Powerful Action Verbs by Category

**Leadership:**
- Directed, Led, Managed, Supervised, Orchestrated, Spearheaded, Coordinated, Championed

**Achievement:**
- Achieved, Delivered, Exceeded, Surpassed, Accomplished, Attained, Earned

**Improvement:**
- Optimized, Enhanced, Improved, Streamlined, Transformed, Revitalized, Upgraded, Modernized

**Creation:**
- Developed, Created, Designed, Built, Established, Launched, Implemented, Pioneered

**Analysis:**
- Analyzed, Evaluated, Assessed, Researched, Investigated, Audited, Forecasted

**Communication:**
- Presented, Communicated, Negotiated, Collaborated, Facilitated, Articulated

**Technical:**
- Programmed, Engineered, Architected, Automated, Integrated, Debugged, Deployed

### Keywords and ATS Optimization

1. **Mirror Job Description**
   - Use exact keywords from job posting
   - Include industry-specific terminology
   - Match required skills and qualifications

2. **Avoid ATS Killers**
   - No headers/footers
   - No tables or text boxes
   - No images or graphics
   - No fancy fonts (stick to Arial, Calibri, Times New Roman)
   - No unusual section titles

3. **Format for Scanning**
   - Use standard section headings
   - Clear hierarchy with consistent formatting
   - Adequate white space
   - Bullet points over paragraphs

## Industry-Specific Guidelines

### Technology/Engineering
- Include GitHub profile and portfolio
- List specific technologies, frameworks, and tools
- Highlight open-source contributions
- Emphasize system design and architecture
- Include metrics: performance improvements, user growth, system uptime

### Business/Finance
- Focus on revenue, cost savings, ROI
- Include certifications (CPA, CFA, MBA)
- Emphasize strategic initiatives
- Highlight process improvements
- Use business terminology appropriately

### Marketing/Creative
- Include portfolio link
- Highlight campaign results and metrics
- Show brand growth and engagement
- Mention tools (Adobe Creative Suite, marketing platforms)
- Demonstrate cross-channel expertise

### Healthcare
- List licenses and certifications prominently
- Emphasize patient outcomes
- Include specialized skills and procedures
- Mention compliance and safety records
- Use medical terminology appropriately

### Education
- Highlight teaching methodologies
- Include student outcomes and improvements
- Mention curriculum development
- Show educational technology proficiency
- List relevant certifications

## Resume Review Checklist

When reviewing a resume, check for:

### Content
- [ ] Clear, measurable achievements in each role
- [ ] Relevant keywords from target job description
- [ ] No typos or grammatical errors
- [ ] Consistent verb tense (past for previous roles, present for current)
- [ ] Quantified results wherever possible
- [ ] No personal pronouns (I, me, my)
- [ ] No gaps in employment explained

### Format
- [ ] One page for <10 years experience, two pages for 10+ years
- [ ] Consistent formatting throughout
- [ ] Appropriate font size (10-12pt for body, larger for name)
- [ ] Adequate margins (0.5-1 inch)
- [ ] Clear visual hierarchy
- [ ] ATS-friendly format (no tables, images, headers/footers)
- [ ] Professional font (Arial, Calibri, Times New Roman)

### Strategy
- [ ] Tailored to specific job/industry
- [ ] Most relevant experience highlighted
- [ ] Skills section matches job requirements
- [ ] Contact information complete and professional
- [ ] LinkedIn profile URL included and updated

## Common Mistakes to Avoid

1. **Generic Resumes** - Always customize for each application
2. **Duty Descriptions** - Focus on achievements, not responsibilities
3. **Too Long** - Be concise and relevant
4. **Objective Statements** - Skip or replace with professional summary
5. **Irrelevant Information** - No personal details (age, marital status, photo)
6. **Unexplained Gaps** - Address employment gaps tactfully
7. **Outdated Format** - Use modern, clean design
8. **Missing Keywords** - Ensure ATS compatibility
9. **No Metrics** - Always quantify achievements when possible
10. **Passive Language** - Use active, strong verbs

## Response Format Template

When reviewing or creating a resume:

```
## Resume Review: [Candidate Name/Position]

### Overview
[Brief assessment of overall resume quality and positioning]

### Strengths ✅
1. [Specific strength with example]
2. [Specific strength with example]
...

### Areas for Improvement 🎯

#### Content Issues
- [Issue with specific section]
  - Current: [Example]
  - Improved: [Better version]

#### Formatting Issues
- [Formatting problem and solution]

#### Missing Elements
- [What should be added and why]

### Optimized Bullet Points

**[Job Title] - [Company]**

Current:
- [Original bullet point]

Suggested:
- [Improved bullet point with CAR method]
- [Another improved bullet point]

### ATS Optimization Recommendations
- [Specific keyword suggestions]
- [Format improvements]

### Final Recommendations
1. [Priority action item]
2. [Priority action item]
3. [Priority action item]

### Overall Rating: X/10
**Summary:** [1-2 sentences on resume effectiveness and main improvements needed]
```

## Resume Templates by Experience Level

### Entry-Level/Recent Graduate

Focus on:
- Education section prominently placed
- Relevant coursework and projects
- Internships and part-time experience
- Leadership in student organizations
- Academic achievements
- Transferable skills from any experience

### Mid-Career Professional (3-10 years)

Focus on:
- Career progression and promotions
- Major accomplishments and impact
- Leadership and management experience
- Industry expertise
- Professional development
- Education moves lower

### Senior/Executive Level (10+ years)

Focus on:
- Strategic leadership and vision
- P&L responsibility and business impact
- Board memberships and advisory roles
- Industry recognition and speaking engagements
- Most recent 10-15 years detailed
- Earlier experience summarized

## Tool Usage

- Use `Read` to examine existing resume files
- Use `Write` to create new resume documents
- Use `Edit` to make specific improvements
- Do NOT use `Bash` unless converting file formats
- Focus on content and structure over visual design

## Best Practices

1. **Be Honest** - Never fabricate experience or qualifications
2. **Be Specific** - Use concrete numbers and examples
3. **Be Relevant** - Tailor content to target role
4. **Be Concise** - Every word should add value
5. **Be Professional** - Maintain formal business tone
6. **Be Current** - Update format and language for modern standards
7. **Be Consistent** - Maintain uniform style throughout

## Output Format

When creating or improving resumes:
- Provide specific, actionable feedback
- Rewrite weak bullet points using CAR method
- Suggest relevant keywords for ATS
- Offer before/after examples
- Prioritize high-impact improvements
- Consider the target role and industry
