---
name: retrospective
description: Weekly retrospective - scans Done items from the past week, prompts reflection questions, reviews Someday-Maybe backlog, captures one improvement action. Use when "weekly review", "run retrospective", "what did I ship this week", "reflect on my week", "end of week review".
allowed-tools: Read, Write, Edit, Glob, Grep, AskUserQuestion
---

# Weekly Retrospective

Scans your past week's Done items, surfaces patterns, facilitates reflection, and captures one improvement action.

## Philosophy

Jim Benson's Personal Kanban meets Plus/Delta simplicity. Automatic data gathering + facilitated reflection.

This closes the feedback loop:
```
win-the-day → task-clarity-scanner → retrospective
"What's coming"  →  "What's active"  →  "What happened"
```

## Trigger Phrases

- "weekly review"
- "run retrospective"
- "what did I ship this week"
- "end of week review"
- "reflect on my week"

## Daily Note Location

Ed's daily notes live at:
```
/Users/eddale/Documents/COPYobsidian/MAGI/Zettelkasten/YYYY-MM-DD.md
```

Each has a `## Done Today` section with completed tasks.

---

## The Flow

### Step 1: Data Gathering (Automatic)

**1a: Find the last 7 days of daily notes**

```
Glob: /Users/eddale/Documents/COPYobsidian/MAGI/Zettelkasten/202*-*-*.md
```

Filter to files from the last 7 days (including today).

**1b: Parse Done sections**

For each daily note found:
- Read the file
- Extract items from `## Done Today` section
- Count completed tasks (lines starting with `- [x]`)
- Note notable completions (research, projects, shipped work)

**1c: Check for rolling items**

Look for tasks in `## Ready` that appear across multiple days - these are items that never got done.

### Step 2: Present Week Summary

Present findings in this format:

```markdown
## This Week's Wins

**Total shipped:** [N] items across [M] days

### By Day
| Day | Date | Done |
|-----|------|------|
| Mon | 01-06 | 3 |
| Tue | 01-07 | 5 |
| Wed | 01-08 | 2 |
| Thu | 01-09 | 4 |
| Fri | 01-10 | 6 |
| Sat | 01-11 | 1 |
| Sun | 01-12 | 0 |

**Best day:** [Day] with [N] items

### Top Completions
- [Notable items - research docs, project milestones, shipped work]

### Still Rolling (optional)
- [Items that appeared in Ready all week but never completed]
```

### Step 3: Reflection Questions

Use AskUserQuestion to prompt reflection. Present ONE question at a time, capture responses.

**Question 1: Flow Check**
```
What flowed easily this week? What gave you energy?
```

Options:
- Let them type freely
- Offer prompts: "Creative work", "Coaching calls", "Building", "Writing"

**Question 2: Friction Check**
```
Where did work get stuck? What drained energy?
```

Options:
- Let them type freely
- Offer prompts: "Admin tasks", "Unclear scope", "Interruptions", "Tech issues"

**Question 3: Pattern Recognition**
```
What kept showing up this week? Any recurring themes?
```

Options:
- Let them type freely

**Question 4: One Change**
```
What ONE thing will you do differently next week?
```

This is the most important question. Push for specificity:
- Bad: "Be more focused"
- Good: "Block 2 hours every morning for deep work"

### Step 4: Save Retrospective

Create the retrospective document in Zettelkasten:

**File:** `/Users/eddale/Documents/COPYobsidian/MAGI/Zettelkasten/Retrospective - YYYY-MM-DD.md`

**Template:**
```markdown
---
type: retrospective
date: YYYY-MM-DD
week-of: YYYY-MM-DD to YYYY-MM-DD
shipped: [N]
---

# Weekly Retrospective - [Date]

## This Week's Numbers

- **Shipped:** [N] items across [M] days
- **Best day:** [Day] ([N] items)
- **Days tracked:** [N] of 7

## Top Completions

- [Notable item 1]
- [Notable item 2]
- [Notable item 3]

## Reflections

### What Flowed
[Ed's response to Question 1]

### Where Work Got Stuck
[Ed's response to Question 2]

### Patterns
[Ed's response to Question 3]

### One Change for Next Week
> [Ed's response to Question 4]

## Someday-Maybe Review

- **Items in backlog:** [N]
- **Reactivated this week:** [Item(s) or "None"]

---

*Generated by retrospective skill*
```

### Step 4b: Someday-Maybe Review

After saving the retrospective, review the Someday-Maybe backlog:

**Read the file:**
```
/Users/eddale/Documents/COPYobsidian/MAGI/Zettelkasten/Someday-Maybe.md
```

**Present a quick summary:**
```markdown
## Someday-Maybe Check

**Items parked:** [N total across categories]
**Oldest item:** [Item] (parked MM-DD, [N] days ago)

### Quick Scan by Category
| Category | Items | Oldest |
|----------|-------|--------|
| BlackBelt | 3 | 01-07 |
| Skill Building | 12 | 01-07 |
| Newsletter | 1 | 01-16 |
| ... | ... | ... |

**Want to reactivate anything this week?**
1. Show me the full list
2. Suggest items based on current focus
3. Skip - nothing for now
```

**If user selects "Suggest items":**
- Look at their recent Done items and current Ready list
- Recommend 1-2 Someday-Maybe items that align with momentum
- Offer to move to next week's daily note

**If user selects an item to reactivate:**
1. Remove from Someday-Maybe.md
2. Add to today's daily note Ready section (or specified day)
3. Confirm: "Moved [item] back to Ready. Removed from Someday-Maybe."

---

### Step 5: Link in Daily Note

After saving the retrospective doc:

1. Find today's daily note
2. Add to `## Captures` section:

```
- [[Retrospective - YYYY-MM-DD]] - Weekly review ([N] shipped)
```

Use Edit tool to append to Captures section.

### Step 6: Wrap Up

Confirm completion:

```
Retrospective saved to [[Retrospective - YYYY-MM-DD]]

Your one change for next week:
> [Their commitment]

See you next week.
```

---

## Guidelines

1. **Speed matters** - This should take 10-15 minutes, not an hour
2. **Don't force reflection** - If they want to skip a question, let them
3. **Push for specificity on "One Change"** - Vague commitments don't stick
4. **Celebrate wins** - Start with what shipped, not what didn't
5. **No judgment** - Zero-output days happen, don't comment on them
6. **Preserve the doc** - The retrospective is a record, don't overwrite previous ones

## Example Output

```markdown
## This Week's Wins

**Total shipped:** 21 items across 6 days

### By Day
| Day | Date | Done |
|-----|------|------|
| Mon | 01-06 | 4 |
| Tue | 01-07 | 5 |
| Wed | 01-08 | 3 |
| Thu | 01-09 | 2 |
| Fri | 01-10 | 6 |
| Sat | 01-11 | 1 |

**Best day:** Friday with 6 items

### Top Completions
- Research Swarm - Retrospective Best Practices
- Newsletter article on AI coaching
- Shipped retrospective skill (meta!)

Ready for reflection questions?
```
