---
name: review-pr
description: GitHub PRをレビューする。PR番号を引数として受け取り、変更内容を分析してレビューコメントを提供する。「/review-pr 123」のように使用する。
---

# GitHub PR Review

このスキルはGitHub PRの変更内容を分析し、コードレビューを行います。

## Usage

```
/review-pr <PR番号>
```

例: `/review-pr 123`

## Instructions

### ステップ1: PR情報の取得

PR番号を使用して、PRの詳細情報を取得します：

```bash
gh pr view <PR番号>
```

### ステップ2: 変更差分の取得

PRの変更差分を取得します：

```bash
gh pr diff <PR番号>
```

### ステップ3: レビューの実施

以下の観点でコードをレビューします：

1. **コードの正確性**
   - ロジックエラーやバグの可能性
   - エッジケースの考慮
   - nullチェックや境界値チェック

2. **セキュリティ**
   - 入力バリデーション
   - 機密情報の露出
   - OWASP Top 10の脆弱性

3. **パフォーマンス**
   - 非効率なアルゴリズム
   - 不要なループやメモリ確保
   - N+1問題など

4. **可読性・保守性**
   - 命名規則の遵守
   - コードの複雑さ
   - コメントの適切さ

5. **テスト**
   - テストカバレッジ
   - テストケースの網羅性

6. **プロジェクト規約**
   - CLAUDE.mdに記載されたコーディング規約への準拠
   - プロジェクト固有のルール

### ステップ4: レビュー結果の出力

レビュー結果を以下の形式で出力します：

```markdown
## PR #<番号> レビュー結果

### 概要
[PRの目的と変更内容の要約]

### 良い点
- [良い実装や改善点]

### 指摘事項

#### 必須対応 (Must Fix)
- [ ] [重大な問題点]

#### 推奨対応 (Should Fix)
- [ ] [改善が望ましい点]

#### 任意対応 (Nice to Have)
- [ ] [細かな改善提案]

### 総合評価
[Approve / Request Changes / Comment のいずれか]
```

## Notes

- PRが大きい場合は、重要なファイルから順にレビューします
- プロジェクトのCLAUDE.mdがある場合は、その規約に従ってレビューします
- 必要に応じて関連するコードベースを参照して文脈を理解します
