---
name: rfp-early-detection
description: Identify RFPs 30-90 days early by monitoring job postings, conferences, fleet changes, facility expansions, and M&A activity. Use for building vendor lists and finding opportunities before competitors.
---

# RFP Early Detection System

## Purpose

This skill helps you identify RFPs 30-90 days before they're publicly released by monitoring multiple predictive signals. Early detection allows you to position as an approved vendor before the formal RFP process begins, significantly increasing your win rate.

## When to Use This Skill

- User wants to get on RFPs before competitors
- Building approved vendor lists proactively
- Planning quarterly RFP response strategy
- Creating a predictive pipeline of opportunities

## RFP Timing Patterns

### Peak RFP Seasons

Understanding seasonal patterns helps prioritize monitoring efforts:

- **Q4 (Oct-Dec)**: 35% of annual RFPs - Budget exhaustion and new year planning
- **Q1 (Jan-Mar)**: 30% of annual RFPs - New budget allocation
- **Q2 (Apr-Jun)**: 20% of annual RFPs - Mid-year adjustments
- **Q3 (Jul-Sep)**: 15% of annual RFPs - Summer slowdown

## Detection Signals

### Signal 1: Job Postings (90-day warning)
- **Indicator**: New transportation manager hired
- **Timeline**: RFP in 60-90 days
- **Confidence**: 85%
- **Action**: Pre-position before RFP release

### Signal 2: Conference Attendance (30-60 day warning)
- **Indicator**: Key executives at industry conferences
- **Key Conferences**:
  - CSCMP EDGE (October) → RFPs follow in Nov-Dec
  - TIA Capital Ideas (April) → RFPs follow in May-June
- **Confidence**: 70%
- **Action**: Schedule face-to-face meetings

### Signal 3: FMCSA Fleet Changes (60-day warning)
- **Indicator**: Significant fleet size changes
- **Thresholds**:
  - Fleet growth >20% = capacity crisis
  - Fleet reduction >20% = outsourcing shift
- **Confidence**: 65%
- **Action**: Offer capacity solutions

### Signal 4: Facility Expansion (90-day warning)
- **Indicator**: New distribution center announced
- **Signal**: New lanes = new transportation needs
- **Confidence**: 75%
- **Action**: Map lane coverage capabilities

### Signal 5: M&A Activity (120-day warning)
- **Indicator**: Merger or acquisition announced
- **Signal**: Supply chain consolidation needed
- **Confidence**: 80%
- **Action**: Position for integration support

## Platforms to Monitor

### Government/Public Procurement

**SAM.gov** (System for Award Management)
- Federal opportunities
- Cost: Free
- Check: Daily (5 minutes)

**BidNet**
- State/local opportunities
- Cost: Free basic, $50/month premium
- Check: Daily (3 minutes)

**DOT Procurement Forecast**
- Annual visibility into planned procurements
- Cost: Free
- Check: Quarterly

### Enterprise Procurement Platforms

**SAP Ariba**
- Fortune 500 hub
- Registration required
- Focus: Large enterprises

**Coupa**
- Growing adoption
- Integrated supply chain
- Focus: Mid-market to enterprise

**JAGGAER**
- Healthcare/education focus
- Government contracts
- Focus: Public sector

**Bonfire**
- Government/ports
- RFP/RFQ management
- Focus: Public infrastructure

### Freight-Specific Platforms

**Uber Freight Exchange**
- Free registration
- Real-time spot market
- RFP participation available

**Emerge**
- Performance-based pricing (9.9% only if won)
- Digital freight network
- No upfront costs

**Shipwell**
- Integrated TMS/RFP
- Modern interface
- API connectivity

## Pre-RFP Positioning Strategy

### Timing
Send this message 30-60 days before anticipated RFP season or immediately upon detecting signals.

### Message Template

```
Subject: Request to join [Company] approved vendor list

Hi [Procurement Contact],

Reaching out before your Q4/Q1 RFP season to request addition to [Company's] transportation vendor list.

Priority1 Earnings credentials:
- MC #[NUMBER] | SmartWay Certified
- Multi-mode: FTL, LTL, Expedited, Flatbed
- CabotageTMS platform for visibility
- 10,000+ carriers nationwide

Why add us now:
✓ Specialized in [their industry/region]
✓ API/EDI ready
✓ 95%+ on-time guarantee
✓ No cost to pre-qualify

Attached: Capability statement, insurance, W-9

15-minute call to understand your process?
```

## Daily Monitoring Routine

**Total Time**: 18 minutes daily

1. **Check SAM.gov** (3 minutes)
   - New RFPs in transportation category
   - Saved search alerts

2. **Review Procurement Platforms** (5 minutes)
   - Ariba, Coupa, JAGGAER, Bonfire
   - Check notifications and new postings

3. **Scan Industry News** (5 minutes)
   - Company expansion announcements
   - M&A activity
   - Executive moves

4. **Update CRM Opportunities** (5 minutes)
   - Log new signals
   - Update opportunity scores
   - Set follow-up reminders

## Success Metrics

### Weekly Targets
- RFPs discovered weekly: 10-15
- Qualified opportunities: 3-5
- Response time to discovery: <48 hours
- Approved vendor inclusion rate: 40-50%

### Monthly Targets
- Pre-RFP positioning attempts: 20-30
- Approved vendor list additions: 5-8
- RFP participations: 8-12
- Win rate improvement: Track month-over-month

## Qualification Criteria

Not all RFPs are worth pursuing. Qualify opportunities using these criteria:

### Must-Have
- [ ] Minimum $50K annual spend
- [ ] Lanes we can service profitably
- [ ] Reasonable payment terms (Net 30-45)
- [ ] Compatible technology requirements

### Nice-to-Have
- [ ] Incumbent has known weaknesses
- [ ] Multiple decision signals detected
- [ ] Existing relationship with company
- [ ] Industry expertise advantage

## Signal Combination Strategy

**Highest Priority** (3+ signals):
- Job posting + Conference + Fleet change = 95% RFP probability
- Action: Full court press, all resources

**High Priority** (2 signals):
- Any 2 strong signals = 75% RFP probability
- Action: Pre-positioning outreach + monitoring

**Medium Priority** (1 strong signal):
- Single validated signal = 50% RFP probability
- Action: Add to watch list, quarterly check-in

## Integration with Other Skills

- Feed qualified opportunities to **Campaign Orchestration** for systematic follow-up
- Use **Job Posting Intelligence** as primary signal source
- Apply **Competitive Displacement** when incumbent is identified
- Coordinate with **Master Intelligence Orchestration** for resource allocation

## Pro Tips

1. **Build Relationships Early**: Don't wait for RFP announcement
2. **Get on Approved Lists**: Much easier before RFP pressure
3. **Attend Same Conferences**: Face-to-face beats all other channels
4. **Monitor Competitors**: Their growth signals market opportunities
5. **Use Multiple Signals**: Single signals have false positives
6. **Set Up Alerts**: Automation is key to scalability
