---
name: risk-management
description: Enterprise risk management expertise for ERM frameworks, risk assessment, business continuity, insurance strategy, third-party risk, and reputational risk. Use when assessing risks, building continuity plans, or managing organizational risk exposure.
---

# Risk Management Expert

Comprehensive risk frameworks for enterprise risk assessment, business continuity, and risk mitigation.

**Detailed References:**

- [ERM Framework & Risk Appetite](references/erm-framework.md) - COSO framework, risk appetite, quantitative analysis
- [Business Continuity Management](references/business-continuity.md) - BCM lifecycle, recovery objectives, crisis management
- [Insurance & Risk Transfer](references/insurance-risk-transfer.md) - Insurance programs, risk financing strategies

## Risk Categories

| Category          | Description                      | Examples                            |
| ----------------- | -------------------------------- | ----------------------------------- |
| **Strategic**     | Risks to business model/strategy | Competitive disruption, M&A failure |
| **Operational**   | Risks in day-to-day operations   | Process failures, supply chain      |
| **Financial**     | Financial loss risks             | Credit, market, liquidity           |
| **Compliance**    | Regulatory/legal risks           | Regulatory changes, lawsuits        |
| **Reputational**  | Brand and stakeholder risks      | Negative publicity, social media    |
| **Technology**    | IT and cyber risks               | Cyber attacks, system failures      |
| **Human Capital** | People-related risks             | Key person, talent shortage         |
| **External**      | Environmental/external risks     | Natural disasters, geopolitical     |

## Risk Assessment Process

```
RISK ASSESSMENT STEPS:

1. RISK IDENTIFICATION
   - Environmental scanning
   - Stakeholder interviews
   - Workshop facilitation
   - Historical analysis
   - Scenario analysis

2. RISK ANALYSIS
   - Probability assessment
   - Impact assessment
   - Velocity consideration
   - Control effectiveness

3. RISK EVALUATION
   - Risk prioritization
   - Comparison to appetite
   - Aggregation analysis
   - Interdependency mapping

4. RISK RESPONSE
   - Accept (within appetite)
   - Mitigate (reduce likelihood/impact)
   - Transfer (insurance, contracts)
   - Avoid (eliminate activity)

5. MONITORING & REPORTING
   - Key Risk Indicators (KRIs)
   - Risk dashboards
   - Escalation triggers
   - Periodic reassessment
```

## Risk Heat Map

```
RISK MATRIX:

         IMPACT
         Low    Medium    High    Critical
LIKELIHOOD
Very High   3      6        9        12
High        2      4        6         9
Medium      1      2        4         6
Low         1      1        2         3

SCORING:
1-2: Accept/Monitor
3-4: Active Management
6: Senior Management Attention
9-12: Executive/Board Attention
```

## Third-Party Risk Management

### Vendor Risk Framework

```
TPRM LIFECYCLE:

1. PLANNING
   - Vendor inventory
   - Risk categorization
   - Assessment requirements

2. DUE DILIGENCE
   - Questionnaires
   - Documentation review
   - On-site assessments
   - Reference checks

3. CONTRACTING
   - Security requirements
   - SLAs
   - Audit rights
   - Termination provisions

4. ONGOING MONITORING
   - Performance tracking
   - Risk reassessment
   - Issue management

5. TERMINATION
   - Data return/destruction
   - Access revocation
   - Transition planning
```

### Vendor Risk Tiers

| Tier         | Criteria                        | Assessment              |
| ------------ | ------------------------------- | ----------------------- |
| **Critical** | Core business, high data access | Full assessment, annual |
| **High**     | Significant operations impact   | Comprehensive, annual   |
| **Medium**   | Moderate business impact        | Standard, biennial      |
| **Low**      | Limited impact                  | Self-assessment         |

### Vendor Assessment Areas

```
ASSESSMENT DOMAINS:

INFORMATION SECURITY:
- Security controls
- Data protection
- Incident response
- Access management

OPERATIONAL:
- Business continuity
- Change management
- Performance history

FINANCIAL:
- Financial stability
- Insurance coverage
- Pricing sustainability

COMPLIANCE:
- Regulatory compliance
- Certifications
- Audit history

REPUTATIONAL:
- Market reputation
- Legal history
- References
```

## Operational Risk Management

### Operational Risk Framework

```
OPERATIONAL RISK CATEGORIES:

PEOPLE:
- Human error
- Inadequate training
- Fraud
- Key person dependency

PROCESS:
- Control failures
- Procedure gaps
- Documentation issues
- Capacity constraints

SYSTEMS:
- IT failures
- Data integrity
- System integration
- Technology obsolescence

EXTERNAL:
- Vendor failures
- Regulatory changes
- Natural disasters
- Market disruptions
```

### Key Risk Indicators (KRIs)

| Risk Area       | KRI                | Threshold     |
| --------------- | ------------------ | ------------- |
| **Operational** | Process exceptions | >5%           |
| **Technology**  | System downtime    | >99.9% uptime |
| **People**      | Staff turnover     | <15%          |
| **Vendor**      | SLA breaches       | <5%           |
| **Compliance**  | Policy violations  | 0 critical    |

### Control Assessment

```
CONTROL EVALUATION:

DESIGN EFFECTIVENESS:
- Is the control properly designed?
- Does it address the risk?
- Is it documented?

OPERATING EFFECTIVENESS:
- Is it consistently applied?
- Is it working as intended?
- Is evidence maintained?

CONTROL RATINGS:
Effective: Control works as designed
Needs Improvement: Minor gaps
Inadequate: Significant gaps
Absent: No control in place
```

## Reputational Risk

### Reputation Risk Framework

```
REPUTATION DRIVERS:

PRODUCTS & SERVICES:
- Quality
- Safety
- Value

CORPORATE BEHAVIOR:
- Ethics
- Governance
- Environmental impact

WORKPLACE:
- Culture
- Diversity
- Employee treatment

LEADERSHIP:
- Integrity
- Competence
- Communication

FINANCIAL:
- Performance
- Transparency
- Investor relations
```

### Reputation Monitoring

```
MONITORING SOURCES:

MEDIA:
- Traditional news
- Online publications
- Broadcast

SOCIAL:
- Twitter/X
- LinkedIn
- Reddit
- Industry forums

STAKEHOLDER:
- Customer feedback
- Employee surveys
- Investor calls
- Analyst reports

METRICS:
- Sentiment score
- Share of voice
- Message pull-through
- Crisis response time
```

## Risk Reporting

### Board Risk Reporting

```
BOARD REPORT ELEMENTS:

EXECUTIVE SUMMARY:
- Top risks
- Emerging risks
- Risk appetite status

RISK DASHBOARD:
- Heat map
- Trend analysis
- KRI status

DEEP DIVES:
- Focus areas
- Incident summary
- Response effectiveness

FORWARD LOOK:
- Emerging risks
- Strategic risks
- Mitigation plans
```

### Risk Metrics Dashboard

| Category          | Metric                 | Target | Status |
| ----------------- | ---------------------- | ------ | ------ |
| **Risk Appetite** | Risks within tolerance | 100%   |        |
| **Incidents**     | Material losses        | 0      |        |
| **Controls**      | Effective controls     | >90%   |        |
| **Issues**        | Overdue remediation    | <5%    |        |
| **Training**      | Completion rate        | >95%   |        |

## See Also

- [Fortune 50 Security](../fortune50-security/SKILL.md)
- [Fortune 50 Legal/Compliance](../fortune50-legal-compliance/SKILL.md)
- [Fortune 50 Finance](../fortune50-finance/SKILL.md)
