---
name: roblox-api
description: Roblox Engine API reference: classes, properties, methods, events. Use when looking up how to use Roblox classes or their members.
---

# Roblox API Reference

Query the Roblox Engine API. For runtime queries, use `roblox.api.getClass` and `roblox.api.getProperties` tools (powered by ReflectionService).

## Class Categories

### Services
See [services.md](services.md) for: Players, Workspace, ReplicatedStorage, ServerStorage, RunService, +17 more

### Gui
See [gui.md](gui.md) for: ScreenGui, Frame, TextLabel, TextButton, TextBox, +15 more

### Parts
See [parts.md](parts.md) for: Part, MeshPart, UnionOperation, Model, Folder, +7 more

### Physics
See [physics.md](physics.md) for: Weld, WeldConstraint, Motor6D, HingeConstraint, SpringConstraint, +9 more

### Effects
See [effects.md](effects.md) for: ParticleEmitter, Beam, Trail, Fire, Smoke, +7 more

### Animation
See [animation.md](animation.md) for: Animation, AnimationController, Animator, AnimationTrack, Keyframe

### Sound
See [sound.md](sound.md) for: Sound, SoundGroup, SoundEffect, DistortionSoundEffect, ReverbSoundEffect

### Characters
See [characters.md](characters.md) for: Humanoid, HumanoidDescription, Accessory, Shirt, Pants, +1 more

### Networking
See [networking.md](networking.md) for: RemoteEvent, RemoteFunction, BindableEvent, BindableFunction, UnreliableRemoteEvent

