---
name: roblox-scripting
description: Luau scripting for Roblox: variables, functions, tables, modules, events, coroutines. Use when writing or debugging Roblox Lua code.
---

# Scripting Reference

## Quick Reference

- **Properties and attributes**: How to use scripts to manipulate object properties and attributes.
- **Script capabilities**: Script Capabilities is a system that controls which actions scripts can perform.
- **Debounce patterns**: Debounce patterns are coding techniques that prevent a function from running too many times.
- **Bindable events and callbacks**: Bindable events and callbacks allow for back-and-forth communication on the same side of the client-server boundary.
- **Deferred engine events**: Deferred engine events defer event handlers until certain resumption points.
- **Events**: Provides an overview of events and a summary of Robloxs built-in events.
- **Remote events and callbacks**: Remote network events and callbacks allow for back-and-forth communication across the client-server boundary.
- **Scripting**: An introduction to scripting in Roblox with the Luau programming language.
- **Script types and locations**: How scripts run in Roblox, and how location impacts that behavior.
- **Reuse code**: How to use module scripts to reuse code.

## Detailed Reference

### Scripting
See [scripting.md](scripting.md) for:
- Properties and attributes
- Script capabilities
- Debounce patterns
- Bindable events and callbacks
- Deferred engine events
- ...and 10 more

### Luau
See [luau.md](luau.md) for:
- Booleans
- Luau comments
- Control structures
- Enums
- Functions
- ...and 17 more

