---
name: role-playing
description: Explore problems from multiple perspectives through structured role-playing techniques. Use when user wants to "see different viewpoints", "consider perspectives", "what would X think", "six hats", "stakeholder view", "persona analysis", or needs to understand how different people would approach a problem.
allowed-tools: Read
---

# Role-Playing - Perspective Explorer

Explore problems by deliberately adopting different viewpoints. See what you're missing by thinking as others would think.

## Quick Start

1. Identify the problem or decision to explore
2. Select technique based on what perspectives you need
3. Work through each perspective systematically

## Technique Selection

| Need | Use | Why |
|------|-----|-----|
| Structured thinking modes | Six Thinking Hats | Separates emotion, facts, creativity, critique |
| Multiple stakeholder views | Stakeholder Roundtable | Surfaces conflicting interests |
| User-centered insights | Persona Analysis | Tests against real user types |

**Default**: Use Six Thinking Hats for general exploration.

## Techniques

### Six Thinking Hats
Examine ideas through six distinct thinking modes. Everyone wears the same hat at once.

Read [cookbook/six-hats.md](./cookbook/six-hats.md)

### Stakeholder Roundtable
Role-play as different stakeholders to surface hidden concerns and conflicts.

Read [cookbook/stakeholder-roundtable.md](./cookbook/stakeholder-roundtable.md)

### Persona Analysis
Test ideas against specific user personas to ensure solutions fit real people.

Read [cookbook/persona-analysis.md](./cookbook/persona-analysis.md)

## Core Principles

1. **Commit to the role** - Think AS the perspective, not ABOUT it
2. **Suspend your own view** - Your opinion comes later
3. **Surface conflicts** - Disagreement between perspectives is valuable data
4. **Document insights** - Capture what each perspective reveals
5. **Synthesize at the end** - Bring perspectives together after exploring each

## When Role-Playing Works Best

- Decisions affecting multiple groups
- Ideas that feel "obviously right" (need challenge)
- Complex problems with no clear answer
- Building empathy for users or stakeholders
- Breaking out of habitual thinking patterns

## Warning Signs You Need This

- "We already know what users want"
- "Everyone agrees this is the right approach"
- "We didn't consider that perspective"
- Surprised by stakeholder reactions after launch
