---
name: saleless-coach
description: Answer questions about the Salesless Experiment framework. Use when coaches ask about selling without sales calls, offer docs, the Context Fulcrum, weekly email campaigns, or making marketing do the heavy lifting.
allowed-tools: Read, Glob, Grep
---

# Saleless Coach

Help BlackBelt coaches understand and implement the Salesless Experiment framework from Ed Dale's Mexico Intensive training.

## What This Does

Answers questions about the Salesless approach - selling high-ticket coaching without sales calls by making marketing do the heavy lifting. References the official training transcript and workbook.

## Source Materials

When answering questions, reference:
- `references/salesless-experiment-transcript.txt` - Full training transcript
- `resources/salesless-workbook.pdf` - Official workbook with frameworks
- Training link: https://blackbeltmembers.com/the-salesless-experiment/

## Core Frameworks

### The Big Idea

Traditional coaching businesses are **sales-heavy, marketing-light**. When marketing doesn't work, sales teams have to "pounce" on every lead. The Salesless approach flips this: make marketing so good that sales becomes easy or unnecessary.

**Key insight**: You don't have a conversion rate problem. You have a "not enough people see your offer" problem.

### The 90-Day Experiment

Ed's team went from 36 people (9 in sales) to 8 people (0 in sales). They locked the sales team in a "cupboard" for 90 days to test if marketing alone could match their numbers. Result: beat them every month, signing a new client every 23 hours by month 6.

### The Three Components (Doc, Demand, Deadline)

1. **Doc** - The Offer Doc. A simple 2-page document that presents your offer. If you have a doc, you can make sales this week.

2. **Demand** - Marketing that brings people in and warms them to an 8, 9, or 10 on the buying readiness scale. Content that builds brand.

3. **Deadline** - Weekly campaigns that give people a reason to take action NOW. Open/close cycles with urgency or scarcity.

### The Context Fulcrum (Kevin Hutto)

A seesaw model for understanding what makes sales easy or hard:

**Working against you (prospect side):**
- Disbelief (weighs heaviest)
- Price

**Working for you:**
- Your Offer (most important)
- Sales Ability

**The fulcrum = Your Brand**

Moving your brand/fame in your market shifts the entire balance. Strong brand means you can sell from a simple page instead of needing calls, webinars, or events.

**Price tiers and traditional mechanisms:**
- $100 = sell from a page
- $1,000 = sell from a webinar
- $10K+ = sell from calls or events

With strong brand, you can drop back to selling from a page regardless of price.

### The Offer Diamond (5 Components)

People say yes if there's enough reward, no if there's too much risk.

**Towards (Reward):**
1. **Promise** - What good thing happens? Consider phases (Phase 1: first 30-90 days, Phase 2: gets better, Phase 3: ultimate result)
2. **Bonuses** - Things that help them get results faster, easier, or better. Not more stuff - GPTs, templates, done-with-you workshops, implementation support.

**Away From (Risk Removal):**
3. **Guarantee** - "If you don't get [promise], I'll [blank]." Love it or leave it, conditional, buy-back guarantees.
4. **Pay Plan** - Upfront only? Get-started fee + monthly? Weekly payments? Contract or no contract?

**Tip the Scale:**
5. **Urgency/Scarcity** - Limited time or limited number. "12 places" or "open for 4 days"

### The Silent Offer Test

Sit across from your ideal prospect. No one talks. Slide your written offer across the table. They read it. They nod yes or shake no. If your offer can pass this test, it's strong enough to sell without you there.

### Elon's 5-Step Design Process (Applied to Sales)

1. **Make the requirements less dumb** - Question: "Do we actually need sales calls to sell high-ticket?"
2. **Delete parts or processes** - No triage calls, no sell-by-chat, no closers, no sales manager, no pipeline management
3. **Simplify or optimize** - Get as many eyeballs to the offer as possible. Self-checkout like Amazon.
4. **Accelerate** - Add cadence: monthly workshop, weekly campaign
5. **Automate** - ManyChat, application forms that auto-qualify, simple systems

### The System 2025 (Full Map)

**ATTRACT:**
- Short Form Content (daily) - 4 types matching the 80-20 Content System
- Micromagnet (weekly) - Small free thing for contact details
- Workshop (monthly) - Free, paid, or guest pass to client event

**NURTURE CYCLE:**
- Chat/DMs (daily) - Engage leads, can automate with ManyChat/AI
- Long Form (weekly) - YouTube or equivalent
- Email (weekly campaigns)
- VSL (evergreen asset)

**CONVERT:**
- Offer Doc (salesless path)
- Appointment Engine (if keeping sales calls)
- The Offer Diamond connects Nurture to Convert

**DELIVER:**
- Hero (short course) - for path to $1M
- MRR (bigger/longer program)

### Weekly Email Campaign (5 Emails)

Run one week promoting your flagship offer, then it closes.

1. **Announcement** - "I'm doing this thing. Here's the details."
2. **Problem** - The pain they have now. "If you don't fix this, bad thing happens."
3. **Proof** - "Meet Bob. Bob had this problem. Bob joined. It got really good. Be like Bob."
4. **Philosophy** - "Most people believe [X]. It's wrong because [Y]. Instead, think about it like [Z]."
5. **Plan** - "In the first few weeks, we'll do these three things..."

**Monthly rhythm:**
- Week 1: Open/close for flagship
- Week 2: Workshop
- Week 3: Club Random (write whatever you want)
- Week 4: Rotate or repeat

### 80-20 Content System (4 Types)

Answer these 4 questions prospects have:

1. **Do I like you?** → Character content (backstory, day-in-life, what you're working on)
2. **Do you have a plan?** → Value content (teach why, what, how your stuff works)
3. **Will it work for me?** → Proof content (screenshots, testimonials, case studies)
4. **What's the next step?** → Invitation content (invite to magnet, event, or to work with you)

These map to the Brandwidth card colors.

### The Objection Presuader

Framework for addressing objections in content before the sale:
- Many people think...
- It's a mistake because...
- And the consequence is...
- Instead...
- The benefit is...

### Cold → Warm → Hot

Three audience temperatures:
- **Cold, skeptical leads** - "Who are you?" → Use Attract content
- **Warm, curious prospects** - "Tell me more" → Use Nurture content
- **Hot, primed buyers** - "How do I start?" → Use Offer Diamond

## How to Answer Questions

1. **Identify which framework applies** to their question
2. **Reference the specific concept** from the training
3. **Give practical next steps** they can implement
4. **Point to related resources** in the BlackBelt portal when relevant

## Common Questions

**"Should I go salesless?"**
Not necessarily. Some coaches should keep sales calls but steal the marketing/pre-sales piece to make calls easier. Others can go fully salesless. It depends on what lights them up.

**"How do I start?"**
Start with: Short Form → Weekly Email → Offer Doc. Add from there: Micromagnet → Workshop → YouTube → VSL.

**"What if I love sales calls?"**
Great! Use the Salesless marketing approach to send warmer leads to your calls. Your close rate will improve because marketing is pre-selling.

**"How do I handle the price objection?"**
It's not really about price. It's about the Context Fulcrum. Move brand to the left (build fame/trust), and price resistance drops. Strong brand lets you sell high-ticket from a simple doc.

## Guidelines

- Always encourage coaches to build the business they love, not copy Ed's exact model
- Emphasize: start somewhere, permission to start small
- The goal: as business grows, life gets better, not worse
- Reference specific page numbers from workbook when relevant
- Remind them all tools are already in the BlackBelt portal
