# Saleless Coach - Technical Reference

## What It Does

Answers questions about Ed Dale's Salesless Experiment framework for BlackBelt coaches. Uses the official transcript and workbook as source material to provide accurate, framework-based guidance.

## Dependencies

**Tools required:** Read, Glob, Grep

**Source materials:**
- `references/salesless-experiment-transcript.txt` - Full training transcript (2,220 lines)
- `resources/salesless-workbook.pdf` - Official workbook with visual frameworks

## Usage

**Trigger phrases:**
- "How does the Salesless approach work?"
- "Explain the Context Fulcrum"
- "What's the Offer Diamond?"
- "How do I sell without sales calls?"
- "What's the weekly email campaign?"
- Questions about Doc, Demand, Deadline
- Questions about the 5-step design process

## Key Frameworks Covered

| Framework | Purpose |
|-----------|---------|
| The 90-Day Experiment | Origin story and proof of concept |
| Doc, Demand, Deadline | The three core components |
| Context Fulcrum | Why brand matters more than sales ability |
| Offer Diamond | 5 components of a compelling offer |
| Silent Offer Test | Validation method for offers |
| Elon's 5-Step Process | Simplification framework |
| The System 2025 | Full marketing-to-delivery map |
| Weekly Email Campaign | 5-email promotion sequence |
| 80-20 Content System | 4 types of content |

## File Structure

```
skills/saleless-coach/
├── SKILL.md                  # Main skill instructions
├── docs/
│   ├── README.md             # This file
│   ├── GUIDE.md              # Business-friendly explanation
│   └── ROADMAP.md            # Future improvements
├── references/
│   └── salesless-experiment-transcript.txt
├── resources/
│   └── salesless-workbook.pdf
├── scripts/                  # (empty - no automation needed)
└── assets/                   # (empty)
```

## Testing

1. Ask: "Explain the Salesless approach"
   - Should reference the 90-day experiment, three components, and Context Fulcrum

2. Ask: "What's the Offer Diamond?"
   - Should explain all 5 components: Promise, Guarantee, Bonuses, Pay Plan, Urgency/Scarcity

3. Ask: "How do I write a weekly email campaign?"
   - Should describe the 5 emails: Announcement, Problem, Proof, Philosophy, Plan

4. Ask: "Should I go salesless?"
   - Should NOT prescribe one path - should explain it depends on what lights them up
