---
schema: "1.0"
name: sales
version: "1.0.0"
description: 銷售技巧：B2B/B2C 銷售、客戶開發、電商營運、成交策略
domain: business
triggers:
  keywords:
    primary: [銷售, sales, 業務, CRM, 電商, ecommerce, B2B, B2C]
    secondary: [成交, closing, 客戶開發, prospecting, 報價, 談判, negotiation, AOV, 客單價, 購物車]
  context_boost: [客戶, customer, 營收, revenue, 轉換, conversion]
  context_penalty: [code, 程式, api, database]
  priority: high
dependencies:
  software-skills: [e-commerce]
author: claude-domain-skills
---

# 銷售與電商營運 Sales & E-Commerce

> 從客戶開發到成交的完整銷售流程

## 適用場景

- B2B 企業銷售策略
- B2C 零售與電商營運
- 客戶開發與業務拓展
- 報價談判與成交技巧
- 電商數據分析與優化

## 銷售流程

```
┌─────────────────────────────────────────────────────────────────┐
│  B2B 銷售漏斗                                                   │
│                                                                 │
│  ┌─────────────────────────────────────────────────────┐       │
│  │              潛在客戶 (Leads)                        │       │
│  └─────────────────────────────────────────────────────┘       │
│              ↓  初步接觸、資格審查                              │
│        ┌───────────────────────────────────────┐               │
│        │       合格線索 (MQL → SQL)             │               │
│        └───────────────────────────────────────┘               │
│              ↓  需求探索、方案演示                              │
│           ┌─────────────────────────────────┐                  │
│           │        商機 (Opportunity)        │                  │
│           └─────────────────────────────────┘                  │
│              ↓  報價、談判、異議處理                            │
│              ┌───────────────────────────┐                     │
│              │       成交 (Closed Won)    │                     │
│              └───────────────────────────┘                     │
│                                                                 │
│  關鍵指標：轉換率、銷售週期、平均成交金額、贏單率               │
└─────────────────────────────────────────────────────────────────┘
```

## B2B 銷售技巧

### SPIN 銷售法

| 階段 | 問題類型 | 目的 |
|------|----------|------|
| **S** Situation | 情境問題 | 了解客戶現狀 |
| **P** Problem | 問題問題 | 發掘痛點 |
| **I** Implication | 暗示問題 | 擴大痛點影響 |
| **N** Need-payoff | 需求問題 | 引導解決方案 |

### 銷售異議處理

```markdown
## LAER 框架

1. **Listen 傾聽** - 讓客戶完整表達
2. **Acknowledge 認可** - 表示理解
3. **Explore 探索** - 深入了解真正顧慮
4. **Respond 回應** - 針對性解決

## 常見異議類型

| 異議 | 真實含義 | 處理方式 |
|------|----------|----------|
| 「太貴了」 | 價值未傳達 | 強調 ROI |
| 「要考慮」 | 有未解決疑慮 | 探索真正問題 |
| 「沒預算」 | 優先級不夠高 | 量化痛點成本 |
| 「用現有的就好」 | 害怕改變風險 | 提供過渡方案 |
```

### 報價與談判

```
┌─────────────────────────────────────────────────────────────────┐
│  報價策略                                                       │
│                                                                 │
│  1. 錨定效應                                                    │
│     • 先報高方案，再給中間方案                                  │
│     • 三層定價：基本 / 專業 / 企業                              │
│                                                                 │
│  2. 價值優先                                                    │
│     • 先談價值，後談價格                                        │
│     • 用 ROI 框架：投入 vs 產出                                 │
│                                                                 │
│  3. 稀缺性                                                      │
│     • 限時優惠                                                  │
│     • 名額限制                                                  │
│                                                                 │
│  談判原則：                                                     │
│  • 永遠有備案 (BATNA)                                          │
│  • 不先出底價                                                   │
│  • 交換而非讓步                                                 │
└─────────────────────────────────────────────────────────────────┘
```

## 電商營運

### 核心指標

| 指標 | 說明 | 公式 |
|------|------|------|
| **GMV** | 總交易額 | 訂單數 × 客單價 |
| **AOV** | 平均客單價 | 營收 / 訂單數 |
| **購物車轉換率** | 加購到成交 | 訂單數 / 加購車數 |
| **棄單率** | 放棄結帳比例 | 棄單數 / 加購車數 |
| **復購率** | 回購客戶比例 | 復購客數 / 總客數 |

### 電商提升策略

```markdown
## 提升客單價 (AOV)

1. **組合優惠** - 買 A 送 B、滿額贈
2. **加價購** - 低門檻升級
3. **滿額免運** - 設定門檻
4. **推薦搭配** - 智慧推薦

## 降低棄單率

1. **簡化結帳** - 減少步驟
2. **多元金流** - 支援各種支付
3. **棄單提醒** - Email / 簡訊召回
4. **信任標章** - 安全認證顯示

## 提升復購

1. **會員制度** - 積點、等級
2. **訂閱制** - 定期購
3. **生日優惠** - 個人化關懷
4. **EDM 經營** - 價值內容
```

### 電商營運節奏

```
┌─────────────────────────────────────────────────────────────────┐
│  電商年度大促節點                                               │
│                                                                 │
│  Q1                                                             │
│  ├─ 1月：年貨節、新年促銷                                      │
│  ├─ 2月：情人節                                                │
│  └─ 3月：婦女節、開學季                                        │
│                                                                 │
│  Q2                                                             │
│  ├─ 4月：清明、春季換新                                        │
│  ├─ 5月：母親節、618 預熱                                      │
│  └─ 6月：618 年中大促                                          │
│                                                                 │
│  Q3                                                             │
│  ├─ 7月：暑期促銷                                              │
│  ├─ 8月：開學季、七夕                                          │
│  └─ 9月：中秋、99 購物節                                       │
│                                                                 │
│  Q4                                                             │
│  ├─ 10月：國慶、萬聖節                                         │
│  ├─ 11月：雙 11、黑五                                          │
│  └─ 12月：雙 12、聖誕、跨年                                    │
└─────────────────────────────────────────────────────────────────┘
```

## CRM 客戶管理

### 客戶分級 (RFM 模型)

| 維度 | 說明 | 意義 |
|------|------|------|
| **R** Recency | 最近購買時間 | 新鮮度 |
| **F** Frequency | 購買頻率 | 忠誠度 |
| **M** Monetary | 購買金額 | 價值度 |

```markdown
## 客戶分群策略

| 分群 | RFM 特徵 | 行動 |
|------|----------|------|
| 重要價值 | R↑ F↑ M↑ | VIP 維護 |
| 重要發展 | R↑ F↓ M↑ | 提升頻次 |
| 重要保持 | R↓ F↑ M↑ | 喚醒召回 |
| 重要挽留 | R↓ F↓ M↑ | 挽回流失 |
| 一般客戶 | R↑ F↓ M↓ | 培養價值 |
```

## 銷售團隊管理

### 業績管理

```markdown
## 銷售目標設定 (SMART)

- **S** pecific - 具體數字
- **M** easurable - 可衡量
- **A** chievable - 可達成
- **R** elevant - 相關性
- **T** ime-bound - 有時限

## 業績拆解

年度目標
├─ 季度目標 (考慮季節性)
├─ 月度目標
├─ 週目標
└─ 日目標 (行動指標)

行動指標：
• 每日撥打電話數
• 每週拜訪客戶數
• 每月提案數
```

## 工具推薦

- **CRM**: Salesforce, HubSpot, Pipedrive
- **電商平台**: Shopify, Shopline, 91APP
- **金流**: 綠界、藍新、Stripe
- **數據分析**: Google Analytics, Mixpanel
- **Email**: Mailchimp, Klaviyo

## 進階談判技巧

### 談判準備框架

```
┌─────────────────────────────────────────────────────────────────┐
│  談判準備 7P 框架                                               │
│                                                                 │
│  1. Purpose (目的)                                              │
│     • 我的理想結果是什麼？                                      │
│     • 可接受的最低條件？                                        │
│     • 對方可能的目標？                                          │
│                                                                 │
│  2. Product (產品)                                              │
│     • 我方產品的獨特價值？                                      │
│     • 競爭對手的差異點？                                        │
│                                                                 │
│  3. Person (對象)                                               │
│     • 決策者是誰？影響者？                                      │
│     • 對方的 KPI 和壓力點？                                     │
│                                                                 │
│  4. Problem (問題)                                              │
│     • 對方的核心痛點？                                          │
│     • 不解決的後果成本？                                        │
│                                                                 │
│  5. Power (權力)                                                │
│     • 誰更需要這筆交易？                                        │
│     • 我有什麼談判籌碼？                                        │
│                                                                 │
│  6. Plan B (備案)                                               │
│     • 我的 BATNA 是什麼？                                       │
│     • 對方的 BATNA 是什麼？                                     │
│                                                                 │
│  7. Process (流程)                                              │
│     • 談判的議程安排？                                          │
│     • 讓步的順序策略？                                          │
└─────────────────────────────────────────────────────────────────┘
```

### 談判戰術

| 戰術 | 說明 | 應對方式 |
|------|------|----------|
| **沉默** | 說完等待，不急著填補沉默 | 不要被迫讓步 |
| **分割** | 把大問題拆成小問題談 | 注意整體利益 |
| **交換** | 「如果您...我可以...」 | 確保等價交換 |
| **時限** | 創造緊迫感 | 識別是否真實 |
| **好人壞人** | 一個唱白臉一個唱黑臉 | 直接對話決策者 |
| **蠶食** | 成交後追加小要求 | 保持警覺，可拒絕 |

### 價格談判腳本

```markdown
## 當客戶說「太貴了」

❌ 錯誤回應：
「我們可以打折」「您預算多少？」

✅ 正確流程：
1. 「您是跟什麼比較覺得貴呢？」（了解錨點）
2. 「您最重視的功能是哪些？」（確認價值點）
3. 「如果不解決這個問題，您估計一年損失多少？」（量化痛點）
4. 「我們的方案在 X 個月內可以幫您節省 Y...」（ROI 論述）

## 當客戶要求折扣

原則：不白給，要交換

「我們確實有一些彈性空間，但我需要了解...」
• 「如果我們提供優惠，您是否能在本週內簽約？」
• 「如果調整到您的預算，能否接受年付方案？」
• 「如果我們給予折扣，能否增加合約年限？」
```

## 銷售流程自動化

### 銷售自動化觸發器

```
┌─────────────────────────────────────────────────────────────────┐
│  自動化銷售流程設計                                             │
│                                                                 │
│  觸發條件              →  自動動作              →  人工跟進     │
│  ─────────────────────────────────────────────────────────────  │
│  訪客下載白皮書        →  發送系列教育郵件      →  SDR 致電    │
│  瀏覽定價頁 > 3 次     →  觸發即時聊天邀請      →  AE 聯繫     │
│  試用到期前 3 天       →  發送續約提醒          →  CSM 跟進    │
│  購物車棄單 1 小時     →  發送召回郵件+折扣     →  -           │
│  高價值客戶生日        →  發送專屬優惠          →  業務致電    │
│  NPS 低分回饋          →  創建緊急工單          →  主管介入    │
└─────────────────────────────────────────────────────────────────┘
```

### 銷售郵件模板

```markdown
## 初次接觸 (Cold Outreach)

主旨：{公司名} 的 {痛點} 問題？

{名字} 您好，

注意到 {公司名} 最近 {觀察到的事件/挑戰}。

我們幫助了 {類似客戶} 在 {時間} 內達成 {具體成果}。

您是否有 15 分鐘聊聊 {痛點} 的解決方案？

## 跟進郵件 (Follow-up)

主旨：Re: {前次主旨}

{名字} 您好，

上週寄了一封信給您，想確認是否收到？

補充一個案例：{客戶名} 用我們的方案，{成果數字}。

附上一份 {資源名稱}，或許對您有幫助。

## 異議處理後

主旨：關於您提到的 {異議}

{名字} 您好，

感謝今天的交流，了解您對 {異議} 的顧慮。

我跟團隊討論後，有一個想法：{解決方案}。

附上 {案例/數據}，供您參考。
```

## 銷售數據分析

### 銷售漏斗健康度診斷

| 問題症狀 | 可能原因 | 改善方向 |
|----------|----------|----------|
| Lead 量不足 | 行銷漏斗問題 | 增加獲客管道 |
| MQL→SQL 轉換低 | 線索品質差 | 優化評分標準 |
| SQL→商機 轉換低 | 需求挖掘不足 | 強化 SPIN 訓練 |
| 商機→成交 轉換低 | 異議處理弱 | 談判技巧培訓 |
| 銷售週期過長 | 流程卡點 | 識別瓶頸環節 |
| 贏單率下降 | 競爭加劇 | 差異化定位 |

### 銷售預測模型

```markdown
## 加權管道法 (Weighted Pipeline)

預測營收 = Σ (商機金額 × 階段成交機率)

| 階段 | 成交機率 | 範例金額 | 加權金額 |
|------|----------|----------|----------|
| 初步接觸 | 10% | $100K | $10K |
| 需求確認 | 25% | $80K | $20K |
| 方案演示 | 50% | $60K | $30K |
| 報價談判 | 75% | $40K | $30K |
| 口頭承諾 | 90% | $30K | $27K |
| **預測營收** | - | $310K | **$117K** |

## 銷售速度公式

銷售速度 = (商機數 × 贏單率 × 平均成交金額) / 銷售週期天數

優化方向：
• ↑ 商機數：增加獲客
• ↑ 贏單率：提升技能
• ↑ 成交金額：提升客單價
• ↓ 銷售週期：優化流程
```

## 社群銷售 (Social Selling)

### LinkedIn 銷售策略

```
┌─────────────────────────────────────────────────────────────────┐
│  LinkedIn 銷售漏斗                                              │
│                                                                 │
│  曝光層                                                         │
│  • 每日發文 1 篇（價值內容，非廣告）                           │
│  • 評論目標客戶貼文                                             │
│  • 分享行業洞察                                                 │
│           ↓                                                     │
│  連結層                                                         │
│  • 個人化邀請（提及共同點）                                     │
│  • 接受後發送歡迎訊息（不推銷）                                 │
│  • 互動對方內容 2-3 週                                         │
│           ↓                                                     │
│  轉換層                                                         │
│  • 提供有價值資源                                               │
│  • 邀請參加活動/webinar                                         │
│  • 提出對話邀請                                                 │
│                                                                 │
│  黃金比例：80% 價值內容 / 20% 業務相關                         │
└─────────────────────────────────────────────────────────────────┘
```

### 社群銷售指標

| 指標 | 說明 | 目標 |
|------|------|------|
| SSI 分數 | LinkedIn Social Selling Index | > 70 |
| 連結增長 | 每週新增連結數 | > 20 |
| 貼文互動 | 按讚+評論+分享 | > 100/篇 |
| InMail 回覆率 | 訊息回覆比例 | > 25% |
| 轉換到會議 | 連結→首次通話 | > 5% |

## 常見銷售錯誤

| 錯誤 | 正確做法 |
|------|----------|
| 一開口就講產品 | 先問問題，了解需求 |
| 聽到異議就降價 | 先探索真正顧慮 |
| 只跟對口人聯繫 | 建立多點關係（經濟買家、使用者、影響者） |
| 客戶說考慮就放著 | 約定明確下一步和時間 |
| 成交後不再聯繫 | 持續經營，開發轉介紹 |
| 把「忙」當真 | 「忙」= 優先級不夠高，要提升緊迫感 |

## 相關資源

- [SPIN Selling](https://www.amazon.com/SPIN-Selling-Neil-Rackham/dp/0070511136)
- [The Challenger Sale](https://www.amazon.com/Challenger-Sale-Control-Customer-Conversation/dp/1591844355)
- [Never Split the Difference](https://www.amazon.com/Never-Split-Difference-Negotiating-Depended/dp/0062407805)
- [電商人的 Growth Hacking](https://growth.design/)
- [The Sales Acceleration Formula](https://www.amazon.com/Sales-Acceleration-Formula-Technology-Inbound/dp/1119047072)
