---
name: sales-email-sequence
description: Create high-converting email sequences for sales, launches, and nurture campaigns. Use when the user needs email sequences, drip campaigns, launch emails, or automated email workflows.
---

# Sales Email Sequence Creator

Create email sequences that nurture leads, build trust, and drive conversions while maintaining authentic voice and providing genuine value.

## Before Writing

1. **Read context profiles**:
   - `/context/voice-dna.json` - Match authentic voice
   - `/context/icp.json` - Understand audience pain points and language
   - `/context/business-profile.json` - Know the offer details

2. **Gather sequence details**:
   - What's being sold/promoted?
   - What triggers the sequence?
   - How many emails?
   - What's the timeline?

## Sequence Types

### Type 1: Welcome Sequence (5-7 emails)

**Purpose**: Introduce yourself, deliver value, build relationship

```
Email 1 (Day 0): Welcome + Deliver lead magnet
Email 2 (Day 1): Your story + why you do this
Email 3 (Day 3): Quick win / valuable tip
Email 4 (Day 5): Common mistake to avoid
Email 5 (Day 7): Case study or social proof
Email 6 (Day 10): Introduce your solution (soft pitch)
Email 7 (Day 14): Direct offer + CTA
```

### Type 2: Launch Sequence (7-10 emails)

**Purpose**: Build anticipation, handle objections, drive sales

```
Email 1: Announcement / Coming soon
Email 2: The problem deep-dive
Email 3: The solution reveal
Email 4: Social proof / case studies
Email 5: Cart open + full details
Email 6: FAQ / objection handling
Email 7: Bonus announcement
Email 8: Last chance (24hr warning)
Email 9: Final hours
Email 10: Cart closed + waitlist
```

### Type 3: Nurture Sequence (Ongoing)

**Purpose**: Stay top of mind, provide value, maintain relationship

- Educational content
- Behind-the-scenes
- Curated resources
- Personal stories
- Industry insights

### Type 4: Re-engagement Sequence (3-5 emails)

**Purpose**: Win back inactive subscribers

```
Email 1: "We miss you" + best content
Email 2: "What changed?" + survey
Email 3: Special offer for returning
Email 4: Last chance before removal
Email 5: Goodbye (triggers unsubscribe cleaning)
```

## Email Structure Template

### Subject Line
- Under 50 characters ideal
- Create curiosity or urgency
- Avoid spam triggers
- Test variations

### Preview Text
- 40-100 characters
- Complements subject line
- Adds context or curiosity

### Email Body

```
[HOOK - First line that pulls them in]

[STORY/CONTEXT - Why this matters now]

[VALUE - The insight, tip, or content]

[BRIDGE - Connection to offer/CTA]

[CTA - Clear single action]

[SIGNATURE]

[P.S. - Optional second hook or CTA]
```

## Writing Guidelines

### Subject Line Formulas

- Question: "Are you making this mistake?"
- Number: "3 ways to [achieve result] this week"
- Curiosity: "I wasn't going to share this..."
- Direct: "[First name], your [thing] is ready"
- Story: "The $50k lesson I learned the hard way"
- Urgency: "24 hours left"
- Personal: "Quick question for you"

### Email Best Practices

- One idea per email
- Short paragraphs (1-3 lines)
- Conversational tone
- Single clear CTA
- Mobile-friendly formatting
- Personalization tokens
- Reply-worthy content

### What to Avoid

- Multiple CTAs competing
- Walls of text
- Over-designed HTML
- Spam trigger words
- Generic greetings
- Unclear value proposition
- Missing unsubscribe

## Output Format

For each email in the sequence, provide:

```
---
EMAIL [NUMBER]: [Name/Purpose]
Send: [Timing - e.g., "Day 3" or "24 hours after Email 2"]
---

Subject: [Subject line]
Preview: [Preview text]

---

[Full email body]

---

CTA Button: [Button text]
Link: [Where it goes]

Notes: [Any strategic notes about this email]
```

## Sequence Creation Process

### Step 1: Define the Goal

Ask:
- "What action do you want subscribers to take?"
- "What's the offer or end goal?"
- "What objections need to be handled?"
- "What's the timeline?"

### Step 2: Map the Journey

- Identify emotional progression
- Plan value delivery
- Place strategic CTAs
- Build in social proof

### Step 3: Write Each Email

- Follow the structure
- Maintain voice consistency
- Build on previous emails
- Escalate appropriately

### Step 4: Review Sequence

Checklist:
- [ ] Clear progression/story arc
- [ ] Consistent voice throughout
- [ ] Value in every email
- [ ] Objections addressed
- [ ] Social proof included
- [ ] CTAs are clear
- [ ] Timing makes sense
- [ ] Mobile-friendly format
