---
name: sales-templates
description: |
  Load when creating sales outreach emails, negotiation scripts, follow-up
  sequences, or any sales-related communication. Contains templates and
  best practices for professional sales communication.
---

# Sales Templates Skill

## Core Philosophy

Sales is about solving problems, not pushing products. Listen more than you talk. Be helpful even when there's no immediate sale. Build relationships, not just transactions.

## Cold Outreach

### Research Before Outreach

Before reaching out, gather:
- Company recent news (funding, launches, hiring)
- Contact's role and responsibilities
- Their content (blog posts, social media)
- Mutual connections
- Why they're a good fit

### Cold Email Framework: AIDA

**A**ttention: Subject line + first line
**I**nterest: Relevance to them
**D**esire: What you offer, proof
**A**ction: Clear next step

### Cold Email Templates

#### Template 1: The Relevance Hook

```markdown
Subject: [Company] + [Your Publication] partnership?

Hi [Name],

I noticed [Company] just [recent event - funding, launch, hire]. Congrats!

I run [Publication Name], a newsletter reaching [X] [audience type] in
[region]. We've helped companies like [Similar Company] reach [result].

Your [product/service] would be a great fit for our readers who are
looking for [solution category].

Would you be open to a 15-minute call to explore sponsorship options?

Best,
[Your Name]

P.S. [Personal note or additional hook]
```

#### Template 2: The Mutual Connection

```markdown
Subject: [Mutual Connection] suggested I reach out

Hi [Name],

[Mutual Connection] mentioned you're looking for ways to reach
[target audience].

I publish [Newsletter Name], which reaches [X] [audience description]
every [frequency]. Our sponsors typically see [result/metric].

Happy to share our media kit and past sponsor results if helpful.

Would Thursday or Friday work for a quick call?

[Your Name]
```

#### Template 3: The Value-First Approach

```markdown
Subject: Data on [their industry] audience - thought you'd find useful

Hi [Name],

I came across [Company] while researching [industry] for my newsletter
audience.

Thought you might find this useful: [Interesting stat or insight about
your audience relevant to them]

We're opening sponsorship spots for Q[X] and I think there could be a
good fit. Our [audience description] are actively looking for solutions
like [their product category].

Worth a conversation?

[Your Name]
```

#### Template 4: The Competitor Mention

```markdown
Subject: How [Competitor] reached [X] data professionals

Hi [Name],

[Competitor] recently sponsored our newsletter and saw [X result].

Given [Company]'s focus on [their focus area], I thought you might be
interested in similar exposure to our [X] subscribers.

We're currently booking for [Month] and have [X] primary spots
remaining.

Would you like to see our media kit?

[Your Name]
```

### Subject Line Best Practices

**DO**:
- Keep under 50 characters
- Be specific and relevant
- Create curiosity
- Mention mutual connections
- Reference their company

**DON'T**:
- Use clickbait
- ALL CAPS or excessive punctuation
- Generic subjects ("Quick question")
- Misleading content

**Examples**:
- ✅ "[Company] + [Publication] sponsorship?"
- ✅ "Reaching [X]k data scientists in LATAM"
- ✅ "Re: your [Product] launch"
- ❌ "AMAZING OPPORTUNITY!!!"
- ❌ "Quick question"
- ❌ "Following up"

## Follow-up Sequences

### The 4-Touch Sequence

#### Touch 1: Initial Outreach (Day 0)
[Use cold email template above]

#### Touch 2: First Follow-up (Day 3)
```markdown
Subject: Re: [Original Subject]

Hi [Name],

Wanted to bump this up in your inbox.

Quick summary: [1-sentence value prop]

If now isn't a good time, just let me know and I'll check back in
[timeframe].

[Your Name]
```

#### Touch 3: Add Value (Day 7)
```markdown
Subject: [Relevant resource] - thought of you

Hi [Name],

Found this [article/report/data] on [topic relevant to them] and
thought you might find it useful:

[Link or brief insight]

Still happy to chat about reaching our [audience] if interesting.

[Your Name]
```

#### Touch 4: Break-up Email (Day 14)
```markdown
Subject: Should I close your file?

Hi [Name],

I haven't heard back, so I'll assume the timing isn't right.

No worries at all - I'll close this out for now.

If things change, just reply and we can pick up where we left off.

Best,
[Your Name]
```

### Response Handling

#### If They Say "Not Now"
```markdown
Totally understand, [Name].

When would be a better time to reconnect? I'll set a reminder and
reach back out then.

In the meantime, I'll add you to our sponsor newsletter so you can
see what we're up to.

Best,
[Your Name]
```

#### If They Ask for More Info
```markdown
Great to hear from you, [Name]!

I've attached our media kit with full details on:
- Audience demographics
- Engagement metrics
- Pricing options
- Past sponsor results

Happy to schedule a call to walk through it and answer questions.
What does your availability look like this week?

[Your Name]
```

#### If They're Interested
```markdown
Excellent, [Name]!

Here's what I suggest as next steps:
1. Quick call to discuss your goals (15-20 min)
2. I'll send a custom proposal based on our conversation
3. We can finalize details and schedule your placement

When works best for a call? I'm flexible [timeframes].

Looking forward to it!

[Your Name]
```

## Negotiation Scripts

### Handling Price Objections

#### "It's too expensive"
```markdown
I understand budget is a consideration. Let me share some context:

Our rates reflect the quality and engagement of our audience.
Sponsors typically see [X]% click-through rates, which translates
to about $[X] per click - quite competitive with paid channels.

A few options:
1. Start with a smaller placement ($[X]) to test
2. Lock in a multi-week package for a volume discount
3. Wait for our next promotional period

What makes the most sense for your situation?
```

#### "We need guaranteed results"
```markdown
I wish I could guarantee specific outcomes - I know that would make
your decision easier.

What I can share is historical data:
- Average sponsor CTR: [X]%
- Typical click volume: [X-Y]
- [X]% of sponsors renew after first campaign

If you'd like, I can connect you with a past sponsor to hear about
their experience directly.
```

#### "Let me think about it"
```markdown
Of course - it's a significant decision.

Would it help if I sent a summary of what we discussed, along with
our media kit for reference?

Also, just so you know, we're currently booking for [Month] and
have [X] spots remaining. No pressure, but wanted to give you the
full picture.

When would be a good time to follow up?
```

#### "We can only pay $[lower amount]"
```markdown
I appreciate you sharing your budget. Let me see what we can do.

At $[lower amount], I could offer:
- [Smaller placement option]
- Or [Alternative option]

Would either of those work? If not, we could discuss a multi-issue
package that would bring the per-placement cost down to your budget.
```

### Asking for the Close

#### Soft Close
```markdown
Based on everything we've discussed, it sounds like [your placement]
would help you reach [their goal].

Should I send over the agreement to lock in your [date] placement?
```

#### Assumptive Close
```markdown
I'll prepare the invoice for [agreed package] with [date] placement.

What email should I send the confirmation to?
```

#### Urgency Close (Use Sparingly, Must Be Real)
```markdown
Just wanted to give you a heads up - we have one [placement type]
spot left for [month] and another advertiser expressed interest
today.

I'd love to give you first choice since we've been talking. Should
I hold it for you until [date]?
```

## Proposal Templates

### Sponsorship Proposal Structure

```markdown
# Sponsorship Proposal

**Prepared for**: [Company Name]
**Date**: [Date]
**Valid until**: [Date + 14 days]

---

## Executive Summary

[Publication Name] reaches [X] engaged [audience type] every
[frequency]. This proposal outlines a sponsorship opportunity to
connect [Company] with our audience of [specific description].

---

## About [Publication Name]

[2-3 sentences about your publication, mission, and unique value]

### Audience Snapshot

| Metric | Value |
|--------|-------|
| Subscribers | [X] |
| Open Rate | [X]% |
| Click Rate | [X]% |
| Primary Audience | [Description] |

---

## Proposed Package

### [Package Name] - $[Price]

**Includes**:
- [X] [placement type] sponsorships
- [Feature 1]
- [Feature 2]
- [Feature 3]

**Schedule**: [Proposed dates]

**Expected Results** (based on historical data):
- Impressions: [X]
- Estimated clicks: [X-Y]
- Estimated CTR: [X]%

---

## Investment & Terms

| Item | Price |
|------|-------|
| [Package Name] | $[X] |
| [Any add-ons] | $[X] |
| **Total** | $[X] |

**Payment Terms**: Net 30 / 50% upfront, 50% upon completion

---

## Next Steps

1. Reply to confirm interest
2. Sign insertion order (attached)
3. Submit creative by [date]
4. Campaign goes live [date]

---

## Questions?

Contact [Your Name]
[Email] | [Phone/Calendar Link]
```

## Professional Communication Guidelines

### Email Best Practices

**Tone**:
- Professional but warm
- Confident but not pushy
- Helpful and solution-focused
- Respectful of their time

**Structure**:
- Short paragraphs (2-3 sentences max)
- Clear CTA (one per email)
- Easy to scan
- Mobile-friendly

**Timing**:
- Tuesday-Thursday optimal
- 9-11 AM in recipient's timezone
- Avoid Mondays and Fridays
- Never weekends (unless they initiated)

### What NOT to Do

❌ Multiple follow-ups in one day
❌ Passive-aggressive language
❌ Guilt-tripping
❌ Lying about urgency or scarcity
❌ Disparaging competitors
❌ Over-promising results
❌ Being unclear about pricing
❌ Ignoring their stated preferences

## CRM & Tracking

### Deal Stages

```markdown
1. Lead - Initial identification
2. Contacted - First outreach sent
3. Engaged - Response received
4. Qualified - Budget/fit confirmed
5. Proposal Sent - Formal proposal shared
6. Negotiation - Terms discussion
7. Closed Won - Agreement signed ✓
8. Closed Lost - Did not proceed ✗
```

### What to Track

For each opportunity:
- Contact name and email
- Company and role
- Source (how they found us/we found them)
- All communication dates
- Deal value
- Current stage
- Next action and date
- Notes from conversations

### Pipeline Health Metrics

| Metric | Healthy Range |
|--------|---------------|
| Leads → Engaged | 20-30% |
| Engaged → Qualified | 40-50% |
| Qualified → Proposal | 60-70% |
| Proposal → Won | 30-50% |
| Overall Win Rate | 10-20% |
| Average Sales Cycle | 2-4 weeks |

## Resources

- [HubSpot Sales Email Templates](https://blog.hubspot.com/sales/sales-email-templates)
- [Close.io Email Templates](https://blog.close.com/sales-email-templates/)
- [Newsletter Glue - Sponsorship Guide](https://newsletterglue.com/blog/build/how-to-monetize-a-newsletter/)
