---
name: scientific-writing
description: Write rigorous scientific manuscripts, research papers, grant proposals, and literature reviews. Use when drafting or revising any part of a scientific document including abstracts, introductions, methods, results, and discussions. Applies IMRAD structure, citation styles (APA/AMA/Vancouver/IEEE), reporting guidelines (CONSORT/STROBE/PRISMA), and publication standards. Triggers on requests to write research papers, journal articles, scientific reports, academic manuscripts, grant applications, or improve scientific prose.
---

# Scientific Writing

Write publication-ready scientific manuscripts using established academic conventions and evidence-based practices.

## Core Principles

### Evidence-Based Claims

Every substantive claim requires support from peer-reviewed literature. Use appropriate hedging: "suggests" for correlational evidence, "demonstrates" for causal evidence. Never assert without citation or data support.

### Clarity Over Flourish

Scientific writing prioritizes precision. Use domain-specific terminology correctly, define terms on first use, prefer active voice in methods, and avoid vague qualifiers ("very significant" → "statistically significant, p < 0.001").

### Reproducibility Standard

Methods must enable replication: include all parameters, software versions, statistical tests, sample sizes, inclusion/exclusion criteria, effect sizes alongside p-values, and relevant reporting guideline compliance.

## Two-Stage Writing Process

**Stage 1: Outline with Evidence**
Create structured outlines with bullet points marking main arguments, key citations, data points, and logical flow. This is scaffolding—not the final manuscript.

**Stage 2: Convert to Prose**
Transform outlines into complete paragraphs with proper transitions, integrated citations, and logical sentence flow. Final manuscripts contain NO bullet points except in specific Methods subsections (inclusion criteria, materials lists).

## Manuscript Structure (IMRAD)

### Abstract
Write as flowing paragraph(s), NOT labeled sections. Cover: (1) context/problem, (2) methods summary, (3) key findings with statistics, (4) significance. Typically 150-300 words. Only use structured format if journal explicitly requires it.

Example structure:
```
[Context sentence establishing importance]. [Gap or problem addressed]. 
[Study objective]. [Methods: design, N, key measures]. [Primary result with 
statistics]. [Secondary findings]. [Conclusion and implications].
```

### Introduction
Follow funnel structure:
1. Broad context (1-2 paragraphs): field importance
2. Literature review (2-4 paragraphs): what is known, organized thematically
3. Gap identification (1 paragraph): what remains unknown
4. Present study (1 paragraph): objectives, hypotheses, approach

### Methods
Standard subsections:
- **Participants/Subjects**: demographics, recruitment, ethics approval
- **Materials/Stimuli**: detailed descriptions, validated instrument citations
- **Procedure**: chronological protocol with timing
- **Data Analysis**: statistical approach, software, multiple comparison corrections

Include power analysis. Report all conditions. Enable replication.

### Results
Structure: (1) preliminary analyses, (2) primary hypotheses, (3) secondary/exploratory (labeled).

Report consistently:
- Descriptive: M ± SD or Mdn (IQR)
- Inferential with effect sizes: "t(48) = 2.31, p = .025, d = 0.67"
- Confidence intervals when possible

No interpretation here—save for Discussion.

### Discussion
Structure: (1) summary without statistics, (2) interpretation in literature context, (3) limitations, (4) implications, (5) future directions, (6) conclusion.

Address alternative explanations. Avoid overclaiming.

## Citation Practices

### Source Hierarchy
1. Systematic reviews/meta-analyses (strongest synthesis)
2. Randomized controlled trials (causal inference)
3. Prospective cohort studies (temporal precedence)
4. Cross-sectional studies (associations)
5. Case studies/expert opinion (hypothesis-generating)

### Best Practices
- Cite primary sources, not secondary summaries
- Balance recent work (last 5 years) with foundational papers
- Verify claims against original sources
- Flag contradictory evidence rather than omitting it
- Self-citations <20%

For detailed citation formatting by style, see [references/citation_styles.md](references/citation_styles.md).

## Reporting Guidelines

Match guideline to study type:
- **CONSORT**: Randomized controlled trials
- **STROBE**: Observational studies (cohort, case-control, cross-sectional)
- **PRISMA**: Systematic reviews and meta-analyses
- **STARD**: Diagnostic accuracy studies
- **TRIPOD**: Prediction models
- **ARRIVE**: Animal research
- **CARE**: Case reports

For checklists and details, see [references/reporting_guidelines.md](references/reporting_guidelines.md).

## Writing Style

### Verb Tense
| Section | Tense |
|---------|-------|
| Introduction (established facts) | Present |
| Introduction (prior studies) | Past |
| Methods | Past |
| Results | Past |
| Discussion (your findings) | Past |
| Discussion (interpretations) | Present |
| Conclusions | Present |

### Common Errors
| Error | Correction |
|-------|------------|
| "Data shows..." | "Data show..." (plural) |
| "Proves that..." | "Suggests/demonstrates that..." |
| "Significant" (colloquial) | "Substantial" or "statistically significant" |
| "In order to" | "To" |
| "Due to the fact that" | "Because" |

### Paragraph Structure
- Open with topic sentence stating main point
- Provide evidence and elaboration
- Connect logically to next paragraph
- Typical length: 4-8 sentences

## Field-Specific Conventions

### Biomedical/Clinical
- Use precise anatomical/clinical terminology
- Follow standardized nomenclature (ICD, DSM, SNOMED-CT)
- Generic drug names first, brands in parentheses
- "Patients" for clinical, "participants" for community research

### Molecular Biology
- Gene symbols italicized (*TP53*), proteins regular (p53)
- Species-specific: human uppercase (*BRCA1*), mouse sentence case (*Brca1*)
- Full species name first, then abbreviation (*Escherichia coli* → *E. coli*)

### Chemistry
- IUPAC nomenclature for compounds
- Concentrations with units (mM, μM, nM)
- Standard notation (SMILES, InChI)

For comprehensive field conventions, see [references/field_conventions.md](references/field_conventions.md).

## Figures and Tables

### When to Use Which
- **Tables**: Precise numerical data, exact values needed
- **Figures**: Trends, patterns, relationships, visual comparisons

### Requirements
- Self-explanatory with complete captions
- Consistent formatting and terminology
- All axes/columns labeled with units
- Sample sizes (n) and statistical annotations
- No duplication between text, tables, and figures

For detailed guidance, see [references/figures_tables.md](references/figures_tables.md).

## Workflow Summary

**Stage 1: Planning**
1. Identify target journal, review author guidelines
2. Determine applicable reporting guideline
3. Outline manuscript structure
4. Plan figures/tables as data story backbone

**Stage 2: Drafting**
1. Start with figures/tables
2. Draft Methods first (easiest)
3. Write Results (describe figures/tables)
4. Compose Discussion (interpret findings)
5. Write Introduction (set up research question)
6. Craft Abstract last (summarize complete work)

**Stage 3: Revision**
1. Check logical flow throughout
2. Verify terminology consistency
3. Confirm reporting guideline adherence
4. Verify all citations accurate
5. Proofread for clarity

## Pre-Submission Checklist

- [ ] Abstract accurately reflects content (written as prose, not labeled sections)
- [ ] All claims have citations or data support
- [ ] Methods enable replication
- [ ] Statistics include effect sizes and CIs
- [ ] Figures have informative captions
- [ ] References follow target journal style
- [ ] Reporting guideline checklist completed
- [ ] Word count within limits
- [ ] Author contributions and conflicts declared
