---
name: SECI-GRAI Knowledge Creation
description: This skill should be used when the user asks about "SECI model", "knowledge creation cycle", "tacit vs explicit knowledge", "knowledge conversion", "GRAI framework", "human-AI knowledge collaboration", "socialization externalization combination internalization", "knowledge spiral", "what phase of knowledge creation", or needs to understand which phase of knowledge work a task involves. Provides the theoretical foundation for knowledge management across all contexts.
version: 0.1.0
---

# SECI-GRAI Knowledge Creation Framework

This skill provides the theoretical foundation for understanding knowledge creation cycles, particularly in human-AI collaboration contexts. It integrates Nonaka and Takeuchi's SECI model with the modern GRAI (Generative, Receptive AI) extension.

## Core Concept: Knowledge Types

All knowledge exists on a spectrum between two forms:

| Type | Nature | Example | Transfer Method |
|------|--------|---------|-----------------|
| **Tacit** | Personal, experiential, hard to articulate | "Knowing how to ride a bike" | Observation, practice, shared experience |
| **Explicit** | Codified, documented, easily shared | "Instructions for assembling furniture" | Documents, databases, specifications |

The creation of new organizational knowledge occurs through continuous conversion between these types.

## The SECI Model: Four Conversion Modes

Knowledge creation follows a spiral through four modes:

### 1. Socialization (Tacit → Tacit)

**What it is:** Sharing tacit knowledge through shared experiences, observation, imitation, and practice.

**Indicators present phase is Socialization:**
- Learning by watching someone work
- Pair programming or shadowing
- Informal knowledge transfer ("let me show you how")
- Building shared mental models through collaboration
- Apprenticeship-style learning

**Key activities:**
- Joint problem-solving sessions
- Collaborative exploration of a domain
- Sharing war stories and experiences
- Building rapport and shared understanding

**AI-Human pattern (GRAI):**
- Human→AI: Iterative prompting with rich contextual information
- AI→Human: Explaining topics, demonstrating approaches, walking through reasoning

### 2. Externalization (Tacit → Explicit)

**What it is:** Articulating tacit knowledge into explicit concepts—the most critical and difficult conversion.

**Indicators present phase is Externalization:**
- Documenting how something works
- Writing specifications from understanding
- Creating diagrams, models, or frameworks
- Explaining "why" decisions were made
- Converting intuition into guidelines

**Key activities:**
- Writing documentation from experience
- Creating product specifications
- Defining processes and workflows
- Building conceptual models
- Articulating design rationale

**AI-Human pattern (GRAI):**
- Human→AI: Adding materials via memory/context to refine understanding
- AI→Human: Converting unstructured knowledge into structured formats

### 3. Combination (Explicit → Explicit)

**What it is:** Combining, categorizing, and systematizing explicit knowledge into new forms.

**Indicators present phase is Combination:**
- Synthesizing multiple documents
- Building knowledge bases or wikis
- Creating summaries from various sources
- Restructuring existing documentation
- Cross-referencing and linking concepts

**Key activities:**
- Merging multiple specifications
- Creating comprehensive guides from fragments
- Building taxonomies and categorizations
- Generating reports and dashboards
- Systematizing best practices

**AI-Human pattern (GRAI):**
- Human→AI: Using AI creatively to combine unlikely patterns
- AI→Human: Generating summaries, meeting protocols, synthesis documents

### 4. Internalization (Explicit → Tacit)

**What it is:** Embodying explicit knowledge through learning-by-doing until it becomes tacit.

**Indicators present phase is Internalization:**
- Learning from documentation
- Practicing new skills
- Applying guidelines in real situations
- Building muscle memory and intuition
- "Making it your own"

**Key activities:**
- Hands-on practice with documented procedures
- Simulations and exercises
- Applying patterns to new contexts
- Building intuition through repetition
- Developing personal heuristics

**AI-Human pattern (GRAI):**
- Human→AI: AI observing patterns to suggest timely support
- AI→Human: Supporting human understanding, creating practice exercises

## The Knowledge Spiral

Knowledge creation is not linear but spiral—each cycle builds on the previous:

```
        Socialization ──────► Externalization
              ▲                      │
              │                      ▼
              │    KNOWLEDGE         │
              │      SPIRAL          │
              │                      │
        Internalization ◄────── Combination
              │                      ▲
              └──────────────────────┘
                   (next cycle)
```

**Spiral dynamics:**
- Each cycle expands the knowledge base
- Individual knowledge becomes team knowledge becomes organizational knowledge
- The spiral moves through different social levels (individual → group → organization)

## GRAI: The AI Extension

The GRAI framework (Generative, Receptive AI) extends SECI for human-AI collaboration by recognizing AI as an active participant in knowledge creation.

### Eight Interaction Fields

GRAI doubles the SECI phases by adding direction (human↔machine):

| Phase | Human → Machine | Machine → Human |
|-------|-----------------|-----------------|
| **Socialization** | Iterative prompting with context | Explaining, demonstrating, walking through |
| **Externalization** | Providing materials to refine AI context | Structuring unstructured information |
| **Combination** | Creative pattern mixing with AI | Generating summaries, protocols, syntheses |
| **Internalization** | AI observing patterns for support | Creating exercises, supporting understanding |

### Human-Centered Design

GRAI maintains human agency through two configurations:

- **Human-in-the-loop:** Human makes decisions, AI augments capability
- **Machine-in-the-loop:** AI handles routine work, human provides oversight

The framework preserves human decision-making authority while leveraging AI for knowledge work amplification.

## Phase Identification Quick Reference

To identify the current phase, ask:

| Question | If Yes → Phase |
|----------|----------------|
| Am I learning by watching/doing with others? | Socialization |
| Am I trying to articulate something I understand but haven't documented? | Externalization |
| Am I combining or restructuring existing documented knowledge? | Combination |
| Am I learning from documentation to build new skills? | Internalization |

## Applying SECI-GRAI

### For Documentation Work

| Task | Primary Phase | AI Role |
|------|---------------|---------|
| Writing specs from understanding | Externalization | Structure tacit insights |
| Synthesizing multiple docs | Combination | Merge and systematize |
| Reviewing to learn patterns | Internalization | Create practice scenarios |
| Collaborative exploration | Socialization | Explain and demonstrate |

### For Product Development

| Stage | Phase | Knowledge Activity |
|-------|-------|-------------------|
| Discovery | Socialization | Shared exploration with stakeholders |
| Requirements | Externalization | Documenting needs and constraints |
| Design | Combination | Synthesizing patterns and solutions |
| Implementation | Internalization | Applying documented designs |

### Phase Transition Triggers

Moving between phases often requires deliberate action:

| From → To | Trigger |
|-----------|---------|
| S → E | "Let me write this down" |
| E → C | "Let me combine these sources" |
| C → I | "Let me practice this" |
| I → S | "Let me share what I learned" |

## Common Pitfalls

**Skipping Externalization:** Trying to combine knowledge that hasn't been articulated yet results in shallow synthesis.

**Premature Combination:** Combining sources before deeply understanding them produces surface-level results.

**Neglecting Socialization:** Pure documentation without shared experience lacks the tacit context that makes knowledge actionable.

**Incomplete Internalization:** Reading without practice leaves knowledge as information, not capability.

## Additional Resources

### Reference Files

For detailed theory and advanced applications, consult:

- **`references/seci-deep-dive.md`** - Complete Nonaka & Takeuchi theory with academic foundations
- **`references/grai-framework.md`** - Full GRAI framework details and interaction patterns
- **`references/phase-transitions.md`** - Techniques for facilitating movement between phases

### Example Files

Working examples in `examples/`:

- **`phase-identification-examples.md`** - Real-world scenarios with phase analysis

## Integration with Other Skills

This skill provides the theoretical foundation. Related skills in knowledge-manager:

- **ba-contexts** - Enabling contexts for each SECI phase
- **knowledge-assets** - Types of knowledge artifacts to create
- **extension-interface** - Patterns for tool-specific implementations

Tool-specific plugins (e.g., km-notion, km-obsidian) extend these foundations with platform-specific patterns.
