# Phase Identification Examples

Real-world scenarios demonstrating how to identify SECI phases and apply appropriate approaches.

## Example 1: Product Specification Work

**Scenario:** A product manager has deep understanding of customer needs from weeks of interviews but hasn't documented them yet.

**Phase Identification:**
- Has tacit knowledge from customer interactions ✓
- Needs to articulate into explicit form ✓
- **Primary Phase: Externalization (Tacit → Explicit)**

**Appropriate Approach:**
1. Use metaphor elicitation: "What is the customer's problem like?"
2. Progressive articulation: Start with informal notes, refine to structured spec
3. AI-assisted structuring: "Help me convert these interview notes into a requirements document"

**GRAI Field:** Externalization M→H (AI structures unstructured insights)

---

## Example 2: Documentation Synthesis

**Scenario:** A team has multiple scattered documents about the authentication system—architecture notes, API docs, security guidelines—that need to become a unified guide.

**Phase Identification:**
- Multiple explicit sources exist ✓
- Need to combine into new explicit form ✓
- **Primary Phase: Combination (Explicit → Explicit)**

**Appropriate Approach:**
1. Cross-reference mapping: Identify relationships between documents
2. Gap analysis: What's missing? What contradicts?
3. AI-assisted synthesis: "Combine these sources into a unified guide"

**GRAI Field:** Combination M→H (AI generates synthesis)

---

## Example 3: Onboarding New Developer

**Scenario:** A senior developer needs to transfer knowledge about the codebase architecture to a new team member who has read the documentation.

**Phase Identification:**
- Senior has tacit knowledge (experience, intuitions)
- New dev has explicit knowledge (read docs)
- Need to transfer tacit through shared experience ✓
- **Primary Phase: Socialization (Tacit → Tacit)**

**Appropriate Approach:**
1. Pair programming sessions
2. Code review walkthroughs with thinking-aloud
3. War stories about past challenges

**GRAI Field:** Not primarily AI-driven; human-human socialization. AI can support by generating discussion topics or scenarios.

---

## Example 4: Learning from Architecture Documentation

**Scenario:** A developer needs to understand the event-driven architecture documented in the wiki well enough to implement a new feature.

**Phase Identification:**
- Has explicit knowledge (documentation) ✓
- Needs tacit capability (intuitive implementation) ✓
- **Primary Phase: Internalization (Explicit → Tacit)**

**Appropriate Approach:**
1. Progressive practice: Start with simple implementations
2. Scenario-based learning: Work through realistic examples
3. Reflection cycles: Practice → document challenges → consult docs → retry

**GRAI Field:** Internalization M→H (AI creates exercises, supports learning)

---

## Example 5: Mixed Phase - Feature Development

**Scenario:** Building a new notification system. The team understands what users need (tacit from research) but hasn't specified it, and will need to integrate with existing messaging architecture.

**Phase Analysis:**
- User needs are tacit (from research) → needs **Externalization**
- Integration with existing docs → needs **Combination**
- Implementation will require → **Internalization** of combined knowledge

**Multi-Phase Approach:**
```
Week 1: Externalization Sprint
- Document user requirements
- Articulate notification patterns
- Create initial specification

Week 2: Combination Sprint
- Integrate with messaging architecture docs
- Resolve conflicts with existing patterns
- Create unified technical design

Week 3: Internalization Sprint
- Implement against specification
- Practice patterns through coding
- Build intuitive understanding
```

---

## Example 6: Post-Incident Knowledge Capture

**Scenario:** The team just resolved a complex production incident. Multiple people have tacit knowledge of what happened and how they fixed it.

**Phase Identification:**
- Multiple people have tacit knowledge ✓
- Need to preserve as explicit knowledge ✓
- **Primary Phase: Externalization**, preceded by brief **Socialization**

**Appropriate Approach:**
1. **Socialization** (30 min): Group debrief to surface all perspectives
2. **Externalization** (2 hours): Structured post-mortem documentation
3. **Combination** (1 hour): Integrate learnings into runbooks

**AI-Assisted Post-Mortem:**
```
"Based on this timeline of events and our discussion notes,
help structure this into a post-mortem document with:
- Timeline
- Root cause analysis
- What went well
- What could improve
- Action items"
```

---

## Example 7: Cross-Team Knowledge Transfer

**Scenario:** The platform team developed a new deployment system. Now application teams need to adopt it.

**Phase Analysis:**

**For Platform Team (source):**
- Have tacit expertise
- Need to externalize for transfer
- **Phase: Externalization**

**For Application Teams (receivers):**
- Will receive explicit knowledge
- Need to internalize through practice
- **Phase: Internalization**

**Approach:**
```
Platform Team:
1. Document deployment patterns (Externalization)
2. Create training materials (Combination)
3. Provide hands-on workshops (Socialization bridge)

Application Teams:
1. Study documentation (Combination → Internalization)
2. Practice in staging (Internalization)
3. Pair with platform team on first production deploy (Socialization)
```

---

## Quick Reference: Phase Identification

| Situation | Likely Phase |
|-----------|--------------|
| "I understand it but can't explain it" | Externalization needed |
| "We have docs everywhere but no unified view" | Combination needed |
| "I've read it but can't do it" | Internalization needed |
| "Let me show you how I do this" | Socialization happening |
| "We need to document this" | Externalization starting |
| "Let's merge these guides" | Combination starting |
| "Time to practice" | Internalization starting |
| "Watch how I approach this" | Socialization starting |

---

## Anti-Patterns

### Skipping Externalization

**Symptom:** Trying to combine knowledge that hasn't been articulated.

**Example:** "Let's just add to the wiki" when no one has written down what they know.

**Fix:** First externalize individual knowledge, then combine.

### Premature Combination

**Symptom:** Synthesizing documents without understanding them.

**Example:** Merging specs mechanically without grasping the concepts.

**Fix:** Internalize each source before combining.

### Socialization Without Externalization

**Symptom:** Knowledge stays tacit, never captured.

**Example:** Team "knows" how things work but new members can't learn.

**Fix:** Follow socialization with externalization sessions.

### Documentation Without Internalization

**Symptom:** Beautiful docs that no one can apply.

**Example:** Comprehensive wiki that doesn't improve team capability.

**Fix:** Pair documentation with practice exercises.
