---
name: security-management
description: Manage security policies and access controls for Protect surveillance. Monitor access to recordings and system settings to ensure only authorized personnel have appropriate access.
---

# Security Management Skill

Manage access controls and security policies for your Protect surveillance system.

## What this skill does

This skill enables you to:
- Review system access controls and user permissions
- Monitor surveillance system security configuration
- Verify access to sensitive recordings and events
- Manage secure remote access to cameras
- Audit system access logs
- Implement least-privilege access models

## When to use this skill

Use this skill when you need to:
- Review who has access to the Protect system
- Audit surveillance recordings access
- Verify authentication and authorization settings
- Plan access control policies
- Troubleshoot access-related issues
- Generate access audit reports

## Available Tools

- `get_protect_info` - Get system security information
- `get_protect_devices` - Verify device security status

## Typical Workflows

### Access Audit
1. Use `get_protect_info` to review system configuration
2. Check who has system access
3. Verify recording access controls
4. Review authentication methods
5. Generate audit report

### Security Configuration Review
1. Check system security settings
2. Verify encrypted connections
3. Review user permissions
4. Assess physical security controls
5. Document findings

### Incident Investigation
1. Review event logs for unauthorized access
2. Check authentication failures
3. Verify recording integrity
4. Document timeline
5. Provide recommendations

## Example Questions

- "Who has access to the Protect system?"
- "Audit surveillance system access"
- "Verify recording access controls"
- "Check system authentication settings"
- "Generate a security configuration report"

## Response Format

When using this skill, I provide:
- Access control configuration details
- User permission summary
- Authentication method details
- Recording access restrictions
- Security assessment findings
- Compliance status
- Specific recommendations for improvements

## Best Practices

- Regularly audit system access
- Implement principle of least privilege
- Use strong authentication
- Monitor access logs
- Document access policies
- Review permissions quarterly
- Archive audit logs
- Implement role-based access control
