---
name: self-critique-writer
description: This skill should be used when the user asks to "write with self-critique", "critique and rewrite", "improve this draft", "write in my voice with iteration", or wants content generation that loops through draft/critique/rewrite until quality threshold is met.
version: 1.0.0
---

# Self-Critique Voice Writer

Generate content that matches your voice through iterative self-critique. Draft, score, critique, rewrite - repeat until the output is genuinely good.

## The Problem with One-Shot Generation

Single-pass AI content is often:
- Generic and forgettable
- Missing your authentic voice
- "Good enough" but not great
- Obviously AI-generated

## The Self-Critique Loop

```
[Voice Profile] → Draft → Score → Critique → Rewrite
                           ↑                    │
                           └────────────────────┘
                          (loop until score > 8)
```

## How to Use

### Basic Usage

```
/critique-write [content type] about [topic]
```

Example:
```
/critique-write linkedin post about the importance of code reviews
```

### With Voice Reference

```
/critique-write twitter thread about AI agents, matching the voice from my recent posts
```

### With Specific Critique Focus

```
/critique-write blog intro about remote work, focus critique on engagement and authenticity
```

## The Critique Dimensions

Each draft is scored 1-10 on five dimensions:

### 1. Voice Match (Does it sound like me?)
- Vocabulary alignment with profile
- Sentence rhythm matching
- Personality markers present
- Avoids words on "never use" list

### 2. Clarity (Is it understandable?)
- Main point obvious within 3 seconds
- No jargon without context
- Logical flow between ideas
- Appropriate complexity for audience

### 3. Engagement (Will people read this?)
- Hook strength (first line)
- Tension or curiosity created
- Momentum maintained
- Satisfying resolution/CTA

### 4. Authenticity (Does it feel real?)
- Specific over generic
- Personal experience woven in
- Honest about tradeoffs
- Not "trying too hard"

### 5. Purpose Alignment (Does it achieve the goal?)
- Clear intended outcome
- Right audience targeted
- Action prompted if applicable
- No mixed messages

## Example Session

**User**: `/critique-write linkedin post about why I stopped using to-do lists`

**Draft 1**:
> I stopped using to-do lists 6 months ago. Here's what happened.
>
> I used to be a to-do list fanatic. Multiple apps, color coding, priority levels.
> But I realized I was spending more time managing my lists than doing the work.
>
> Now I use a simple rule: If it matters, I do it now. If it can wait, I write it on a sticky note.
> The sticky notes pile up. That's fine. Most of them become irrelevant before I get to them.
>
> Sometimes the best productivity system is no system at all.

**Self-Critique**:
| Dimension | Score | Notes |
|-----------|-------|-------|
| Voice Match | 6 | Too polished, missing your casual asides |
| Clarity | 8 | Clear message, easy to follow |
| Engagement | 5 | Hook is weak, "here's what happened" is overused |
| Authenticity | 6 | Generic advice, needs specific example |
| Purpose | 7 | Makes point but no discussion prompt |

**Overall: 6.4** - Needs work on hook and authenticity.

**Draft 2**:
> My to-do list app sent me a "you haven't logged in for 180 days" email.
>
> I smiled.
>
> I was a to-do list addict. Todoist, Things, Notion databases with 47 properties.
> Then I noticed: my most productive days were when I forgot to check the list.
>
> Now I use sticky notes. Physical ones. They fall behind my desk and disappear.
> That's the feature, not a bug. If something mattered, I would have done it already.
>
> Controversial take: most "productivity" is just elaborate procrastination.
>
> What's your relationship with to-do lists? Healthy or complicated?

**Self-Critique**:
| Dimension | Score | Notes |
|-----------|-------|-------|
| Voice Match | 8 | Better casual tone, includes humor |
| Clarity | 9 | Very clear, builds logically |
| Engagement | 9 | Strong hook, curiosity created |
| Authenticity | 8 | Specific detail (47 properties), honest |
| Purpose | 9 | Ends with discussion prompt |

**Overall: 8.6** - Above threshold, ready to publish.

## Configuration

### Set Quality Threshold

Default threshold is 8.0. Adjust per task:

```
/critique-write blog post about X --threshold 9
```

### Set Max Iterations

Prevent infinite loops:

```
/critique-write email about Y --max-rewrites 5
```

### Focus on Specific Dimensions

```
/critique-write tweet about Z --focus engagement,voice
```

## Voice Profile Integration

This skill works best with an established voice profile. If you don't have one:

1. Run `/learn-voice` first with sample content
2. Or provide examples in your request

## Critique Explanations

Each critique includes:
- **What's working** - Don't lose these elements
- **What's weak** - Specific problems identified
- **How to fix** - Actionable rewrite guidance

## Advanced: Custom Critique Dimensions

For specialized content, add dimensions:

```
/critique-write technical tutorial --add-dimension "Accuracy: Are all code examples correct?"
```

## When to Override

Sometimes you want draft 1 even if it scores low:
- Time pressure
- Draft is intentionally different
- You'll edit heavily anyway

Just say: "Use draft 1, I'll edit it myself"

## Credits

Inspired by [@koylanai](https://x.com/koylanai/status/2008824728824451098)'s "Ralph Wiggum Copywriter" - the insight that self-critique loops produce dramatically better output than single-pass generation.
