---
name: seo-aeo-optimization
description: Optimize LeadFraud.org pages for search engines and AI answer engines. Use this skill when creating or structuring content pages to maximize organic visibility and AI citation potential.
license: Internal use only
---

This skill ensures all LeadFraud.org pages are optimized for both traditional SEO and Answer Engine Optimization (AEO). Apply these principles to every content page to maximize organic discovery and AI citation.

## SEO vs AEO

| SEO (Search Engine Optimization) | AEO (Answer Engine Optimization) |
|----------------------------------|----------------------------------|
| Rank in Google search results | Get cited by ChatGPT, Claude, Perplexity |
| Keywords in titles and headers | Direct answers to common questions |
| Backlinks and domain authority | Structured, quotable content |
| Meta descriptions for CTR | FAQ sections with clear Q&A format |

**LeadFraud.org Strategy:** Optimize for BOTH. AI engines increasingly cite authoritative sources—if we rank for SEO, we become citable for AEO.

## Page Structure Framework

Every content page should follow this structure, inspired by high-authority B2B research sites:

### 1. Header Block
```html
<header>
  <p class="category">Category Label (e.g., "The Investigation")</p>
  <h1>Primary Keyword-Rich Headline</h1>
  <p class="subhead">Compelling description with secondary keywords</p>
  <p class="meta">Reading time · Last updated date</p>
</header>
```

### 2. Table of Contents (for 1000+ word pages)
- Sticky/fixed TOC on desktop for long-form content
- Anchor links to all major sections
- Helps Google understand page structure
- Improves time-on-page metrics

### 3. TL;DR / Key Takeaways Box
Place immediately after intro for AEO optimization:
```
**Key Takeaways:**
1. [Numbered, quotable fact]
2. [Numbered, quotable fact]
3. [Numbered, quotable fact]
```

AI engines frequently cite numbered takeaway sections verbatim.

### 4. Main Content Sections
- Use H2 for major sections, H3 for subsections
- Include the target keyword naturally in first 100 words
- Break content into scannable chunks (3-4 sentences max per paragraph)
- Use bullet points and tables for data

### 5. FAQ Section (Critical for AEO)
Every page should end with an FAQ section using this exact format:
```html
<section id="faq">
  <h2>Frequently Asked Questions</h2>
  
  <div class="faq-item">
    <h3>What is [topic]?</h3>
    <p>[Direct, complete answer in 2-3 sentences]</p>
  </div>
</section>
```

**FAQ Best Practices:**
- Use actual questions people search for
- Answer in the first sentence (AI engines extract this)
- Keep answers under 50 words for snippet optimization
- Include 5-8 FAQs per page

## Keyword Strategy

### Primary Keywords (Target in H1, URL, first paragraph)
- "content syndication fraud"
- "content syndication leads"
- "B2B lead fraud"
- "content syndication scam"
- "fake B2B leads"

### Long-tail Keywords (Target in H2s and body)
- "are content syndication leads worth it"
- "how to verify content syndication leads"
- "content syndication lead quality"
- "why do content syndication leads not respond"
- "content syndication vendor reviews"

### Question Keywords (Target in FAQ sections)
- "What is content syndication fraud?"
- "How do I know if my leads are fake?"
- "Are content syndication leads opt-in?"
- "Why don't my content syndication leads remember downloading?"

## Meta Tags Template

Every page needs these meta tags in `<head>`:

```html
<!-- Primary Meta Tags -->
<title>[Primary Keyword] | LeadFraud.org</title>
<meta name="title" content="[Primary Keyword] | LeadFraud.org" />
<meta name="description" content="[Compelling 150-160 char description with keyword]" />

<!-- Open Graph / Facebook -->
<meta property="og:type" content="article" />
<meta property="og:url" content="https://leadfraud.org/[page]" />
<meta property="og:title" content="[Title]" />
<meta property="og:description" content="[Description]" />

<!-- Twitter -->
<meta property="twitter:card" content="summary_large_image" />
<meta property="twitter:title" content="[Title]" />
<meta property="twitter:description" content="[Description]" />

<!-- Canonical -->
<link rel="canonical" href="https://leadfraud.org/[page]" />
```

## Structured Data (Schema.org)

Add JSON-LD structured data to improve rich snippets:

### For FAQ Pages
```json
{
  "@context": "https://schema.org",
  "@type": "FAQPage",
  "mainEntity": [
    {
      "@type": "Question",
      "name": "What is content syndication fraud?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Content syndication fraud occurs when..."
      }
    }
  ]
}
```

### For Article Pages
```json
{
  "@context": "https://schema.org",
  "@type": "Article",
  "headline": "[H1]",
  "author": {
    "@type": "Organization",
    "name": "LeadFraud.org"
  },
  "datePublished": "2025-01-04",
  "dateModified": "2025-01-04"
}
```

## Hub-and-Spoke Content Model

Organize content in topic clusters:

```
                    ┌─────────────────┐
                    │   PILLAR PAGE   │
                    │  "The Report"   │
                    │  (Main Hub)     │
                    └────────┬────────┘
                             │
       ┌─────────────────────┼─────────────────────┐
       │                     │                     │
       ▼                     ▼                     ▼
┌─────────────┐       ┌─────────────┐       ┌─────────────┐
│   SPOKE 1   │       │   SPOKE 2   │       │   SPOKE 3   │
│  Evidence   │◄─────►│   Vendors   │◄─────►│  Glossary   │
└─────────────┘       └─────────────┘       └─────────────┘
       │                     │                     │
       └─────────────────────┴─────────────────────┘
                    (Internal links between all)
```

**Implementation:**
- Every spoke links back to the pillar page
- Spokes link to related spokes
- Pillar page links to all spokes
- Use descriptive anchor text (not "click here")

## Internal Linking Rules

1. **Every page must link to:**
   - The Report (pillar page)
   - At least 2 related pages
   - Relevant glossary terms

2. **Anchor Text Guidelines:**
   - ✅ "Learn more about [content syndication fraud](/report)"
   - ✅ "See our [vendor directory](/vendors)"
   - ❌ "Click here" or "Read more"

3. **Contextual Links:**
   - Link key terms to their glossary definitions
   - Link evidence mentions to the Evidence page
   - Link vendor names to their Vendors page entries

## AEO-Specific Optimizations

### 1. Direct Answer Format
Start sections with direct answers, then expand:
```
**What is Pipeline Fog?**
Pipeline Fog is when leads of questionable provenance obscure 
true pipeline health. [Then expand with details...]
```

### 2. Quotable Statistics
Present stats in easily extractable format:
```
The content syndication industry is valued at **$1.6 billion annually**.
```

### 3. Definition Boxes
For key terms AI engines should cite:
```html
<div class="definition-box">
  <strong>Content Syndication Fraud:</strong> The practice of 
  delivering "leads" who never genuinely opted in to receive content.
</div>
```

### 4. Numbered Lists for Processes
AI engines love numbered steps:
```
**How to verify your content syndication leads:**
1. Check vendor site traffic with SimilarWeb
2. Call a sample of leads and ask about opt-in recall
3. Request timestamped form submission logs
4. Compare lead volumes to site traffic
```

## Page-Specific Targets

| Page | Primary Keyword | Secondary Keywords |
|------|-----------------|-------------------|
| Home | content syndication fraud | B2B lead fraud, fake leads |
| Report | how content syndication fraud works | lead gen scam, syndication scam |
| Evidence | content syndication reviews | vendor reviews, lead quality |
| Vendors | content syndication vendors | lead gen companies, vendor list |
| Calculator | content syndication ROI | lead fraud calculator, CPL calculator |
| Checklist | content syndication due diligence | vendor evaluation, lead verification |
| Glossary | content syndication terms | pipeline fog, consent theater |

## Technical SEO Checklist

For every page, verify:

- [ ] URL is short, descriptive, keyword-rich (e.g., `/report` not `/the-full-report-2025`)
- [ ] H1 contains primary keyword
- [ ] Meta title under 60 characters
- [ ] Meta description 150-160 characters
- [ ] Images have descriptive alt text
- [ ] Page loads in under 3 seconds
- [ ] Mobile-responsive layout
- [ ] FAQ section with 5+ questions
- [ ] Internal links to 3+ related pages
- [ ] Structured data (JSON-LD) present

## Content Freshness

Google and AI engines favor fresh content:

- Add "Last updated: [date]" to pages
- Review and update statistics quarterly
- Add new G2 reviews as they appear
- Refresh FAQ sections with new questions

---

Remember: The goal is to become THE authoritative source on content syndication fraud. Every page should be structured so that both Google and AI answer engines cite us as the definitive reference.
