# E-E-A-T 準拠チェックリスト

GoogleのE-E-A-T（Experience, Expertise, Authoritativeness, Trustworthiness）に準拠した記事を書くためのチェックリスト。

## Experience（経験）

実際に製品を使用した経験を示す要素:

| チェック項目       | 必須 | 例                            |
| :----------------- | :--: | :---------------------------- |
| 使用期間を明記     |  ✅  | 「7ヶ月使用」                 |
| 購入時期を記載     |  ✅  | 「5月に購入」                 |
| 具体的な使用シーン |  ✅  | 「デスクワーク中のBGM再生」   |
| 他製品との比較経験 |  ○   | 「Apple Watchからの買い替え」 |
| 使用頻度           |  ○   | 「毎日使用」「週末のみ」      |

**良い例:**

> **購入時期**: 5月 / **使用期間**: 7ヶ月 / **価格**: 約¥19,800

## Expertise（専門性）

製品カテゴリに関する知識を示す要素:

| チェック項目           | 必須 | 例                               |
| :--------------------- | :--: | :------------------------------- |
| 技術的な説明           |  ✅  | 「LDAC対応でハイレゾ相当の音質」 |
| 仕様の正確な記載       |  ✅  | 「66W RMS出力」                  |
| 専門用語の適切な使用   |  ○   | 「MIL-STD-810準拠」              |
| カテゴリ内での位置付け |  ○   | 「2万円台では最高クラス」        |

**注意:** 専門用語を使う場合は、一般読者にも分かるよう補足説明を入れる。

## Authoritativeness（権威性）

第三者による評価や客観的な根拠:

| チェック項目         | 必須 | 例                           |
| :------------------- | :--: | :--------------------------- |
| 受賞歴               |  ○   | 「VGP2025金賞受賞」          |
| 公式スペック引用     |  ✅  | メーカー公式サイトからの引用 |
| 外部レビューへの言及 |  ○   | 「多くのレビューで高評価」   |
| 認証・規格への準拠   |  ○   | 「PSE認証取得」              |

**ハルシネーション防止:**

- 受賞歴は必ず公式サイトで確認
- スペック数値はメーカー公式ページと照合
- 不確かな情報は記載しない

## Trustworthiness（信頼性）

読者の信頼を得るための誠実さ:

| チェック項目       | 必須 | 例                           |
| :----------------- | :--: | :--------------------------- |
| デメリットの記載   |  ✅  | 「背面のみの操作がやや不便」 |
| 注意点の明示       |  ✅  | 「完全防水ではない」         |
| 価格の透明性       |  ✅  | 正確な価格と変動の可能性     |
| アフィリエイト開示 |  ✅  | PRバッジ表示                 |
| 偏りのない評価     |  ✅  | メリット・デメリット両方     |

**デメリット記載のコツ:**

- 2-3点に絞る
- 致命的でないものは「注意点」として記載
- 代替案や対処法も併記

## チェックリストまとめ

記事公開前に確認:

```text
□ 使用期間・購入時期を明記
□ 具体的な使用シーンを記載
□ 技術的説明が正確
□ 受賞歴・スペックを公式で確認
□ デメリット・注意点を2-3点記載
□ 価格情報が最新
□ アフィリエイト表示あり
```
