# Keyword Research (2026)

**Finding and prioritizing keywords for SEO/GEO.**

## Keyword Types

| Type | Words | Volume | Difficulty | Example |
|------|-------|--------|------------|---------|
| **Short-tail** | 1-2 | High | Very High | "SEO" |
| **Mid-tail** | 2-3 | Medium | Medium | "SEO tools 2026" |
| **Long-tail** | 3-5+ | Low | Low | "how to optimize Core Web Vitals WordPress" |
| **Local** | 2-4 | Low-Med | Low-Med | "SEO consultant Paris" |

---

## Research Process

### 1. Seed Keywords

```bash
# Start with 5-10 core topics
"SEO", "technical SEO", "local SEO", "SEO tools"
```

### 2. Expand with Tools

```bash
# Free Tools
- Google Keyword Planner
- Google Search Console (queries)
- Answer The Public

# Paid Tools
- Ahrefs Keywords Explorer
- SEMrush Keyword Magic Tool
- Moz Keyword Explorer
```

### 3. Analyze SERP

```bash
# Check Google for:
- People Also Ask (PAA)
- Related searches (bottom of SERP)
- AI Overview (what questions trigger it?)
```

### 4. Prioritize

```bash
# Score = (Volume × Relevance) / Difficulty

Example:
"SEO guide 2026"
Volume: 8,100/mo
Relevance: 10/10 (exact match)
Difficulty: 45/100
Score = (8100 × 10) / 45 = 1800
```

---

## Search Intent

| Intent | Goal | Keywords | Content Type |
|--------|------|----------|--------------|
| **Informational** | Learn | "what is", "how to" | Guide, tutorial |
| **Navigational** | Find brand | "Ahrefs login" | Homepage |
| **Commercial** | Compare | "best SEO tools" | Comparison |
| **Transactional** | Buy | "buy SEO tool" | Product page |
