---
name: seo
description: SEO/SEA/GEO 2026 complete methodology for organic, paid, and AI search optimization.
---

# SEO/SEA/GEO Skill (2026)

**Complete SEO/GEO reference with 50+ detailed guides across 10 categories.**

## Documentation Structure

```
01-seo-foundations/     → Current date, research workflow, SEO vs GEO
02-onpage-seo/         → Meta tags, Open Graph, Twitter Cards, headers, alt text
03-schema-org/         → 9 schema types (Article, FAQ, Product, etc.)
04-geo-2026/           → AI platforms, citations, LLM crawlability
05-technical-seo/      → Core Web Vitals, mobile-first, crawlability
06-content-strategy/   → E-E-A-T, anti-cannibalization, AI content, keyword distribution
07-sea-google-ads/     → Quality Score, landing pages, extensions
08-measurement/        → GEO tracking tools, Share of Model, analytics
09-checklists/         → Pre-publication, technical audit, GEO compliance
10-local-seo/          → GBP, NAP citations, reviews, Local Pack, local pages
```

---

## 7-Phase Workflow (MANDATORY)

```
PHASE 1: ANALYZE → Extract content, detect intent
PHASE 2: RESEARCH → SERP analysis, 2026 trends, AI platforms
PHASE 3: KEYWORDS → Extract with anti-cannibalization
PHASE 4: STRUCTURE → Meta, OG, Twitter Cards, Hn, schema, alt text
PHASE 5: CONTENT → Write SEO+GEO optimized content
PHASE 6: SEA → Google Ads recommendations
PHASE 7: VALIDATE → SEO + GEO compliance checklists
```

## On-Page Structure

### Meta Title (50-60 chars)
```
[Primary Keyword]: [Benefit] | [Brand]
Example: "SEO Guide 2025: 47 Proven Techniques | AgencySEO"
```

### Meta Description (120-155 chars)
```
[Hook] + [Benefit] + [CTA]
Example: "Discover 2025 SEO best practices. E-E-A-T, Core Web Vitals. Download now."
```

### URL Format
```
/category/primary-keyword-year
Rules: lowercase, hyphens, no accents, <75 chars
```

### Hn Hierarchy
```
H1: Main title (only 1)
├── H2: Section 1
│   ├── H3: Subsection 1.1
│   └── H3: Subsection 1.2
├── H2: Section 2
│   └── H3: Subsection 2.1
│       └── H4: Detail 2.1.1
└── H2: FAQ (long-tail questions)
```

### Image Alt Text
```
[Visual description] + [Contextual keyword]
Example: "Core Web Vitals dashboard showing LCP 2.1s"
```

## Keyword Strategy

### Categories
| Type | Words | Example |
|------|-------|---------|
| **Primary** | 1-2 | "SEO 2025" |
| **Secondary** | 2-3 | "technical SEO audit" |
| **Long-tail** | 3-5 | "how to improve WordPress SEO 2025" |
| **Local** | 2-4 | "SEO consultant Lyon" |
| **Questions** | PAA | "What is E-E-A-T in SEO?" |
| **SEA** | Commercial | "buy SEO services" |

### Anti-Cannibalization Rules
1. **ONE primary keyword per page**
2. Map all site pages to their keywords
3. No duplicate H1s across site
4. Canonical tags for similar content
5. Internal linking supports main page

**If conflict detected**:
- Consolidate pages, OR
- Differentiate keywords, OR
- 301 redirect to canonical

## GEO/AI Optimization

### For AI Citation
- Direct answer in first 100 words
- FAQ schema with concise answers (2-3 sentences)
- Factual claims with sources
- Question-answer format sections
- Speakable schema for voice

### Schema Types
| Schema | Use Case |
|--------|----------|
| `Article` | Blog posts |
| `FAQ` | Long-tail questions |
| `HowTo` | Tutorials |
| `LocalBusiness` | Local SEO |
| `Product` | E-commerce |
| `Speakable` | Voice/AI |
| `Organization` | Brand authority |

## SEA Recommendations

### Ad Copy Structure
- **Headlines**: 30 chars max, 15 variations
- **Descriptions**: 90 chars max, 4 variations
- **Display URL**: Include keyword
- **CTA**: Clear action words

### Keyword Strategy for Ads
- Exact match: `[keyword]`
- Phrase match: `"keyword"`
- Negative keywords: Exclude irrelevant

### Landing Page Optimization
- Headline matches ad copy
- CTA above fold
- Trust signals (reviews, certifications)
- Page speed <3s
- Mobile responsive

### Quality Score Factors
- Ad relevance
- Landing page experience
- Expected CTR

## Content Writing Rules

### Keyword Distribution (Natural Writing)

See: `06-content-strategy/keyword-distribution.md`

| Element | Target | Maximum |
|---------|--------|---------|
| Primary keyword | 0.5-2% | 3% |
| Secondary keywords | 0.3-1% each | 2% |
| Total all keywords | 2-3% | 5% |

**Per page structure:**
- 1 primary keyword
- 3-5 secondary keywords
- 5-10 semantic/related terms
- 5-15 long-tail variations
- 2-5 local modifiers (if local)

**Anti-stuffing rules:**
- Never >3% primary density
- Spread keywords naturally
- Use synonyms for variety
- Read aloud test: if awkward, rewrite

### Paragraph Structure
- Max 3-4 sentences per paragraph
- Short sentences (15-20 words)
- Bullet points for lists
- Bold on important keywords

### E-E-A-T Integration
- **Experience**: Personal examples, case studies
- **Expertise**: Data, statistics, sources
- **Authority**: Expert citations, backlinks
- **Trust**: Transparency, updates, contact

### Linking Strategy
- **Internal**: 3-5 per 1000 words, descriptive anchors
- **External**: 2-3 authoritative sources (DA 50+)

## Validation Checklist

### SEO Checks
- [ ] Title 50-60 chars, keyword at start
- [ ] Description 120-155 chars with CTA
- [ ] H1 unique, contains primary keyword
- [ ] Hn hierarchy respected (no skipping)
- [ ] URL SEO-friendly, <75 chars
- [ ] Images 100% with descriptive alt
- [ ] Keyword density 1-2%
- [ ] Internal links 3-5 per 1000 words
- [ ] Readability Flesch 60-70
- [ ] Length adapted to intent (min 1500 for guides)

### Cannibalization Checks
- [ ] Primary keyword unique to page
- [ ] No duplicate H1s
- [ ] No competing pages for same query
- [ ] Canonical tags set

### SEA Checks
- [ ] Landing page matches ad intent
- [ ] CTA clear and above fold
- [ ] Page speed <3s
- [ ] Mobile responsive
- [ ] Trust signals present

### GEO/AI Checks
- [ ] Direct answer first 100 words
- [ ] FAQ schema implemented
- [ ] Structured data valid
- [ ] Content AI-parseable
- [ ] Concise definitions available

## Report Format

```markdown
## SEO/SEA/GEO Report

### 1. Content Analysis
[Summary + detected intent]

### 2. Competitive Analysis
| Competitor | DR | Keywords | Length | SERP Features |
|------------|-----|----------|--------|---------------|

### 3. Cannibalization Audit
| Page | Primary Keyword | Conflict? | Recommendation |
|------|-----------------|-----------|----------------|

### 4. Keywords
| Type | Keyword | Volume | Difficulty | CPC |
|------|---------|--------|------------|-----|

### 5. On-Page Structure
- **Title**: [50-60 chars]
- **Description**: [120-155 chars]
- **URL**: [SEO-friendly]
- **Hn**: [Hierarchy]

### 6. SEA Recommendations
- Headlines: [15 variations]
- Descriptions: [4 variations]
- Negative Keywords: [List]

### 7. Scores
- SEO: X/100
- SEA: X/100
- GEO: X/100
- Cannibalization Risk: Low/Medium/High
```

---

## Quick Reference 2026

### Core Documentation

| Topic | Files | Key Concepts |
|-------|-------|--------------|
| **Foundations** | `01-seo-foundations/` | Current date (2026), SEO vs GEO paradigm shift, research-first |
| **On-Page** | `02-onpage-seo/` | Meta tags, Open Graph (1200x630px), Twitter Cards, H1-H6, alt text |
| **Schema** | `03-schema-org/` | Article, FAQ, Product, LocalBusiness, Organization, Breadcrumb |
| **GEO 2026** | `04-geo-2026/` | ChatGPT, Gemini, Claude, Perplexity, Copilot, citations, zero-click |
| **Technical** | `05-technical-seo/` | Core Web Vitals (LCP, INP, CLS), mobile-first, crawlability |
| **Content** | `06-content-strategy/` | E-E-A-T, anti-cannibalization, AI content guidelines |
| **SEA** | `07-sea-google-ads/` | Quality Score, landing pages, ad extensions |
| **Measurement** | `08-measurement/` | OmniSEO®, Otterly.ai, Share of Model, analytics |
| **Checklists** | `09-checklists/` | Pre-publication, technical audit, GEO compliance |
| **Local SEO** | `10-local-seo/` | GBP, NAP citations, reviews, Local Pack, local pages |

---

## Local SEO (2026)

See: `10-local-seo/` (7 files)

### Google Business Profile (32-35% ranking weight)

- Complete all fields (categories, services, hours, photos)
- Weekly posts for engagement (+30%)
- Q&A section with seeded questions
- Photos: geo-tagged, high quality

### NAP Citations

- **N**ame, **A**ddress, **P**hone must be identical everywhere
- Priority directories: Yelp, Yellow Pages, BBB, TripAdvisor
- Audit quarterly for inconsistencies

### Reviews Strategy (19-20% ranking weight)

- Velocity: consistent new reviews monthly
- Respond to ALL reviews (positive + negative)
- Keywords in reviews help ranking
- Recent reviews matter more than total count

### Local Pack (3-Pack) Ranking Factors

1. **Proximity** to searcher
2. **GBP completeness** and activity
3. **Review signals** (quantity, velocity, rating)
4. **NAP consistency** across web
5. **Local backlinks** and citations
6. **Behavioral signals** (clicks, calls, directions)

### Local Landing Pages

- Unique content per location (40-60% unique)
- LocalBusiness schema required
- Embed Google Map
- Local testimonials and case studies

---

## New in 2026

### GEO (Generative Engine Optimization)

- **Zero-Click Reality**: 60% of searches don't click
- **AI Platforms**: ChatGPT (72B messages/mo), Gemini, Claude, Perplexity, Copilot
- **Share of Model**: % of AI citations in your niche
- **Citation Strategies**: Princeton 10 tactics (40% visibility boost)
- **Tracking Tools**: OmniSEO®, Otterly.ai, Rankscale

### Open Graph & Twitter Cards (MANDATORY)

- **Open Graph**: Facebook, LinkedIn, Discord previews (1200x630px)
- **Twitter Cards**: X.com cards (1200x628px)
- See: `02-onpage-seo/open-graph.md`, `twitter-cards.md`

### Complete Schema Coverage

- **9 Schema Types**: Article, FAQ, Product, LocalBusiness, Organization, Person, Breadcrumb, HowTo, Review
- **E-E-A-T Signals**: Author/Publisher schema mandatory
- See: `03-schema-org/` (all files)

### E-E-A-T 2026 Updates

- **Experience**: First-hand knowledge (NEW in 2022)
- **AI Content**: Allowed if human value added
- **Spam Update**: Scaled content abuse enforcement
- See: `06-content-strategy/eeat-implementation.md`

---

## Workflow Examples

### PHASE 2: Research (2026)

```bash
# Check official guidelines
- Google Search Central (developers.google.com/search)
- Quality Rater Guidelines (January 2025 update)

# SERP Analysis
- Top 10 results for target keyword
- AI Overview presence? (16% of queries)
- Featured snippet format?

# AI Platform Testing
1. ChatGPT: "Tell me about [keyword]"
2. Google AI Overview: Search on Google
3. Perplexity: "[keyword] latest information"
4. Gemini: "[keyword] comprehensive guide"
5. Copilot: "[keyword] recommendations"

# Document which sources are cited
```

See: `01-seo-foundations/research-workflow.md`

---

### PHASE 4: Structure (Complete)

```html
<!-- Meta Tags -->
<title>SEO Guide 2026: 47 Proven Techniques | Brand</title>
<meta name="description" content="Discover 2026 SEO best practices...">
<link rel="canonical" href="https://example.com/seo-guide-2026">

<!-- Open Graph (Facebook, LinkedIn, Discord) -->
<meta property="og:title" content="SEO Guide 2026: 47 Proven Techniques">
<meta property="og:description" content="Discover 2026 SEO best practices...">
<meta property="og:image" content="https://example.com/og-image.jpg">
<meta property="og:url" content="https://example.com/seo-guide-2026">
<meta property="og:type" content="article">

<!-- Twitter Card (X.com) -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="SEO Guide 2026: 47 Proven Techniques">
<meta name="twitter:description" content="Discover 2026 SEO best practices...">
<meta name="twitter:image" content="https://example.com/twitter-card.jpg">

<!-- Schema.org JSON-LD -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Article",
  "headline": "SEO Guide 2026: 47 Proven Techniques",
  "image": "https://example.com/featured.jpg",
  "author": {"@type": "Person", "name": "Jean Dupont"},
  "publisher": {"@type": "Organization", "name": "Brand"},
  "datePublished": "2026-01-18T10:00:00+00:00"
}
</script>
```

See: `02-onpage-seo/meta-tags.md`, `open-graph.md`, `twitter-cards.md`, `03-schema-org/article-schema.md`

---

## Forbidden Behaviors

### SEO (Traditional)
- ❌ Keyword stuffing (>3% density)
- ❌ Cloaking or black-hat techniques
- ❌ Duplicate or spun content
- ❌ Ignoring search intent
- ❌ Skipping Hn levels (H2→H4)
- ❌ Meta title >60 chars
- ❌ Generic alt text ("image", "photo")
- ❌ Same primary keyword on multiple pages

### GEO (New 2026)
- ❌ No AI platform testing before publication
- ❌ Missing Open Graph / Twitter Cards
- ❌ No citations to sources
- ❌ No statistics / expert quotes
- ❌ Outdated references (pre-2025)
- ❌ Generic content AI cannot parse
- ❌ Missing FAQ schema on Q&A content
- ❌ No quick answer in first 100 words
