---
name: seo-content-audit
description: Comprehensive on-page SEO and content quality audit covering title tags, meta descriptions, header structure, keyword optimization, E-E-A-T signals, readability, and content scoring. Use when evaluating content for SEO performance, reviewing articles before publication, or creating content improvement recommendations.
license: MIT
metadata:
  author: Schwepps
  version: "1.0.0"
  category: marketing
  tags: seo, content-audit, on-page-seo, e-e-a-t, keyword-optimization
---

# SEO Content Audit Framework

Professional methodology for comprehensive on-page SEO and content quality analysis.

## When to Use This Skill

- Auditing existing content for SEO performance
- Reviewing new content before publication
- Identifying optimization opportunities
- Evaluating E-E-A-T signals
- Scoring content quality
- Competitive content analysis
- Creating content improvement plans

## Audit Workflow

### Phase 1: On-Page SEO Elements

**Title Tag Analysis:**
```
□ Length: 50-60 characters
□ Primary keyword near beginning (first 30 chars)
□ Unique across site
□ Compelling for CTR
□ Brand included (if space)
□ No keyword stuffing
□ Matches search intent
```

**Meta Description Analysis:**
```
□ Length: 150-160 characters
□ Contains primary keyword
□ Includes call-to-action
□ Unique across site
□ Accurately describes content
□ Compelling for clicks
```

**Header Structure (H1-H6):**
```
Requirements:
□ Single H1 matching topic
□ H1 contains primary keyword
□ Logical hierarchy (H1 → H2 → H3)
□ No skipped levels
□ Keywords in H2s naturally
□ Descriptive, not generic
```

**URL Structure:**
```
□ Clean, descriptive
□ Contains primary keyword
□ Under 60 characters
□ Lowercase with hyphens
□ No parameters or IDs
□ Matches content hierarchy
```

### Phase 2: Content Quality Assessment

**Content Completeness Scoring:**

| Factor | Check | Score |
|--------|-------|-------|
| Topic coverage | Comprehensive vs. shallow | /10 |
| Unique value | Original insights vs. rehash | /10 |
| Accuracy | Factual, verifiable | /10 |
| Freshness | Current information | /10 |
| Depth | Expert-level detail | /10 |

**The C.R.E.A.T.E. Framework:**

| Factor | Question | Score 1-4 |
|--------|----------|-----------|
| **C**omprehensiveness | Does it fully answer the query? | |
| **R**elevance | Does it match search intent? | |
| **E**xpertise | Does it demonstrate deep knowledge? | |
| **A**ctionability | Can readers apply this immediately? | |
| **T**rustworthiness | Are claims supported by evidence? | |
| **E**ngagement | Is it interesting to read? | |

**Readability Standards:**
```
Target reading level: Grade 8-10 (Flesch-Kincaid)
Paragraph length: 2-4 sentences ideal
Sentence variety: Mix short and medium
Scannable formatting: Headers, bullets, bold
Visual aids: Images, tables, diagrams where helpful
```

### Phase 3: Keyword Optimization

**Primary Keyword Checklist:**
```
□ In title tag (first 30 chars)
□ In H1
□ In first 100 words
□ In at least one H2
□ In meta description
□ In URL
□ Natural density: 0.5-1.5%
□ In image alt text (if relevant)
```

**Semantic Coverage:**
```
□ LSI keywords present
□ Related entities mentioned
□ Question variations addressed
□ Synonyms used naturally
□ Topic cluster alignment
□ Search intent fully matched
```

**Keyword Density Guidelines:**
```
Primary keyword: 0.5-1.5% density (natural)
Secondary keywords: 0.3-0.8% each
LSI/Related terms: Natural inclusion
Avoid: Keyword stuffing (>2%)
```

### Phase 4: E-E-A-T Evaluation

**Experience Signals:**
```
□ First-hand experience indicated
□ Case studies/examples included
□ Original data or research
□ Process documentation
□ Real-world applications shown
□ Personal insights shared
```

**Expertise Signals:**
```
□ Author credentials visible
□ Author bio with qualifications
□ Technical accuracy verified
□ Comprehensive coverage
□ Expert quotes/interviews
□ Specialized terminology used correctly
```

**Authority Signals:**
```
□ Authoritative external citations
□ Links to primary sources
□ Industry recognition mentioned
□ Published research referenced
□ Brand authority established
□ Backlink profile (if available)
```

**Trust Signals:**
```
□ Contact information accessible
□ Privacy policy linked
□ Editorial guidelines visible
□ Sources cited inline
□ Last updated date shown
□ Author photo and bio
□ Secure site (HTTPS)
```

### Phase 5: Internal Linking

```
Best Practices:
□ 3-10 internal links per 1000 words
□ Descriptive anchor text (not "click here")
□ Links to related content
□ Links from high-authority pages
□ Logical link hierarchy
□ No orphan pages
□ Breadcrumb navigation
```

### Phase 6: Performance Signals

**Metrics to Evaluate (if available):**
```
□ Organic traffic trend
□ Average position for target keywords
□ Click-through rate (CTR)
□ Bounce rate
□ Time on page
□ Pages per session
□ Conversion rate
```

**Benchmarks:**
| Metric | Poor | Average | Good |
|--------|------|---------|------|
| CTR (pos 1-3) | <3% | 3-8% | >8% |
| Bounce rate | >70% | 50-70% | <50% |
| Time on page | <1min | 1-3min | >3min |

## Output Format

```markdown
# SEO Content Audit Report

**Page:** [URL or filename]
**Date:** [Date]
**Overall Score:** X/100

## Executive Summary
[2-3 sentence overview of findings]

## Scores by Category

| Category | Score | Status |
|----------|-------|--------|
| On-Page SEO | X/20 | [Good/Needs Work/Critical] |
| Content Quality | X/25 | [Good/Needs Work/Critical] |
| Keyword Optimization | X/15 | [Good/Needs Work/Critical] |
| E-E-A-T Signals | X/20 | [Good/Needs Work/Critical] |
| AI/GEO Readiness | X/20 | [Good/Needs Work/Critical] |

## Priority Issues (Fix First)
1. **[Issue]** - [Impact] - [Fix]
2. **[Issue]** - [Impact] - [Fix]
3. **[Issue]** - [Impact] - [Fix]

## On-Page SEO Findings
- Title: [Current] → [Recommended]
- Meta: [Current] → [Recommended]
- Headers: [Analysis]
- URL: [Analysis]

## Content Quality Findings
- C.R.E.A.T.E. Score: X/24
- Word count: [X] (Recommended: [Y])
- Readability: Grade [X]
- Gaps: [List]

## Keyword Analysis
- Primary: [Keyword] - Density: X%
- Missing opportunities: [List]
- Over-optimized: [List if any]

## E-E-A-T Assessment
- Strengths: [List]
- Gaps: [List]
- Recommendations: [List]

## Action Plan

**Immediate (This Week):**
- [ ] Action 1
- [ ] Action 2

**Short-term (This Month):**
- [ ] Action 1
- [ ] Action 2

**Ongoing:**
- [ ] Action 1
- [ ] Action 2
```

## Quick Audit (5-Point Check)

1. **Title & Meta** - Optimized, compelling, <60 chars?
2. **H1 & Structure** - Clear hierarchy, keyword in H1?
3. **Content Depth** - Comprehensive, >1500 words for guides?
4. **E-E-A-T** - Author credentials, trust signals visible?
5. **AI Ready** - TL;DR present, extractable format?

## Scoring Guide

- **90-100:** Excellent - Minor optimizations only
- **70-89:** Good - Some improvements needed
- **50-69:** Needs Work - Significant gaps to address
- **Below 50:** Critical - Major overhaul required

## Scoring Rubric (Detailed)

**On-Page SEO (20 points):**
- Title tag optimized: 5 pts
- Meta description optimized: 4 pts
- Header structure correct: 4 pts
- URL optimized: 3 pts
- Image alt text: 2 pts
- Internal links: 2 pts

**Content Quality (25 points):**
- Comprehensiveness: 5 pts
- Accuracy: 5 pts
- Originality: 5 pts
- Readability: 5 pts
- Engagement: 5 pts

**Keyword Optimization (15 points):**
- Primary keyword placement: 6 pts
- Semantic coverage: 5 pts
- Natural density: 4 pts

**E-E-A-T (20 points):**
- Experience signals: 5 pts
- Expertise signals: 5 pts
- Authority signals: 5 pts
- Trust signals: 5 pts

**AI/GEO Readiness (20 points):**
- TL;DR/Summary: 4 pts
- Extractable structure: 4 pts
- FAQ section: 4 pts
- Schema markup: 4 pts
- Fact density: 4 pts

## Competitor Analysis Framework

When comparing against competitors:

1. **Identify top 3-5 ranking competitors** for target keyword
2. **Analyze their content:**
   - Word count
   - Header structure
   - Topics covered
   - Unique angles
   - E-E-A-T signals
3. **Find gaps:**
   - Topics they miss
   - Questions unanswered
   - Data not included
4. **Create differentiation plan:**
   - Original research
   - Better visuals
   - More comprehensive coverage
   - Stronger E-E-A-T
