# SEO Content Audit Checklists

## Table of Contents
1. [On-Page SEO Checklist](#on-page-seo-checklist)
2. [Content Quality Checklist](#content-quality-checklist)
3. [E-E-A-T Checklist](#e-e-a-t-checklist)
4. [Technical Content Checklist](#technical-content-checklist)
5. [User Experience Checklist](#user-experience-checklist)

---

## On-Page SEO Checklist

### Title Tag (High Priority)

| Check | Status | Notes |
|-------|--------|-------|
| Length 50-60 characters | □ | Actual: ___ chars |
| Primary keyword present | □ | Keyword: ________ |
| Keyword near beginning | □ | Position: ___ |
| Unique (not duplicated) | □ | |
| Compelling/click-worthy | □ | |
| Brand at end (optional) | □ | |
| No keyword stuffing | □ | |
| Matches page intent | □ | |

### Meta Description (Medium Priority)

| Check | Status | Notes |
|-------|--------|-------|
| Length 150-160 characters | □ | Actual: ___ chars |
| Primary keyword present | □ | |
| Call-to-action included | □ | CTA: ________ |
| Unique (not duplicated) | □ | |
| Accurate description | □ | |
| Compelling for CTR | □ | |

### URL Structure (Medium Priority)

| Check | Status | Notes |
|-------|--------|-------|
| Contains primary keyword | □ | |
| Short and descriptive | □ | Words: ___ |
| Lowercase only | □ | |
| Hyphens (not underscores) | □ | |
| No unnecessary parameters | □ | |
| Matches site hierarchy | □ | |
| No dates (unless news) | □ | |

### Header Structure (High Priority)

| Check | Status | Notes |
|-------|--------|-------|
| Single H1 present | □ | Count: ___ |
| H1 contains primary keyword | □ | |
| Logical H1→H2→H3 hierarchy | □ | |
| No skipped levels | □ | |
| H2s contain secondary keywords | □ | |
| Headers describe sections | □ | |
| Headers scannable | □ | |

### Image Optimization (Medium Priority)

| Check | Status | Notes |
|-------|--------|-------|
| Descriptive alt text | □ | |
| Primary keyword in hero alt | □ | |
| File names descriptive | □ | |
| Compressed file sizes | □ | |
| Modern format (WebP/AVIF) | □ | |
| Lazy loading implemented | □ | |
| Width/height specified | □ | |

### Internal Links (High Priority)

| Check | Status | Notes |
|-------|--------|-------|
| 3-10 internal links present | □ | Count: ___ |
| Descriptive anchor text | □ | |
| Links to relevant content | □ | |
| No broken links | □ | |
| Page receives internal links | □ | Count: ___ |
| No orphan page status | □ | |

---

## Content Quality Checklist

### Comprehensiveness

| Check | Status | Notes |
|-------|--------|-------|
| Topic fully covered | □ | |
| Related questions answered | □ | |
| No major gaps | □ | Gaps: ________ |
| Subtopics included | □ | |
| Reader needs met | □ | |

### Relevance

| Check | Status | Notes |
|-------|--------|-------|
| Matches search intent | □ | Intent: ________ |
| Information current | □ | Last updated: ___ |
| Addresses actual query | □ | |
| Target audience appropriate | □ | |

### Accuracy

| Check | Status | Notes |
|-------|--------|-------|
| Facts verified | □ | |
| Statistics sourced | □ | Sources: ___ |
| No errors found | □ | |
| Technical accuracy | □ | |

### Originality

| Check | Status | Notes |
|-------|--------|-------|
| Not copied/plagiarized | □ | |
| Unique insights present | □ | |
| Original data/research | □ | |
| Fresh perspective | □ | |

### Readability

| Check | Status | Notes |
|-------|--------|-------|
| Appropriate reading level | □ | Grade: ___ |
| Short paragraphs (<4 sentences) | □ | |
| Clear language | □ | |
| Active voice preferred | □ | |
| Jargon explained | □ | |

### Structure

| Check | Status | Notes |
|-------|--------|-------|
| Logical flow | □ | |
| Clear introduction | □ | |
| Organized sections | □ | |
| Helpful subheadings | □ | |
| Clear conclusion/summary | □ | |

### Visual Elements

| Check | Status | Notes |
|-------|--------|-------|
| Images support content | □ | Count: ___ |
| Tables where appropriate | □ | |
| Lists for clarity | □ | |
| White space adequate | □ | |
| Font readable | □ | |

---

## E-E-A-T Checklist

### Experience

| Check | Status | Notes |
|-------|--------|-------|
| First-hand experience evident | □ | |
| Personal insights included | □ | |
| Real examples/case studies | □ | |
| Process documentation | □ | |
| Authentic perspective | □ | |

### Expertise

| Check | Status | Notes |
|-------|--------|-------|
| Author credentials displayed | □ | |
| Author bio present | □ | |
| Demonstrates deep knowledge | □ | |
| Technical accuracy | □ | |
| Industry terminology correct | □ | |
| Up-to-date information | □ | |

### Authority

| Check | Status | Notes |
|-------|--------|-------|
| Author recognized in field | □ | |
| Site has topic authority | □ | |
| External links/citations | □ | |
| Brand mentioned elsewhere | □ | |
| Industry awards/recognition | □ | |

### Trust

| Check | Status | Notes |
|-------|--------|-------|
| Sources cited | □ | Count: ___ |
| Links to authoritative sources | □ | |
| Contact information present | □ | |
| About page exists | □ | |
| Privacy policy present | □ | |
| HTTPS enabled | □ | |
| No misleading claims | □ | |

---

## Technical Content Checklist

### Schema Markup

| Check | Status | Notes |
|-------|--------|-------|
| Appropriate schema type | □ | Type: ________ |
| Article/BlogPosting schema | □ | |
| Author schema | □ | |
| FAQPage schema (if FAQ) | □ | |
| HowTo schema (if tutorial) | □ | |
| Breadcrumb schema | □ | |
| Rich Results Test passes | □ | |

### Performance

| Check | Status | Notes |
|-------|--------|-------|
| Page loads < 3 seconds | □ | Time: ___s |
| LCP < 2.5s | □ | Actual: ___s |
| CLS < 0.1 | □ | Actual: ___ |
| INP < 200ms | □ | Actual: ___ms |

### Mobile

| Check | Status | Notes |
|-------|--------|-------|
| Mobile-friendly | □ | |
| Text readable without zoom | □ | |
| Touch targets adequate | □ | |
| No horizontal scroll | □ | |
| Content parity with desktop | □ | |

### Indexation

| Check | Status | Notes |
|-------|--------|-------|
| Page indexable | □ | |
| No noindex tag | □ | |
| Canonical self-referencing | □ | |
| In XML sitemap | □ | |
| GSC shows indexed | □ | |

---

## User Experience Checklist

### Navigation

| Check | Status | Notes |
|-------|--------|-------|
| Clear navigation to page | □ | Clicks from home: ___ |
| Breadcrumbs present | □ | |
| Related content linked | □ | |
| Back button works | □ | |

### Engagement

| Check | Status | Notes |
|-------|--------|-------|
| Clear value proposition | □ | |
| Engaging introduction | □ | |
| Visual breaks in text | □ | |
| Interactive elements (if relevant) | □ | |
| Clear call-to-action | □ | |

### Accessibility

| Check | Status | Notes |
|-------|--------|-------|
| Alt text on images | □ | |
| Color contrast adequate | □ | |
| Keyboard navigable | □ | |
| Form labels present | □ | |
| Skip links available | □ | |

### Trust Indicators

| Check | Status | Notes |
|-------|--------|-------|
| Publish date visible | □ | |
| Last updated date | □ | |
| Author byline | □ | |
| Source attributions | □ | |
| No intrusive ads | □ | |
