# SEO Competitor Content Analysis Guide

## Table of Contents
1. [Competitor Identification](#competitor-identification)
2. [Content Gap Analysis](#content-gap-analysis)
3. [On-Page Comparison](#on-page-comparison)
4. [Content Performance Benchmarking](#content-performance-benchmarking)
5. [Actionable Insights](#actionable-insights)

---

## Competitor Identification

### Types of SEO Competitors

```
1. DIRECT COMPETITORS
   Same products/services, same target market
   → Most important for commercial keywords

2. INDIRECT COMPETITORS
   Different products, same audience needs
   → Important for informational content

3. SERP COMPETITORS
   Rank for your target keywords
   → May not be business competitors
   → Critical for content strategy
```

### Finding SERP Competitors

**Method 1: Manual SERP Analysis**
```
For each target keyword:
1. Search in incognito mode
2. Record top 10 organic results
3. Note SERP features present
4. Identify recurring domains
```

**Method 2: Tool-Based Discovery**
```
Ahrefs/Semrush:
└── Site Explorer → Organic Competitors
    └── Shows domains sharing the most keywords

Screaming Frog SERP Analysis:
└── Bulk check keywords → Export SERP results
```

**Competitor Priority Matrix**

| Competitor Type | Keyword Overlap | Priority |
|-----------------|-----------------|----------|
| High overlap + Direct | >50% | 1 (Critical) |
| High overlap + Indirect | >50% | 2 (Important) |
| Low overlap + Direct | <50% | 3 (Monitor) |
| Low overlap + Indirect | <50% | 4 (Awareness) |

---

## Content Gap Analysis

### Topic Gap Identification

**Process:**
```
1. Export competitor keywords (ranking positions 1-20)
2. Export your keywords (same criteria)
3. Find keywords where:
   ├── Competitor ranks, you don't
   ├── Competitor ranks higher
   └── Competitor has content, you don't
4. Categorize gaps by intent and priority
```

### Gap Analysis Template

| Topic/Keyword | Competitor | Their Position | Your Position | Content Exists? | Priority |
|---------------|------------|----------------|---------------|-----------------|----------|
| [keyword 1] | [comp A] | 3 | - | No | High |
| [keyword 2] | [comp B] | 5 | 15 | Yes (weak) | Medium |
| [keyword 3] | [comp A] | 1 | 8 | Yes | Low |

### Content Type Gap Analysis

```
Analyze competitor content types:

□ Definitive guides (5,000+ words)
□ How-to tutorials
□ Comparison articles
□ Listicles/roundups
□ Case studies
□ Original research/data
□ Tools/calculators
□ Templates/downloads
□ Video content
□ Infographics
□ FAQ pages
□ Glossaries

Mark which types:
✓ You have
✗ You don't have
⚡ Competitor excels at
```

### SERP Feature Gap Analysis

| SERP Feature | Competitor A | Competitor B | Your Site | Opportunity |
|--------------|--------------|--------------|-----------|-------------|
| Featured Snippet | ✓ | ✗ | ✗ | High |
| People Also Ask | ✓ | ✓ | ✗ | High |
| Image Pack | ✗ | ✓ | ✗ | Medium |
| Video Carousel | ✓ | ✗ | ✗ | Medium |
| FAQ Rich Result | ✓ | ✓ | ✗ | High |
| Knowledge Panel | ✗ | ✗ | ✗ | Low |

---

## On-Page Comparison

### Side-by-Side Analysis Framework

For each competing page, document:

**1. Content Metrics**
```
| Metric | Competitor A | Competitor B | Your Page |
|--------|--------------|--------------|-----------|
| Word count | | | |
| Heading count | | | |
| Image count | | | |
| Video embeds | | | |
| Tables/lists | | | |
| External links | | | |
| Internal links | | | |
| Reading time | | | |
```

**2. On-Page SEO Elements**
```
| Element | Competitor A | Competitor B | Your Page |
|---------|--------------|--------------|-----------|
| Title length | | | |
| Title keyword position | | | |
| Meta desc length | | | |
| H1 text | | | |
| URL structure | | | |
| Schema types | | | |
```

**3. Content Structure**
```
Document the outline/structure of top-ranking pages:

Competitor A Outline:
├── H1: [title]
├── H2: [section]
│   ├── H3: [subsection]
│   └── H3: [subsection]
├── H2: [section]
└── H2: [FAQ/Conclusion]

Compare to your content structure.
```

**4. E-E-A-T Signals**
```
| Signal | Competitor A | Competitor B | Your Page |
|--------|--------------|--------------|-----------|
| Author bio | ✓/✗ | | |
| Author credentials | ✓/✗ | | |
| Sources cited | Count: | | |
| Last updated visible | ✓/✗ | | |
| Expert quotes | ✓/✗ | | |
| Original research | ✓/✗ | | |
```

### Competitor Content Scoring

Score each competitor on a 1-5 scale:

| Factor | Comp A | Comp B | Your Site |
|--------|--------|--------|-----------|
| Depth/comprehensiveness | | | |
| Accuracy/quality | | | |
| Freshness | | | |
| User experience | | | |
| Visual elements | | | |
| Unique value | | | |
| **Total** | /30 | /30 | /30 |

---

## Content Performance Benchmarking

### Traffic & Ranking Benchmarks

**Using SEO Tools (Ahrefs/Semrush):**
```
For each competitor page, gather:
├── Estimated monthly traffic
├── Number of ranking keywords
├── Top ranking keywords
├── Referring domains
├── Page authority/rating
└── Social shares
```

### Benchmark Comparison Table

| Metric | Industry Avg | Top Competitor | Your Site | Gap |
|--------|--------------|----------------|-----------|-----|
| Avg. word count (top 10) | | | | |
| Avg. backlinks (top 10) | | | | |
| Avg. DR of ranking pages | | | | |
| Featured snippet win % | | | | |
| PAA inclusion % | | | | |

### Content Age Analysis

```
For target keywords, analyze:

Position 1-3 content age:
├── Published: [date]
├── Last updated: [date]
├── Age: [months/years]
└── Update frequency: [pattern]

Insight: Do fresh updates correlate with rankings?
```

---

## Actionable Insights

### Gap to Action Translation

| Gap Type | Finding | Recommended Action | Priority |
|----------|---------|-------------------|----------|
| Missing topic | Competitor ranks for X, we have no content | Create comprehensive guide | High |
| Thin content | Our content 500 words, competitors 2000+ | Expand and deepen content | High |
| Missing SERP feature | Competitor in featured snippet | Add snippet-optimized section | High |
| Outdated content | Our content 2 years old, competitors updated | Update and refresh | Medium |
| Missing format | Competitors have video, we don't | Add video content | Medium |
| Weak E-E-A-T | Competitors have author bios, we don't | Add author expertise signals | Medium |
| Missing schema | Competitors have FAQ schema | Implement structured data | Medium |

### Content Improvement Priority Matrix

```
        High Impact
            │
   QUICK    │    STRATEGIC
   WINS     │    PRIORITIES
            │
Low ────────┼──────── High
Effort      │        Effort
            │
   FILL     │    CONSIDER
   INS      │    LATER
            │
        Low Impact
```

**Quick Wins (Low effort, High impact):**
- Add FAQ sections to existing content
- Update titles and meta descriptions
- Add internal links
- Implement schema markup

**Strategic Priorities (High effort, High impact):**
- Create comprehensive guides for gap topics
- Develop original research/data
- Build topical authority through content clusters

**Fill-Ins (Low effort, Low impact):**
- Minor content updates
- Image optimization
- Social sharing buttons

**Consider Later (High effort, Low impact):**
- Complete site redesign
- Video production (unless high priority)
- Tool/calculator development

### Competitor Monitoring Schedule

| Activity | Frequency | Tool/Method |
|----------|-----------|-------------|
| SERP position tracking | Weekly | Ahrefs/Semrush |
| New competitor content alerts | Weekly | Google Alerts, Ahrefs |
| Competitor content audit | Quarterly | Manual analysis |
| Full gap analysis | Bi-annually | Comprehensive review |
| SERP feature monitoring | Monthly | SERP tracker |
