# SEO Content Audit Scoring Rubrics

## Table of Contents
1. [Overall Scoring Framework](#overall-scoring-framework)
2. [On-Page SEO Scoring](#on-page-seo-scoring)
3. [Content Quality Scoring](#content-quality-scoring)
4. [E-E-A-T Scoring](#e-e-a-t-scoring)
5. [Keyword Optimization Scoring](#keyword-optimization-scoring)
6. [Performance Scoring](#performance-scoring)

---

## Overall Scoring Framework

### Score Calculation

```
Total Score = Weighted Average of:
├── On-Page SEO: 25%
├── Content Quality: 30%
├── E-E-A-T: 20%
├── Keyword Optimization: 15%
└── Performance: 10%
```

### Score Interpretation

| Score Range | Rating | Action Required |
|-------------|--------|-----------------|
| 90-100 | Excellent | Minor optimization only |
| 80-89 | Good | Targeted improvements |
| 70-79 | Average | Significant optimization needed |
| 60-69 | Below Average | Major revision required |
| <60 | Poor | Complete overhaul needed |

---

## On-Page SEO Scoring

### Title Tag (25 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Length optimal (50-60 chars) | 5 | 5=optimal, 3=close, 1=too short/long |
| Primary keyword present | 5 | 5=yes near front, 3=yes but buried, 0=no |
| Unique across site | 5 | 5=unique, 0=duplicate |
| Click-worthy/compelling | 5 | 5=excellent, 3=good, 1=generic |
| Matches search intent | 5 | 5=perfect match, 3=partial, 1=mismatch |

### Meta Description (15 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Length optimal (150-160 chars) | 3 | 3=optimal, 2=close, 1=too short/long |
| Primary keyword present | 3 | 3=yes, 0=no |
| Call-to-action included | 3 | 3=clear CTA, 1=weak, 0=none |
| Unique across site | 3 | 3=unique, 0=duplicate |
| Compelling for CTR | 3 | 3=excellent, 2=good, 1=generic |

### Header Structure (20 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Single H1 present | 5 | 5=one H1, 0=zero or multiple |
| H1 contains primary keyword | 5 | 5=yes, 3=partial, 0=no |
| Logical hierarchy | 5 | 5=perfect, 3=minor issues, 1=broken |
| Headers describe content | 5 | 5=excellent, 3=adequate, 1=poor |

### URL Structure (10 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Contains primary keyword | 3 | 3=yes, 0=no |
| Short and descriptive | 3 | 3=excellent, 2=acceptable, 1=too long |
| Proper format (lowercase, hyphens) | 2 | 2=correct, 0=issues |
| Clean (no parameters) | 2 | 2=clean, 0=messy |

### Internal Links (15 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Adequate outbound internal links | 5 | 5=3-10 links, 3=1-2, 0=none |
| Descriptive anchor text | 5 | 5=descriptive, 3=ok, 1=generic |
| Receives internal links | 5 | 5=>5 inbound, 3=1-5, 0=orphan |

### Images (15 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Alt text present and descriptive | 5 | 5=all good, 3=some, 1=missing |
| Optimized file sizes | 5 | 5=all optimized, 3=some, 1=heavy |
| Relevant to content | 5 | 5=highly relevant, 3=adequate, 1=filler |

---

## Content Quality Scoring

### Comprehensiveness (20 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Topic coverage depth | 8 | 8=exhaustive, 5=thorough, 3=basic, 1=thin |
| Related questions answered | 6 | 6=all major, 4=most, 2=few |
| No significant gaps | 6 | 6=complete, 4=minor gaps, 2=major gaps |

### Relevance (20 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Matches search intent | 8 | 8=perfect, 5=good, 3=partial, 1=mismatch |
| Information current | 6 | 6=current, 4=slightly dated, 2=outdated |
| Target audience appropriate | 6 | 6=perfect fit, 4=acceptable, 2=mismatch |

### Accuracy (20 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Facts verified/verifiable | 8 | 8=all verified, 5=mostly, 3=some issues |
| Sources cited | 6 | 6=well sourced, 4=some sources, 2=none |
| No errors found | 6 | 6=error-free, 4=minor errors, 2=major errors |

### Originality (20 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Unique content (not copied) | 8 | 8=original, 4=some unique, 0=copied |
| Fresh perspective/insights | 6 | 6=novel, 4=somewhat unique, 2=generic |
| Original data/research | 6 | 6=original data, 4=unique analysis, 2=none |

### Readability & Structure (20 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Appropriate reading level | 5 | 5=audience-appropriate, 3=too complex/simple |
| Clear structure and flow | 5 | 5=excellent, 3=adequate, 1=confusing |
| Visual formatting aids reading | 5 | 5=excellent use, 3=adequate, 1=walls of text |
| Engaging writing style | 5 | 5=compelling, 3=readable, 1=dull |

---

## E-E-A-T Scoring

### Experience (25 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| First-hand experience evident | 10 | 10=clear, 5=implied, 0=none |
| Personal insights/examples | 8 | 8=rich examples, 4=some, 0=none |
| Process documentation | 7 | 7=detailed, 4=partial, 0=none |

### Expertise (25 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Author credentials displayed | 10 | 10=strong credentials, 5=basic, 0=none |
| Demonstrates deep knowledge | 8 | 8=expert level, 5=competent, 2=basic |
| Technical accuracy | 7 | 7=accurate, 4=minor issues, 1=errors |

### Authority (25 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Author/site recognized | 10 | 10=well known, 5=some recognition, 0=unknown |
| External citations/mentions | 8 | 8=many, 5=some, 2=few, 0=none |
| Topic authority signals | 7 | 7=strong, 4=moderate, 1=weak |

### Trust (25 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Sources properly cited | 8 | 8=well cited, 5=some, 2=rarely, 0=never |
| Transparent/honest | 7 | 7=very transparent, 4=adequate, 1=questionable |
| Trust signals present | 5 | 5=about, contact, policies, 3=partial, 0=missing |
| Secure site (HTTPS) | 5 | 5=HTTPS, 0=HTTP |

---

## Keyword Optimization Scoring

### Primary Keyword (40 points max)

| Location | Points | Present? |
|----------|--------|----------|
| Title tag | 8 | □ |
| H1 | 8 | □ |
| First paragraph | 8 | □ |
| URL | 6 | □ |
| Meta description | 5 | □ |
| Image alt text | 5 | □ |

### Keyword Usage (30 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Natural keyword density (1-2%) | 10 | 10=optimal, 6=acceptable, 2=too low/high |
| No keyword stuffing | 10 | 10=natural, 5=borderline, 0=stuffed |
| Variations used naturally | 10 | 10=excellent variety, 5=some, 2=repetitive |

### Semantic Coverage (30 points max)

| Criteria | Points | Scoring |
|----------|--------|---------|
| Related terms present | 10 | 10=comprehensive, 6=good, 3=limited |
| LSI keywords included | 10 | 10=thorough, 6=adequate, 3=few |
| Topic entities covered | 10 | 10=complete, 6=most, 3=some |

---

## Performance Scoring

### Traffic Metrics (40 points max)

| Metric | Excellent | Good | Average | Poor |
|--------|-----------|------|---------|------|
| Organic sessions | +15 | +10 | +5 | 0 |
| Click-through rate | +15 | +10 | +5 | 0 |
| Position (avg) | +10 | +7 | +4 | 0 |

**Scoring thresholds:**
- CTR: >5%=Excellent, 3-5%=Good, 1-3%=Average, <1%=Poor
- Position: 1-3=Excellent, 4-10=Good, 11-20=Average, >20=Poor

### Engagement Metrics (30 points max)

| Metric | Excellent | Good | Average | Poor |
|--------|-----------|------|---------|------|
| Time on page | +10 | +7 | +4 | 0 |
| Bounce rate | +10 | +7 | +4 | 0 |
| Pages/session | +10 | +7 | +4 | 0 |

**Scoring thresholds:**
- Time: >4min=Excellent, 2-4min=Good, 30s-2min=Average, <30s=Poor
- Bounce: <40%=Excellent, 40-60%=Good, 60-80%=Average, >80%=Poor

### Technical Performance (30 points max)

| Metric | Excellent | Good | Average | Poor |
|--------|-----------|------|---------|------|
| LCP | +10 | +7 | +4 | 0 |
| INP | +10 | +7 | +4 | 0 |
| CLS | +10 | +7 | +4 | 0 |

**Scoring thresholds (using Google's):**
- LCP: <2.5s=Excellent, 2.5-4s=Good, >4s=Poor
- INP: <200ms=Excellent, 200-500ms=Good, >500ms=Poor
- CLS: <0.1=Excellent, 0.1-0.25=Good, >0.25=Poor

---

## Final Score Calculation Template

```
ON-PAGE SEO: ___/100 × 0.25 = ___
├── Title: ___/25
├── Meta: ___/15
├── Headers: ___/20
├── URL: ___/10
├── Links: ___/15
└── Images: ___/15

CONTENT QUALITY: ___/100 × 0.30 = ___
├── Comprehensiveness: ___/20
├── Relevance: ___/20
├── Accuracy: ___/20
├── Originality: ___/20
└── Readability: ___/20

E-E-A-T: ___/100 × 0.20 = ___
├── Experience: ___/25
├── Expertise: ___/25
├── Authority: ___/25
└── Trust: ___/25

KEYWORD: ___/100 × 0.15 = ___
├── Primary: ___/40
├── Usage: ___/30
└── Semantic: ___/30

PERFORMANCE: ___/100 × 0.10 = ___
├── Traffic: ___/40
├── Engagement: ___/30
└── Technical: ___/30

TOTAL SCORE: ___/100
```
