# Keyword Research Quick Reference

## Search Intent Cheat Sheet

| Intent | German Signals | English Signals | Content Type |
|--------|----------------|-----------------|--------------|
| Transactional | kaufen, bestellen, buchen, preis, kosten, termin | buy, order, book, price, cost, appointment | Service pages, pricing, booking |
| Commercial | vergleich, beste, test, erfahrung, bewertung | comparison, best, review, rating, vs | Comparison pages, reviews |
| Informational | wie, was, warum, anleitung, tipps, lernen | how, what, why, guide, tips, learn | Blog, FAQ, guides |
| Navigational | [brand], [company name], [location] | [brand], [company name], [location] | Homepage, about, contact |

## Keyword Difficulty Indicators

### Easy (Target immediately)
- Forums/Reddit in top 10
- Thin content ranking (< 500 words)
- Small local businesses only
- No major brands
- Low backlink profiles
- **Action:** Create better content, rank quickly

### Medium (Target with quality content)
- Mix of local and regional sites
- Some comprehensive content
- 1-2 known brands present
- Achievable with good content + basic SEO
- **Action:** Invest in comprehensive content

### Hard (Long-term target)
- Major brands dominating
- Comprehensive guides ranking (2000+ words)
- Strong backlink profiles (50+ referring domains)
- Requires authority building
- **Action:** Build authority first, target in 6+ months

### Very Hard (Consider alternatives)
- Wikipedia, government, major portals
- Saturated market
- Very high backlink requirements
- **Action:** Find long-tail alternatives

## Swiss/German Market Specifics

### Regional Search Variations
- `.ch` domains preferred for Swiss searches
- `.de` results appear for German-language queries
- Google.ch vs Google.de show different results

### Language Considerations
- Swiss German spelling variations exist
- French/Italian Switzerland = different keywords entirely
- German umlauts: ä, ö, ü (also searched as ae, oe, ue)

### Local Search Patterns
- City names: Zürich, Basel, Bern, Genf, Lausanne
- Canton abbreviations: ZH, BE, BS, GE, VD, TI
- Regions: Deutschschweiz, Romandie, Tessin
- "in der Nähe" (nearby) triggers local results

## SERP Feature Optimization

| Feature | How to Target | Priority |
|---------|---------------|----------|
| Featured Snippet | Lists, tables, direct answers, 40-60 word paragraphs | High |
| Local Pack | Google Business Profile + NAP consistency | High for local |
| FAQ Rich Results | Schema markup + clear Q&A format | Medium |
| Images | Descriptive ALT, fast loading, image sitemap | Medium |
| Sitelinks | Clear site structure, internal linking | Low (earned) |
| Videos | YouTube presence, video schema | Optional |

## Keyword Mapping Best Practices

### One Primary Keyword Per Page
- Avoid keyword cannibalization
- Each page targets unique primary keyword
- Related keywords support the primary

### Homepage Formula
```
[Primary Service] + [Location] + [Brand]
Example: "Webdesign Zürich - Local Studios"
```

### Service Page Formula
```
[Specific Service] + [Location] + [Benefit]
Example: "Website erstellen lassen Zürich - Professionell & Schnell"
```

### About Page Formula
```
[Brand] + [Trust Keyword] + [Location]
Example: "Über Local Studios - Webdesign Agentur Zürich"
```

### Contact Page Formula
```
[Contact/Booking] + [Service] + [Location]
Example: "Kontakt - Webdesign Beratung Zürich"
```

## Keyword Density Guidelines

| Content Type | Primary Keyword | Secondary Keywords |
|--------------|-----------------|-------------------|
| Homepage | 1-2% | Natural use |
| Service Page | 1.5-2% | 0.5-1% each |
| Blog Post | 1-1.5% | Natural use |
| About Page | 0.5-1% | Natural use |

### Placement Priority
1. Title tag (required)
2. H1 heading (required)
3. First 100 words (required)
4. H2 headings (recommended)
5. Image ALT text (recommended)
6. Meta description (recommended)
7. URL slug (recommended)

## Quick Competitor Analysis Template

For each competitor, quickly note:

```
Competitor: [Name]
URL: [domain]
Title: [their title tag]
H1: [their H1]
Word Count: ~[estimate]
Strengths: [1-2 points]
Weaknesses: [1-2 gaps we can exploit]
Keywords: [what they target]
```

## WebSearch Query Templates

### Finding Competitors
```
[primary keyword]
[primary keyword] [location]
best [service] [location]
[service] [location] bewertung
```

### Finding Long-tail Keywords
```
[primary keyword] für [audience]
[primary keyword] [specific feature]
[primary keyword] kosten
wie [service action]
was ist [service]
```

### Finding Question Keywords
```
[primary keyword] fragen
was kostet [service]
wie funktioniert [service]
warum [service benefit]
[service] oder [alternative]
```

## Common Mistakes to Avoid

1. **Targeting too broad** - "Webdesign" alone is too competitive
2. **Ignoring intent** - Don't put transactional keywords on informational pages
3. **Keyword stuffing** - Max 2% density, write naturally
4. **Cannibalization** - Multiple pages targeting same keyword
5. **Ignoring local** - [service] + [city] is often easier to rank
6. **No long-tail** - These are your quick wins
7. **Forgetting questions** - FAQ keywords = featured snippet potential
