---
name: serial-position-effect
description:
  Los items al inicio y final de listas se recuerdan mejor. Use cuando ordene
  menús, listas, navegación, o cualquier secuencia de elementos.
metadata:
  author: ux-ui-skills
  version: "1.0"
  category: behavioral-effects
---

# Efecto de Posición Serial

## Resumen

En una lista de elementos, las personas tienden a recordar mejor los primeros
items (efecto de primacía) y los últimos (efecto de recencia), mientras que los
del medio se olvidan con mayor facilidad.

## Origen

- **Autor**: Hermann Ebbinghaus
- **Año**: 1885
- **Fuente**: "Memory: A Contribution to Experimental Psychology"

## Fundamento Psicológico

El **efecto de primacía** ocurre porque los primeros items tienen más tiempo
para ser procesados y transferidos a memoria a largo plazo. El **efecto de
recencia** existe porque los últimos items aún están en memoria de trabajo
cuando se pide recordar.

## Aplicación en Diseño

### Navegación

- Items más importantes al inicio y final
- Menús con acciones clave en extremos
- Home y Contact/Help en posiciones prominentes
- Evitar acciones críticas en el medio

### Listas y Cards

- Contenido destacado primero o último
- Recomendaciones principales en extremos
- CTAs al inicio o final de listas
- Información menos importante en medio

### Formularios

- Campos más importantes primero
- Acciones de submit al final
- Agrupar campos medios en secciones
- Resumen al final antes de confirmar

### Onboarding

- Primera impresión crucial
- Pasos medios pueden ser más largos
- Final memorable con celebración
- "First value" temprano

## Ejemplos

- **iOS Tab Bar**: Home y Profile en extremos
- **Amazon**: Product title primero, Buy button visible
- **Gmail**: Inbox y Compose prominentes
- **Netflix**: Contenido destacado al inicio de rows
- **Slack**: Channels importantes arriba y abajo

## Anti-patterns

- ❌ CTAs enterrados en medio de listas
- ❌ Información crucial en posición media
- ❌ Menús con items aleatorios sin orden
- ❌ Navegación sin jerarquía de importancia
- ❌ Formularios con campos críticos en medio

## Métricas

- **Click-through by Position**: CTR según posición en lista
- **Recall by Position**: Test de memoria por ubicación
- **Scroll Depth**: Qué tan lejos llegan usuarios
- **First/Last Item Engagement**: Interacción en extremos

## Principios Relacionados

- [[von-restorff-effect]] - Destacar elementos clave
- [[millers-law]] - Limitar items en lista
- [[hicks-law]] - Menos opciones, mejor recuerdo

## Referencias

- Ebbinghaus, H. (1885). "Memory: A Contribution to Experimental Psychology"
- Murdock, B.B. (1962). "The serial position effect of free recall"
- https://www.nngroup.com/articles/serial-position-effect/
