# SIAS Troubleshooting Guide

## Common Scenarios and How to Handle Them

### Scenario 1: User Missing Points for Completed Action

**User says**: "I watched the video but didn't get my point"

**Investigation**:
1. Check UserProgressEntity for the content
   - `GET /api/course/progress` with `X-User-ID` header
   - Look for `completedAt` timestamp
2. Check ledger for corresponding transaction
   - `GET /api/debug/ledger/{userId}`
   - Search for `lesson_completion` with matching content

**Possible Causes**:
- **Ledger entry missing**: UserProgress shows completed, ledger doesn't have entry
  - Fix: Rebuild ledger (`POST /api/debug/ledger/{userId}/rebuild`)
- **Progress record missing**: Ledger has entry but UserProgress empty
  - Fix: Backfill progress (`POST /api/debug/backfill-progress/{userId}`)
- **Both missing**: Neither has record
  - Investigate: Check if video reached 90% completion threshold

---

### Scenario 2: Points Don't Match Display

**Symptom**: Header shows 150, but breakdown adds to 145

**Investigation**:
```
POST /api/debug/ledger/{userId}/rebuild
Body: { "dryRun": true }
```

Look at:
- `currentState.cachedPoints` (what header shows)
- `currentState.ledgerTotal` (sum of transactions)
- `expectedTotal` (calculated from source entities)

**Possible Causes**:
- **Cache mismatch**: Sync interrupted during write
  - Fix: `POST /api/debug/ledger/{userId}/sync-points`
- **Ledger mismatch**: Transactions don't match source
  - Fix: Rebuild ledger
- **Source mismatch**: Data integrity issue
  - Escalate: Needs deeper investigation

---

### Scenario 3: Duplicate Transactions

**Symptom**: Same action credited twice

**Investigation**:
1. View full ledger: `GET /api/debug/ledger/{userId}`
2. Look for entries with same `relatedEntityId` or similar timestamps
3. Check `idempotencyKey` if present (should be unique)

**Causes**:
- Pre-SIAS data without idempotency protection
- Network retry during submission

**Fix**:
- Delete the duplicate: `DELETE /api/debug/ledger/{userId}/transaction/{txId}`
- Or rebuild (preferred): `POST /api/debug/ledger/{userId}/rebuild`

---

### Scenario 4: Biometric Points Incorrect

**Symptom**: User submitted biometric but got 0 points, or got 25 when shouldn't

**Investigation**:
```
GET /api/debug/biometric-entries/{userId}
```

Check each entry's:
- `projectDay` - is it in a valid window (7-8, 14-15, 21-22, 28-29)?
- `isPointEligible` - does entity think it should score?
- `pointsAwarded` - what was actually awarded?
- `actualLabel` vs `expectedLabel` - do they match?
- `labelMismatch` or `pointsMismatch` flags

**Common Issues**:
- **Outside window**: Submitted on Day 13 (not 14-15)
  - Resolution: Explain window rules to user; no fix if rules are correct
- **Already had entry in window**: First entry scored, second didn't
  - Resolution: Correct behavior; explain to user
- **Missing baseline**: Week 1 didn't score because no baseline
  - Check if Day -2 to 7 had a submission
- **Day 8/15/22/29 not recognized**: The 48-hour windows include BOTH days
  - Example: Day 8 is valid for Week 1 (not just Day 7)
  - If entry on Day 8 shows 0 points, rebuild will fix it

---

### Scenario 4B: Biometric Shows "Tracking Only" Instead of "Scored Entry"

**Symptom**: User sees "Tracking Only" in their Weigh-In Log, but they should have earned points

**Investigation**:
```
GET /api/debug/biometric-entries/{userId}
```

Check:
- Is `actualLabel` showing "Tracking Only"?
- Is `expectedLabel` showing "Scored Entry"?
- Is `labelMismatch: true`?

**Cause**: The `WeeklyBiometricEntity` metadata was not updated when points were awarded:
- `pointsAwarded` is 0 or null
- `isPointEligible` is false
- `weekNumber` is wrong or null

**Fix**: Rebuild ledger - it now updates the entity metadata:
```
POST /api/debug/ledger/{userId}/rebuild
Body: { "dryRun": false }
```

The rebuild will:
- Award points for valid biometric submissions
- Update `WeeklyBiometricEntity` with `pointsAwarded`, `weekNumber`, `isPointEligible`
- This makes the UI show "Scored Entry" correctly

**Verification**:
After rebuild, run biometric-entries again and verify:
- `actualLabel` matches `expectedLabel`
- `labelMismatch: false`
- `pointsMismatch: false`

---

### Scenario 5: Messy Ledger (Reconciliation Entries)

**Symptom**: Ledger has many `reconciliation` or `compensating` entries

**Cause**: Previous SIAS runs or manual fixes

**Assessment**:
1. Run dry-run rebuild to see expected vs actual
2. If significant gap, rebuild is cleaner

**Fix**:
```
POST /api/debug/ledger/{userId}/rebuild
Body: { "dryRun": false, "preserveReferrals": true }
```

This will:
- Delete all non-referral transactions
- Recreate from source entities
- Result in clean ledger

---

### Scenario 6: Missing Activity History (Lessons/Quizzes Not Showing)

**Symptom**: Dashboard Activity History is empty or shows fewer lessons than expected

**Investigation**:
1. Check course history API:
   ```bash
   curl -s "https://28dayreset.com/api/course/history" -H "X-User-ID: {targetUserId}"
   ```
2. Count lessons returned vs expected
3. Check ledger: `GET /api/debug/ledger/{userId}`
4. Look for lesson_completion entries with `relatedEntityId: null`

**Causes**:
- **Null relatedEntityId**: Old entries created before proper tracking
- **Wrong relatedEntityId format**: UI expects `{enrollmentId}:{contentId}`
- **Legacy completions with pointsAwarded=0**: Old records before points tracking

**Fix**: Rebuild ledger - reconstructs all lesson entries with proper format:
```
POST /api/debug/ledger/{userId}/rebuild
Body: { "dryRun": false }
```

The rebuild will:
- Create lesson transactions with `relatedEntityId: {enrollmentId}:{contentId}`
- Award 1 point for completed videos even if source has `pointsAwarded: 0`
- Preserve original `completedAt` timestamps

**Verification**:
After rebuild, check course history again - should now show all lessons with titles

---

### Scenario 7: Referral Points Wrong

**Symptom**: User should have more/fewer referral points

**Investigation**:
1. Count referrals: Look at users with `recruitedById` = this user
2. Check referral ledger entries
3. Verify each recruit is active

**Important**: NEVER reduce referral points without strong evidence of fraud

**If Missing Points**:
- Add transaction:
```
POST /api/debug/ledger/{userId}/add-transaction
Body: {
  "transactionType": "referral_participant",
  "points": 5,
  "relatedUserId": "{recruitId}",
  "description": "Referral credit for {Name}"
}
```

---

### Scenario 8: Daily Habits Not Scoring

**Symptom**: User logs habits but points don't increase

**Investigation**:
1. Check DailyScoreEntity: What date is the entry for?
2. Check project day: Is it Day 1-28?
3. Check ledger: Is there a `daily_habit` entry?

**Common Issues**:
- **Outside window**: Day 0 or Day 29+ doesn't score
- **Already scored today**: Max 3 points per day
- **Timezone mismatch**: Server vs user timezone

---

### Scenario 9: Quiz Didn't Award Points

**Symptom**: User passed quiz but no points

**Investigation**:
1. Check UserProgress for quiz: Was it marked completed?
2. Check score: Was it ≥85% (passing)?
3. Check ledger: Is there a `quiz_completion` entry?
4. Check attempts: Were they within max attempts?

**Causes**:
- Score below passing threshold
- Already completed (duplicate attempt)
- Ledger write failed (rebuild will fix)

---

### Scenario 10: System-Wide Issue

**Symptom**: Multiple users report same problem

**Investigation**:
1. Run batch audit: `GET /api/debug/sias-batch?mode=dry_run&offset=0`
2. Look for patterns in `affectedUsers`
3. Check recent deployments or data migrations

**Escalation**:
- This needs human review
- Document pattern, affected user count, and common characteristics
- Do NOT batch-fix without explicit permission

---

## Error Codes and Responses

| Code | Meaning | Action |
|------|---------|--------|
| 200 | Success | Proceed |
| 400 | Bad request | Check parameters |
| 400 + "No enrollment" | User not enrolled | Can't audit until enrolled |
| 404 | User not found | Verify user ID |
| 409 | Conflict | Retry after delay |
| 429 | Rate limited | Wait 60s |
| 500 | Server error | Check logs, may need support |

---

## When to Escalate

**Always escalate** these situations to human review:
- Discrepancy > 100 points
- User is complaining/disputing
- Pattern affects multiple users
- Data seems fraudulent
- You're not confident in the fix

**How to escalate**:
1. Document findings thoroughly
2. Include all evidence gathered
3. State your hypothesis and confidence level
4. List what you've already tried
5. Recommend next steps for human reviewer
