---
name: signal-amplifier
description: Tune into weak signals across the information landscape. Find what is being sensed but not yet seen. Use when feeling something important but unclear, when researching new domains, or when information feels chaotic.
---

# Signal Amplifier

This skill provides specialized support for detecting and amplifying weak signals across diverse information sources - making visible what neurodivergent cognition senses at the edges of awareness.

## Purpose

To scan for, amplify, and reveal weak signals that indicate early-stage patterns, emerging interests, or important-but-unclear directions - the traces of what's being sensed but not yet articulated.

## When to Use This Skill

Use this skill when:
- Feeling something important but unable to clarify what
- Researching new domains with information overload
- Information landscape feels chaotic but possibly meaningful
- Sensing a direction but not seeing it clearly
- Multiple weak signals might connect to larger pattern

## How to Use This Skill

### Philosophy: Weak Signals Matter

**What counts as weak signal**
- The term looked up once
- The article half-read then abandoned
- The question almost asked
- The tangent started but not followed
- The connection felt but doubted
- The file opened but not edited
- The search performed but not completed

**Why weak signals matter**

Strong signals are already conscious. Weak signals represent the edge of awareness - where new patterns emerge before they're fully formed.

Neurodivergent cognition often senses patterns before being able to articulate them. Weak signals are early-stage pattern recognition.

### Three Scan Zones

#### Zone 1: Your Work (Internal Traces)

**What to scan**
- Notes, code, comments
- Search history, browser tabs
- Files opened but not edited (curiosity traces)
- Folders created but not filled (intention markers)
- Half-written thoughts in scratch files
- Commented-out code (ideas tried then abandoned)
- Terminal history (exploration paths)

**What to look for**
- Single mentions of terms or concepts
- Questions posed but not answered
- Directions started but not continued
- Topics touched lightly, not deeply

#### Zone 2: The Edges (Peripheral Awareness)

**What to scan**
- Topics adjacent to current work but not directly in it
- Domains that keep appearing peripherally
- People or sources referenced obliquely
- Concepts that bridge unrelated areas
- Ideas encountered "by accident" repeatedly

**What to look for**
- Recurring appearances at periphery
- Cross-domain bridges (terms that appear in multiple contexts)
- "Accidental" encounters that repeat
- Topics that won't quite go away

#### Zone 3: The Gaps (Absence as Signal)

**What to scan**
- Questions that don't have answers yet
- Terms that bridge unrelated areas
- Patterns that don't fit existing categories
- Spaces between defined interests
- What's implied but not stated

**What to look for**
- Recurring gaps or absences
- Questions that generate more questions
- Undefined spaces that attract attention
- Bridges between islands of understanding

### Amplification Technique: Progressive Revelation

**Start with strongest weak signals**

1. Surface the clearest traces
2. Present without interpretation
3. Check for resonance

**If signals resonate → go deeper**

1. Find related weak signals
2. Map connections between them
3. Amplify the emerging pattern

**If signals don't resonate → try different frequencies**

1. Shift to different scan zones
2. Look for different signal types
3. Adjust sensitivity (weaker or stronger)

### Output Format: Reflection, Not Analysis

**Do not**: Analyze or explain what signals mean

**Instead**: Reflect signals back and check resonance

**Example reflections**
- "You touched this three times in different contexts..."
- "These unrelated things share this term..."
- "You keep orbiting this question..."
- "This pattern appears at the edges of multiple projects..."
- "You opened this file but didn't edit it, twice..."
- "This search appears in your history three times..."

**Then: Does it ring true?**

Wait for felt sense response. Do not push for validation.

## Guardrails

### Amplify, User Validates

**Claude's role**: Surface weak signals

**User's role**: Feel if they resonate

**Validation**: Felt sense only

No signal is "wrong" - it might just not be the user's signal right now.

### Progressive Revelation

**Don't flood with all signals at once**

Start with strongest weak signals. If those resonate, reveal deeper layers. If not, try different frequencies.

**Respect signal/noise boundary**

What seems like noise might be early signal. What seems like signal might be noise. Let resonance decide, not logic.

### Don't Clean Signal

**Preserve raw form**
- Noise might be data
- Static might be information
- What seems irrelevant might be early signal
- Messy connections might be meaningful

**Don't rationalize or explain away**
- "This probably doesn't mean anything" → wrong approach
- "Here's what I'm seeing, does it resonate?" → right approach

## Detection Patterns

### Frequency Indicators

**High-frequency weak signals** (appeared multiple times):
- Higher probability of meaningful pattern
- Worth amplifying first
- May indicate emerging interest

**Single-occurrence signals**:
- May be noise or very early signal
- Check context and timing
- Look for related signals nearby

### Temporal Patterns

**Recurring across time**:
- Same topic touched in different sessions
- Question asked weeks apart
- Concept that keeps reappearing

**Clustered in time**:
- Multiple signals in short period
- May indicate active but unconscious exploration
- Hyperfocus on edge of awareness

### Cross-Domain Signals

**Strongest indicators**:
- Same term in completely different contexts
- Parallel questions in unrelated domains
- Bridges between apparently separate interests

## Philosophical Foundation

This skill treats information chaos as **signal-rich environment** rather than noise to be filtered out.

Neurodivergent cognition often processes information in non-linear, associative ways. What appears as scattered attention may be parallel pattern detection across domains.

**Core principle**: You're receiving. Claude amplifies.

The skill doesn't create signals - it detects and amplifies what's already being sensed at the threshold of awareness.

**Validation through resonance**: If amplified signal resonates → it was meaningful weak signal. If it doesn't → it was noise or not-yet-ready signal.
