---
name: sit-spot-daily-lesson
description: Generate Sit Spot Club daily lessons and audio scripts in the Sit Spot Club voice. Use for daily lessons, sit spot practices, sensory awareness curriculum, and guided audio scripts.
---

# Sit Spot Club Daily Lesson Skill

## Purpose

Produce structured daily Sit Spot Club lessons that guide sensory attention, support habit formation, and maintain a consistent Sit Spot Club voice across written and audio formats.

## Outputs

This Skill may generate:
- Written daily lessons
- WHY THIS WORKS sections (academic register only, APA citations required)
- ElevenLabs v3–compatible audio scripts using Audio Tags

## Required Files

- voice_guidelines_written.md
- voice_guidelines_audio.md
- resources/elevenlabs_audio_tags.md

## Execution Order

1. Read SKILL.md
2. Load the appropriate voice guidelines based on requested output
3. Follow all structural and linguistic constraints
4. Refuse or return “need more data” if citation requirements cannot be met

## When Not To Use This Skill

Do not use for:
- Marketing copy
- Motivational writing
- Therapy or coaching language
- Fiction or metaphor-heavy content

## Lesson Section: PREPARE

The PREPARE section introduces the day's sensory focus with a brief preview and accessible explanation.

Structure:
- 1-3 sentences total
- Present tense, direct tone
- First: Preview what sense or quality will be noticed today
- Second: Brief, plain-language explanation of why this matters (1 sentence)
- No scientific jargon (save for WHY THIS WORKS)
- No motivation or outcome promises

Example (correct):
"Today you'll notice temperature on your skin. This is one of your oldest senses, designed to keep you safe and aware of your environment."

Example (correct):
"Today's practice is about texture. Touch is the first sense you developed, and it's your most reliable anchor to the present moment."

Example (incorrect):
"Today we're going to explore the amazing world of thermoreception, which activates your parasympathetic nervous system and will help you feel deeply grounded!"

The PREPARE section does not include:
- Arrival instructions (those belong in SENSORY FOCUS)
- Academic citations or technical terms (belong in WHY THIS WORKS)
- Motivational language
- Outcome promises or therapeutic framing

## Lesson Section: WHATSAPP PROMPT

The WHATSAPP PROMPT encourages engagement by inviting simple reflection or sharing related to the day's lesson.

Structure:
- 1-2 sentences maximum
- Direct question or invitation to share
- Relates specifically to the day's sensory focus
- Neutral, conversational tone
- No emojis or excessive enthusiasm
- No pressure to respond or participate

Example (correct):
"What texture surprised you today?"

Example (correct):
"Did you notice any temperature differences you hadn't felt before?"

Example (correct):
"Share one sound you tracked today."

Example (incorrect):
"We'd LOVE to hear about your amazing temperature sensing journey! Drop a comment and let's celebrate together! 🎉"

Example (incorrect):
"Comment below if you're committed to showing up tomorrow!"

The WhatsApp prompt should:
- Invite, not demand
- Ask about specific sensory details from today's practice
- Be brief and grounded
- Feel like a genuine question, not a marketing tactic

## Generating Complete Lessons for Days 13-31

When generating lessons for Days 13-31, use the metadata from `lesson_index.md` combined with the structural patterns from `resources/sitspotsessions_day1-12.txt`.

### Required Files

Before generating any lesson, read:
- `lesson_index.md` - metadata table for all days
- `resources/sitspotsessions_day1-12.txt` - structural reference for lesson format
- `resources/sitspotsessions_reflections-day13-31.txt` - specific quotes for Days 13-31
- `voice_guidelines_written.md` - voice and tone guidelines
- `voice_guidelines_audio.md` - audio script guidelines (when generating audio)
- `resources/elevenlabs_audio_tags.md` - audio tags reference (when generating audio)

### Metadata Fields

The lesson_index.md table contains these fields for each day:
- **Day**: Day number (1-31)
- **Week**: Week number and phase name (e.g., "1. Awareness", "2. Tuning In")
- **Sensory Focus**: Primary sense(s) with scientific term in brackets (e.g., "Touch/Pressure [Tactition]")
- **Week Name**: Full contextual description of the week's theme
- **Calendar Heading**: Brief title for the day
- **Calendar Prompt**: 1-2 sentence practice summary
- **Paid Prompt (Detailed)**: Full practice instructions (foundation for SENSORY FOCUS section)
- **Scientific Basis**: Evolutionary, fetal development, and neuroscience context (foundation for WHY THIS WORKS)

### Complete Lesson Structure

Each lesson for Days 13-31 must include these sections in order:

#### 1. Header Block
```
DAY [N]: [CALENDAR HEADING] [emoji if appropriate]
Awareness [progress indicator based on week]
Sensory Focus: [Sensory Focus from metadata]
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

Progress indicators by week:
- Week 1 (Days 1-8): [●○○○]
- Week 2 (Days 9-15): [●●○○]
- Week 3 (Days 16-23): [●●●○]
- Week 4 (Days 24-31): [●●●●]

#### 2. PREPARE Section
- 1-3 paragraphs introducing the day's sensory focus
- Use Calendar Prompt as starting inspiration but expand with context
- Present tense, direct tone
- Plain-language explanation of why this sense matters
- Must include "Summary of the practice:" bulleted list
- No scientific jargon (save for WHY THIS WORKS)
- No motivational language or outcome promises

#### 3. SENSORY FOCUS Section
- Core practice instructions derived from "Paid Prompt (Detailed)" field
- Step-by-step guidance in present tense
- Specific, actionable sensory instructions
- Include safety valves: "If focusing inward feels uncomfortable, immediately open your eyes and focus on one solid external object"
- Direct, imperative voice
- May include variations or options
- Concrete sensory targets (what to notice, where to direct attention)

#### 4. Special Day-Specific Sections

**Take a Day Photo** (Days 1 and 31 only):
- Day 1: Instructions to take initial photo
- Day 31: Instructions to take comparison photo and reflect on changes

**SIT SPOT CHECK** (End of each week: Days 8, 15, 23, 31):
```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
SIT SPOT CHECK
Before you leave, ask yourself: Will this spot work again tomorrow? If not, what needs to adjust?
Too cold? Bring a blanket or extra layer.
Uncomfortable seat? Grab a cushion.
Hard to access? Pick somewhere closer.
Feels unsafe? Choose a more secure location.
Small adjustments now prevent skipping later.
Choose the place you're most likely to return to on your worst day, not your best day.
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

**IF YOU MISS A DAY** (Days 1-7 only):
```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
IF YOU MISS A DAY
Simply return to that day's practice when you can.
The nervous system learns through repetition, not perfection. Missing days is part of the process. What matters is that you came back.
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

#### 5. REFLECTION Section
```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
REFLECTION
[Quote from resources/sitspotsessions_reflections-day13-31.txt for this specific day]
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

For Days 13-31, retrieve the exact quote from the reflections file matching the day number.

#### 6. WHATSAPP Section
```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
WHATSAPP
[Question related to day's practice following WHATSAPP PROMPT guidelines]

[Button CTA text related to the question]
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

Format:
- First line: Question related to the sensory practice
- Second line: Blank line
- Third line: Button CTA in brackets, related to the question (e.g., [Share your rhythm], [Tell us what you noticed])

#### 7. RESOURCES Section (optional, include for most days)
```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
RESOURCES
Need a reminder of the full practice? [Link to website resource]
Having trouble? [Link to FAQ or Indoor Adaptations]
Questions? Want to share? Reply to this email or join the conversation in our WhatsApp community [Link]
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

#### 8. AUDIO SCRIPT Section (when requested)
Generate ElevenLabs v3-compatible audio script using:
- voice_guidelines_audio.md
- resources/elevenlabs_audio_tags.md
- Pattern from Days 1-12 audio scripts

Structure:
- [conversational] opening (context, why this sense)
- [pause] [softer] [slower] transition
- Guided practice with embedded pauses
- Extended silence (~9 minutes total)
- [Bells] closing sequence

### Generation Guidelines

1. **No em dashes**: Use colons, parentheses, commas, or regular hyphens instead of em dashes throughout the lesson
2. **Maintain week-level coherence**: Reference the week's theme (from Week Name field) when appropriate
3. **Progressive difficulty**: Later days assume mastery of earlier practices
4. **Cross-reference when relevant**: Days with dual sensory focuses or integration practices should reference earlier single-sense days
5. **Consistent safety language**: Always include grounding options ("open your eyes," "look at one solid object")
6. **Voice consistency**: Follow voice_guidelines_written.md for all written sections
7. **Emoji use**: Minimal and only when aligned with sensory theme
8. **WHY THIS WORKS**: Do not generate this section; it will be added separately from SciSpace research

### Output Format

When generating Days 13-31 as a consolidated file:
- Separate each day with: `______` followed by blank line
- Maintain consistent heading hierarchy
- Preserve all separator lines (━━━━━━━━━━)
- Include complete sections for each day
- End each lesson before starting the next

### Example Workflow

When asked to generate a specific day (e.g., Day 13):
1. Read lesson_index.md and locate Day 13 metadata
2. Read resources/sitspotsessions_reflections-day13-31.txt for Day 13 quote
3. Extract all metadata fields for Day 13
4. Use Calendar Heading for title
5. Expand Calendar Prompt into PREPARE section with required "Summary of the practice:" bulleted list
6. Transform Paid Prompt (Detailed) into SENSORY FOCUS section
7. Insert exact REFLECTION quote from reflections file
8. Generate appropriate WHATSAPP prompt with question and button CTA
9. Include special sections if applicable (SIT SPOT CHECK for Days 8, 15, 23, 31)
10. Create AUDIO SCRIPT if requested, following audio guidelines
11. Do not include WHY THIS WORKS section (added separately from SciSpace)
12. Ensure no em dashes appear anywhere in the lesson