# Agent Skill Template

Use this template as a starting point for creating new Agent Skills.

## File: SKILL.md

```yaml
---
name: your-skill-name
description: Clear description of what this skill does and when to use it. Explain the main capabilities and use cases in under 1024 characters.
license: MIT
compatibility: List any system requirements, language versions, or dependencies
metadata:
  author: your-name
  version: "1.0"
  category: your-category
---

# Your Skill Name

## Overview

Brief introduction explaining what this skill does and why it's useful. Keep it concise - 2-3 sentences.

## Quick Start

Provide a simple example to get started immediately:

```bash
# Example command or code
echo "Hello from your skill"
```

## Main Features

### Feature 1: [Feature Name]

Describe the feature and provide examples:

```bash
# Example usage
command --option value
```

### Feature 2: [Feature Name]

More detailed instructions with step-by-step guidance:

1. First step
2. Second step
3. Third step

Example:
```python
# Python example
def example_function():
    return "result"
```

## Common Tasks

### Task 1: [Common Use Case]

Instructions for a frequent task:

```bash
# Solution
command to solve the task
```

### Task 2: [Another Use Case]

Another common scenario with examples.

## Examples

### Example 1: Basic Usage

**Input:**
```
Sample input
```

**Output:**
```
Expected output
```

**Explanation:** Why this works and what it demonstrates.

### Example 2: Advanced Usage

More complex example showing advanced features.

## Troubleshooting

### Issue: Common Problem

**Symptoms:** What the user sees

**Solution:** How to fix it

**Prevention:** How to avoid it in the future

## Best Practices

- Tip 1: Important guideline
- Tip 2: Another best practice
- Tip 3: Common pitfall to avoid

## Reference

Additional details, links to documentation, or advanced topics:

- Link to external resource
- Link to related skills
- Link to API documentation

## See Also

- [Related Skill 1](path/to/skill)
- [Related Skill 2](path/to/skill)
- [External Documentation](https://example.com)
```

## Directory Structure Template

```
your-skill-name/
├── SKILL.md                    # Main skill file (required)
├── references/                 # Optional: Additional documentation
│   ├── advanced.md            # Advanced usage guide
│   ├── api-reference.md       # Detailed API documentation
│   └── examples.md            # Extended examples
├── scripts/                    # Optional: Helper scripts
│   ├── setup.sh              # Installation/setup script
│   ├── helper.py             # Utility functions
│   └── README.md             # Script documentation
└── assets/                     # Optional: Supporting files
    ├── diagram.png           # Visual aids
    ├── template.txt          # File templates
    └── sample-input.json     # Sample data files
```

## Minimal Example

For a simple skill, you only need one file:

```
hello-skill/
└── SKILL.md
```

## Tips for Writing Great Skills

1. **Start with the description**: Write a clear, concise description first
2. **Think about discovery**: Include keywords that help agents find your skill
3. **Show, don't just tell**: Provide working examples for every major feature
4. **Test your examples**: Make sure all code snippets actually work
5. **Consider the audience**: Write for agents that need clear, unambiguous instructions
6. **Keep it focused**: One skill should do one thing well
7. **Version your skill**: Use semantic versioning in metadata
8. **Document dependencies**: List all requirements clearly
9. **Provide context**: Explain when and why to use the skill
10. **Iterate**: Start simple and add features based on usage

## Checklist Before Publishing

- [ ] Skill name is lowercase with hyphens only
- [ ] Folder name matches the `name` in frontmatter
- [ ] YAML frontmatter is valid (test with a YAML parser)
- [ ] `name` field is present
- [ ] `description` field is present and clear
- [ ] Description is under 1024 characters
- [ ] All code examples are tested and work
- [ ] Relative paths are used for internal references
- [ ] License is specified if sharing publicly
- [ ] README or documentation explains how to use the skill
- [ ] No sensitive information (API keys, passwords) in files
- [ ] File paths are relative from skill root
- [ ] Total size is reasonable (aim for <5000 tokens in SKILL.md)

## Quick Reference: YAML Frontmatter Fields

| Field | Required | Description | Example |
|-------|----------|-------------|---------|
| `name` | Yes | Skill identifier (lowercase, hyphens) | `pdf-processing` |
| `description` | Yes | What and when (max 1024 chars) | `Extract text from PDFs...` |
| `license` | No | License type or file path | `MIT`, `LICENSE.txt` |
| `compatibility` | No | System requirements | `Linux, Python 3.10+` |
| `metadata` | No | Custom key-value pairs | `author: name` |
| `allowed-tools` | No | Approved tools (experimental) | `pdftotext qpdf` |

## Common Patterns

### Pattern 1: Task-Focused Skill
Focus on accomplishing specific tasks (file processing, testing, deployment)

### Pattern 2: Knowledge Skill
Provide expertise in a domain (language syntax, API usage, best practices)

### Pattern 3: Workflow Skill
Guide through multi-step processes (setup procedures, checklists)

### Pattern 4: Tool Wrapper Skill
Simplify complex tool usage with clear examples and patterns

## Additional Resources

- Specification: https://agentskills.io/specification
- Documentation: https://agentskills.io
- Example Skills: https://github.com/anthropics/skills
- Community: https://github.com/agentskills/agentskills
